<?php

/**
 * Class TX_Welcome_Panel.
 */
class TX_Welcome_Panel extends TX_Singleton {

	/**
	 * TX_Welcome_Panel constructor.
	 */
	protected function __construct() {
		$this->hooks();
	}

	/**
	 * Add hooks.
	 */
	private function hooks() {
		remove_all_filters( 'welcome_panel' );
		add_action( 'welcome_panel', array( $this, 'welcome_panel_template' ) );
	}

	/**
	 * Template welcome panel.
	 */
	public function welcome_panel_template() {
		$args = $this->get_args_welcome_template();

		return TX_Template_Helper::template( 'welcome-panel.php', $args, true );
	}

	/**
	 * Get arguments welcome template.
	 *
	 * @return array
	 */
	private function get_args_welcome_template() {
		$links       = array();
		$links['docs'] = "#";
		$links['support'] = "#";

		return array(
			'links' => $links,
		);
	}

}
