<?php

/**
 * Class TX_Export
 */
class TX_Exporter extends TX_Singleton {
	/**
	 * @var string
	 */
	private static $action = 'tx-exporter';

	/**
	 * Get base url export.
	 *
	 * @return string
	 */
	private static function get_base_url_export() {
		return admin_url( 'admin.php?action=' . self::$action );
	}

	/**
	 * Get url export package.
	 *
	 * @param $package string
	 *
	 * @return string
	 */
	public static function get_url_export( $package ) {
		$base = self::get_base_url_export();

		return add_query_arg( 'package', $package, $base );
	}

	/**
	 * TX_Export constructor.
	 */
	protected function __construct() {
		$this->hooks();
	}

	/**
	 * Add hooks.
	 */
	private function hooks() {
		add_action( 'admin_action_' . self::$action, array( $this, 'handle' ) );
	}

	/**
	 * Handle request.
	 */
	public function handle() {
		$package = isset( $_REQUEST['package'] ) ? $_REQUEST['package'] : false;

		if ( ! $package ) {
			return;
		}

		do_action( 'tx_exporter_package', $package );

		wp_die( __( 'Package not found!', 'edumodo' ) );
	}
}
