;'use strict';

(function ($, TX_Plugins_Queue) {
    function emitEvent(key_event, args) {
        $(window).trigger(key_event, args);
    }

    var Router = Backbone.Router.extend({

        routes: {
            '': 'start',
            'step-:step': 'step'
        },

        start: function () {
            this.goToStep(0);
        },

        goToStep: function (step) {
            this.navigate('step-' + step, {trigger: true});
        },

        step: function (step) {
            emitEvent('tx_gs_change_step', step);
        },

        initialize: function () {
            Backbone.history.start();
        }
    });

    var TX_GS_Model = Backbone.Model.extend({
        initialize: function () {
            console.log("Model TX_GS_Model Initialize!");
        },
        defaults: {
            isRunning: false
        }
    });

    var TX_Getting_Started = Backbone.View.extend({
        el: '.tx-getting-started',

        router: false,

        model: null,

        base_url_ajax: tx_gs.url_ajax,

        steps: tx_gs.steps,

        current_step: 0,

        events: {
            'click .txw-skip-step': 'onSkipStep',
            'click .txw-run-step': 'onClickRunStep'
        },

        /**
         * Init page getting started.
         *
         * @since 0.8.7
         */
        initialize: function () {
            var self = this;

            /**
             * On router emit event change step.
             */
            $(window).on('tx_gs_change_step', function (e, args) {
                self.goToStep(args);
            });

            $(window).on('tx_gs_complete', function () {
                self._request('finish', null)
                    .success(function (response) {
                        console.log(response);
                    });
            });

            /**
             * On key up next/back step.
             */
            $(window).on('keyup', function (e) {
                switch (e.keyCode) {
                    case 37:
                        self.backStep();
                        break;
                    case 39:
                        self.nextStep();
                        break;
                    case 13:
                        self.triggerClickRunCurrentStep();
                        break;
                }
            });

            this.model = new TX_GS_Model();
            this.model.on('change:isRunning', this.toggleButtonSkip.bind(this));

            this.router = new Router();
            this.render();

            TX_Plugins_Queue.complete(function (data) {
                var action = data.action;
                var slug = data.slug;
                var $plugin = self.$('.tx-table-plugins tr[data-plugin="' + slug + '"]');

                if (action === 'activate') {
                    $plugin.removeClass('processing');
                }

                var remain = TX_Plugins_Queue.count();
                if (remain === 1) {
                    self.$('.tx-table-plugins').removeClass('running');
                    self.model.set('isRunning', false);
                    self.nextStep();
                }
            });

            TX_Plugins_Queue.success(function (response, data) {
                var action = data.action;
                if (action !== 'activate') {
                    return;
                }

                var slug = data.slug;
                var $plugin = self.$('.tx-table-plugins tr[data-plugin="' + slug + '"]');

                if (!response || !response.success) {
                    $plugin.removeClass('processing').addClass('failed');
                    $plugin.find('.updating-message').text('You can try again later :)');
                } else {
                    $plugin.removeClass('inactive processing').addClass('active').find('.tx-input').prop('checked', false);
                    $plugin.find('.updating-message').text('Active');
                }
            });

            TX_Plugins_Queue.error(function (data) {
                var action = data.action;

                if (action !== 'activate') {
                    return;
                }

                var slug = data.slug;
                var $plugin = self.$('.tx-table-plugins tr[data-plugin="' + slug + '"]');

                $plugin.addClass('failed');
                $plugin.find('.updating-message').text('You can try again later :)');
            });
        },

        /**
         * Render view.
         *
         * @since 0.8.7
         */
        render: function () {
            this.updateHeightMain();
        },

        updateHeightMain: function () {
            var $steps = this.$('.txw-step');
            var maxHeight = 1;

            $steps.each(function () {
                var $step = $(this);
                var h = $step.height();
                if (h > maxHeight) {
                    maxHeight = h;
                }
            });

            this.$('main').height(maxHeight);
        },

        onSkipStep: function (e) {
            e.preventDefault();
            this.nextStep();
        },

        toggleButtonSkip: function () {
            if (!this.model) {
                return;
            }

            if (this.model.get('isRunning')) {
                this.$('.txw-skip-step').hide();
            } else {
                this.$('.txw-skip-step').show();
            }
        },

        goToStep: function (step) {
            if (step >= this.steps.length) {
                step = 0;
            }

            this.current_step = parseInt(step);

            if (this.steps.length - 1 === this.current_step) {
                emitEvent('tx_gs_complete');
            }

            this.$('.txw-number-step .current').text(this.current_step + 1);

            if (this.current_step + 1 === this.steps.length) {
                this.$('.txw-skip-step').hide();
            } else {
                this.$('.txw-skip-step').show();
            }

            var $run_step = this.$('.txw-run-step');
            $run_step.removeClass('updating-message');
            $run_step.attr('disabled', false);

            this.hideAllStep();
            var key = this.getKeyCurrentKeyStep();

            this.$('.txw-step.' + key).addClass('active');

            this.updateControls();
        },

        getCurrentStep: function () {
            var index = this.current_step;
            return this.steps[index];
        },

        getKeyCurrentKeyStep: function () {
            var step = this.getCurrentStep();

            return step['key'];
        },

        hideAllStep: function () {
            this.$('.txw-step').removeClass('active');
        },

        triggerClickRunCurrentStep: function () {
            var key_step = this.getKeyCurrentKeyStep();
            var $step = this.$('.txw-step.' + key_step);
            $step.find('.txw-run-step').click();
        },

        nextStep: function () {
            if (this.current_step === this.steps.length - 1) {
                return;
            }

            this.current_step++;
            this.router.goToStep(this.current_step);
        },

        backStep: function () {
            if (!this.current_step) {
                return;
            }

            this.current_step--;
            this.router.goToStep(this.current_step);
        },

        updateControls: function () {
            var $steps = this.$('.txw-controls .step');
            $steps.removeClass('active current');

            var current_step = this.current_step;

            $steps.each(function () {
                var $st = $(this);
                var p = parseInt($st.attr('data-position'));

                if (p <= current_step) {
                    $st.addClass('active');
                }

                if (p === current_step) {
                    $st.addClass('current');
                    var key_step = $st.attr('data-step');
                    $('.txw-step.' + key_step).addClass('active');
                }
            });
        },

        onClickRunStep: function (e) {
            if (this.current_step === this.steps.length - 1) {
                return;
            }

            var $btn = $(e.target);
            $btn.addClass('updating-message')
                .attr('disabled', true);

            if ($btn.is('a')) {
                window.location.href = $btn.attr('href');
                return;
            }

            var key_step = this.getKeyCurrentKeyStep();

            switch (key_step) {
                case 'quick-setup':
                    this._request_quick_setup();
                    break;

                case 'install-plugins':
                    this._request_install_plugins();
                    break;

                default:
                    this.nextStep();
                    break;
            }
        },


        _request: function (step, data) {
            var url_request = this.base_url_ajax + step;

            return $.ajax({
                url: url_request,
                method: 'POST',
                data: data,
                dataType: 'json'
            });
        },

        _request_quick_setup: function () {
            var $form = this.$('.quick-setup form');
            var data = $form.serialize();
            var self = this;
            self.model.set('isRunning', true);

            this._request('quick-setup', data)
                .success(function () {
                    self.model.set('isRunning', false);
                    self.nextStep();
                })
                .error(function (error) {
                    console.error(error);
                });
        },

        _request_install_plugins: function () {
            var self = this;

            this.model.set('isRunning', true);

            this.$('.tx-table-plugins').addClass('running');
            var $plugins = this.$('.tx-plugins input.tx-input:checked');

            if (!$plugins || !$plugins.length) {
                this.model.set('isRunning', false);
                this.$('.tx-table-plugins').removeClass('running');
                self.nextStep();
                return;
            }

            $plugins.each(function () {
                var $input = $(this);
                var slug = $input.val();
                var status = $input.attr('data-status');

                self.$('.tx-table-plugins tr[data-plugin="' + slug + '"]').addClass('processing');
                if (status === 'not_installed') {
                    TX_Plugins_Queue.push({action: 'install', slug: slug});
                }

                TX_Plugins_Queue.push({action: 'activate', slug: slug});
            });
        }
    });


    $(document).ready(function () {
        new TX_Getting_Started();
    });
})(jQuery, TX_Plugins_Queue);
