<?php

Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'LearnDash', 'edumodo' ),
    'id'     => 'learndash-options',
    'icon'   => 'el el-lines',
    'fields' => array(

        array(
            'id'       => 'learndash_single_layout_select',
            'type'     => 'select',
            'title'    => esc_html__('Single Course Style', 'edumodo'),
            'options'  => array(
                'learndash_single_one' => esc_html__('Style 1', 'edumodo'),
                'learndash_single_two' => esc_html__('Style 2', 'edumodo'),
            ),
            'default'  => 'learndash_single_two',
        ),

        array(
                'id'       => 'learndash_single_sidebar_style',
                'type'     => 'switch',
                'title'    => esc_html__('Widget Divider', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
                'required' => array( 'learndash_single_layout_select' , '=' , 'learndash_single_two' ),
        ),

        array(
                'id'       => 'enable_learndash_single_tags',
                'type'     => 'switch',
                'title'    => esc_html__('Single Page Post Tags', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
                'required' => array( 'learndash_single_layout_select' , '=' , 'learndash_single_two' ),
        ),
        
        array(
                'id'       => 'enable_learndash_single_last_update',
                'type'     => 'switch',
                'title'    => esc_html__('Single Page Last Updated', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
                'required' => array( 'learndash_single_layout_select' , '=' , 'learndash_single_two' ),
        ),

        array(
                'id'       => 'enable_learndash_single_related_courses',
                'type'     => 'switch',
                'title'    => esc_html__('Single Page Related Courses', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
        ),

        array(
            'id'       => 'learndash_single_related_course_layout',
            'type'     => 'select',
            'title'    => esc_html__('Related Course Style', 'edumodo'),
            'options'  => array(
                'ld_related_list' => esc_html__('List', 'edumodo'),
                'ld_related_grid' => esc_html__('Grid', 'edumodo'),
            ),
            'default'  => 'ld_related_list',
        ),

        array(
            'id'      => 'learndash_single_related_count',
            'type'    => 'spinner',
            'title'   => __( 'Related Item Count', 'edumodo' ),
            'default' => '3',
            'min'     => '1',
            'step'    => '1',
            'max'     => '10',
            'required' => array( 'enable_learndash_single_related_courses' , '=' , true ),
        ),

        array(
            'id'       => 'hide_mobile_learndash_single_related_courses',
            'type'     => 'switch',
            'title'    => esc_html__('Related Courses Hide Small Device', 'edumodo'),
            'default'  => true,
            'required' => array( 'enable_learndash_single_related_courses' , '=' , 1 ),
        ),
        array(
            'id'       => 'enable_learndash_single_related_dsc',
            'type'     => 'switch',
            'title'    => esc_html__('Related Courses Content', 'edumodo'),
            'default'  => true,
            'required' => array( 'enable_learndash_single_related_courses' , '=' , 1 ),
        ),

        array(
            'id'      => 'learndash_single_related_dsc_length',
            'type'    => 'spinner',
            'title'   => __( 'Content Length', 'edumodo' ),
            'default' => '5',
            'min'     => '1',
            'step'    => '1',
            'max'     => '150',
            'required' => array( 'enable_learndash_single_related_dsc' , '=' , true ),
        ),

        array(
            'id'    => 'related_see_more_text',
            'type'  => 'text',
            'title' => esc_html__('See More Text', 'edumodo'),
            'default'  => 'See More',
            'required' => array('select_header','=','header_3'),
            'required' => array( 'enable_learndash_single_related_courses' , '=' , 1 ),
        ),  

        array(
                'id'       => 'enable_learndash_single_social',
                'type'     => 'switch',
                'title'    => esc_html__('Social Shear', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
                'required' => array( 'learndash_single_layout_select' , '=' , 'learndash_single_one' ),
        ),
    )
) 
);
