<?php
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'edumodo'),
    'icon'   => 'el el-credit-card',
    'id'     => 'header_section_options',
    'fields' => array(
        array(
            'id'      => 'select_header',
            'type'    => 'image_select',
            'title'   => __('Select Variation', 'edumodo'),
            'options' => array(
                'header_1'  => array(
                    'alt' => 'Header V1',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header1.jpg',
                ),
                'header_2'  => array(
                    'alt' => 'Header V2',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header2.jpg',
                ),
                'header_3'  => array(
                    'alt' => 'Header V3',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header3.jpg',
                ),
                'header_4'  => array(
                    'alt' => 'Header V4',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header4.jpg',
                ),
                'header_5'  => array(
                    'alt' => 'Header V5',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header5.jpg',
                ),
                'header_6'  => array(
                    'alt' => 'Header V6',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header6.jpg',
                ),
                'header_7'  => array(
                    'alt' => 'Header V7',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header7.jpg',
                ),
                'header_8'  => array(
                    'alt' => 'Header V8',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header8.jpg',
                ),
                'header_9'  => array(
                    'alt' => 'Header V9',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header9.jpg',
                ),
                'header_10' => array(
                    'alt' => 'Header V10',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header10.jpg',
                ),
                'header_11' => array(
                    'alt' => 'Header V11',
                    'img' => get_stylesheet_directory_uri() . '/dist/images/header11.jpg',
                ),
            ),
            'default' => 'header_1',
        ),
        array(
            'id'       => 'top_number',
            'type'     => 'text',
            'title'    => esc_html__('Top Phone Number', 'edumodo'),
            'default'  => '+880123456789',
            'required' => array('select_header', '=', ['header_3', 'header_4', 'header_5', 'header_6']),
        ),

        array(
            'id'       => 'top_email',
            'type'     => 'text',
            'title'    => esc_html__('Top Email', 'edumodo'),
            'default'  => 'info@yoursitename.com',
            'required' => array('select_header', '=', ['header_3', 'header_4', 'header_5', 'header_6']),
        ),
        array(
            'id'       => 'top_btn_text',
            'type'     => 'text',
            'title'    => esc_html__('Top Button Text', 'edumodo'),
            'default'  => 'Apply Now',
            'required' => array('select_header', '=', 'header_3'),
        ),

        array(
            'id'       => 'top_btn_link',
            'type'     => 'text',
            'title'    => esc_html__('Top Button Link', 'edumodo'),
            'default'  => '#',
            'required' => array('select_header', '=', 'header_3'),
        ),

        array(
            'id'    => 'edumodo_logo',
            'type'  => 'media',
            'url'   => true,
            'title' => esc_html__('Logo', 'edumodo'),
        ),

        array(
            'id'    => 'edumodo_logo_2',
            'type'  => 'media',
            'url'   => true,
            'title' => esc_html__('Transparent Logo', 'edumodo'),
        ),

        array(
            'id'      => 'enable_sticky_active',
            'type'    => 'switch',
            'title'   => esc_html__('Sticky Header ', 'edumodo'),
            'default' => 0,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'       => 'enable_transparent_active',
            'type'     => 'switch',
            'title'    => esc_html__('Transparent Header ', 'edumodo'),
            'subtitle' => esc_html__('Transparent nav and header on home page only', 'edumodo'),
            'default'  => 0,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

        array(
            'id'      => 'enable_custom_header_height',
            'type'    => 'switch',
            'title'   => esc_html__('Custom Header', 'edumodo'),
            'default' => 0,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'            => 'menu_area_height',
            'type'          => 'slider',
            'title'         => __('Menu Area Height', 'edumodo'),
            'default'       => 75,
            'min'           => 50,
            'step'          => 1,
            'max'           => 500,
            'display_value' => 'label',
            'required'      => array('enable_custom_header_height', '=', true),
        ),

        array(
            'id'            => 'header_area_height',
            'type'          => 'slider',
            'title'         => __('Header Area Height', 'edumodo'),
            'default'       => 210,
            'min'           => 50,
            'step'          => 1,
            'max'           => 500,
            'display_value' => 'label',
            'required'      => array('enable_custom_header_height', '=', true),
        ),

        array(
            'id'       => 'signin_link_header_2',
            'type'     => 'text',
            'title'    => esc_html__('Sign In Link', 'edumodo'),
            'default'  => '#',
            'required' => array('select_header', '=', ['header_2', 'header_11']),
        ),

        array(
            'id'       => 'register_link_header_2',
            'type'     => 'text',
            'title'    => esc_html__('Register Link', 'edumodo'),
            'default'  => '#',
            'required' => array('select_header', '=', ['header_2', 'header_11']),
        ),
        array(
            'id'      => 'enable-header',
            'type'    => 'switch',
            'title'   => esc_html__('Enable Header', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'       => 'enable-header-single-posts-and-custom-post',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Header in Single Post', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
            'required' => array('enable-breadcrumb', '=', 1),
        ),


    ),
));
