<?php
Redux::setSection($opt_name, array(
    'title'  => esc_html__('General Settings', 'edumodo'),
    'icon'   => 'el-icon-home',
    'id'     => 'general_options',
    'fields' => array(

        array(
            'id'      => 'enable-breadcrumb',
            'type'    => 'switch',
            'title'   => esc_html__('Enable Breadcrumb', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'      => 'home_breadcrumb_title',
            'title'   => __('Home Breadcrumb Title', 'edumodo'),
            'type'    => 'text',
            'default' => 'Home',
        ),
        array(
            'id'      => 'archives_breadcrumb_title',
            'title'   => __('Archive Page Breadcrumb Title', 'edumodo'),
            'type'    => 'text',
            'default' => 'Archives',
        ),

        array(
            'id'       => 'enable_preloader',
            'type'     => 'switch',
            'title'    => esc_html__('Preloader', 'edumodo'),
            'default'  => false,
            'on'      => 'Enabled',
            'off'     => 'Disabled',

        ),
        array(
            'id'       => 'preloder_background',
            'type'     => 'color',
            'title'    => esc_html__('Background Color', 'edumodo'),
             'compiler' => true,
            'required' => array('enable_preloader', '=', 1),
        ),
        
        array(
            'id'       => 'preloder_color',
            'type'     => 'color',
            'title'    => esc_html__('Preloader Color', 'edumodo'),
            'compiler' => true,
            'required' => array('enable_preloader', '=', 1),
        ),

        // array(
        //     'id'       => 'preloader_img',
        //     'type'     => 'media',
        //     'url'      => true,
        //     'title'    => esc_html__( 'Preloader Image', 'edumodo' ),
        //     'default'  => array(
        //         'url'=>get_stylesheet_directory_uri().  '/dist/images/preloder.gif'
        //     ),
        //     'required' => array( 'enable_preloader' , '=' , 1 ),
        // ),

        array(
            'id'      => 'enable_scroll_top',
            'type'    => 'switch',
            'title'   => esc_html__('Back-to-Top Button', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'       => 'scroll_top_style',
            'type'     => 'select',
            'title'    => __('Select Back-to-Top Style', 'edumodo'),
            'options'  => array(
                'style_1' => 'Style 1',
                'style_2' => 'Style 2',
            ),
            'default'  => 'style_1',
            'required' => array('enable_scroll_top', '=', 1),
        ),

        array(
            'id'       => 'hide_scroll_top_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Hide on Small Device', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
            'required' => array('enable_scroll_top', '=', 1),
        ),

    ),
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('RTL', 'edumodo'),
    'id'         => 'rtl_options',
    'subsection' => true,
    'fields'     => array(

        array(
            'id'      => 'enable_rtl',
            'type'    => 'switch',
            'title'   => esc_html__('Enable RTL', 'edumodo'),
            'default' => 0,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

        array(
            'id'      => 'lan_name_1',
            'type'    => 'text',
            'title'   => esc_html__('Language 1', 'edumodo'),
            'default' => 'English',
        ),

        array(
            'id'      => 'ltr_url',
            'type'    => 'text',
            'title'   => esc_html__('URL 1', 'edumodo'),
            'default' => '',
        ),

        array(
            'id'      => 'lan_name_2',
            'type'    => 'text',
            'title'   => esc_html__('Language 2', 'edumodo'),
            'default' => 'Arabic',
        ),

        array(
            'id'      => 'rtl_url',
            'type'    => 'text',
            'title'   => esc_html__('URL 2', 'edumodo'),
            'default' => '',
        ),

        array(
            'id'      => 'select_url',
            'type'    => 'radio',
            'title'   => __('Default Language', 'edumodo'),
            'options' => array(
                '1' => 'Language 1',
                '2' => 'Language 2',

            ),
            'default' => '1',
        ),
    ),
));
