<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Edumodo
 */
$post_id = edumodo_get_id();
	// Global Options
global $edumodo_options;
    // Prefix
$prefix = '_edumodo_';
	// sidebar position
$sidebar_position = $edumodo_options['default-sidebar-select'];

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main">

		<?php if(defined( 'CMB2_LOADED' )): ?>
			<?php do_action('edumodo-enable-or-disable-header-section'); ?>
			<?php else: ?>
				<div class="page-details">
					<div class="container">
						<div class="row">
							<h2 class="page-title">
								<?php the_archive_title(); ?>
							</h2>
						</div>
					</div>
				</div>
			<?php endif; ?>
			
			<div class="container">
				<div class="ld-course-list-items row">				
					<?php
					if ( have_posts() ) : ?>

						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post();

							get_template_part( 'template-parts/learndash', 'content' );

						endwhile; ?>

                      <div class="edumodo-pagination">
                            <?php
                              the_posts_pagination( array(
                                'mid_size' => 1,
                                'prev_text'          =>  '<i class="glyph-icon flaticon-left-arrow"></i>',
                                'next_text'          =>  '<i class="glyph-icon flaticon-right-arrow"></i>',

                              ) );
                            ?>
                      </div>

					<?php else :

						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
				</div>
			</div><!-- .container -->
		</main><!-- #main -->
	</div><!-- #primary -->

	<?php
	get_footer();
