<?php
/**
 * Child theme functions
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 */

/**
 * Enqueue parent and child styles
 */
function edumodo_child_enqueue_styles() {
    //wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	//wp_enqueue_style( 'edumodo-kindergarten-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style( 'edumodo-parent', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'edumodo-kid', get_stylesheet_directory_uri() . '/style.css', array() );
}

add_action( 'wp_enqueue_scripts', 'edumodo_child_enqueue_styles', 90);



/**
 * Load edumodo widgets
 */
//require get_template_directory() . '/inc/widgets/widgets.php';

function edumodo_widgets_init_kindergarten() {

    register_sidebar( array(
        'name'          => esc_html__( 'Programme Single Widget', 'edumodo' ),
        'id'            => 'programme_single_widget',
        'description'   => 'Programme Single Page Widget',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Class Single Widget', 'edumodo' ),
        'id'            => 'class_single_widget',
        'description'   => 'Class Single Page Widget',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

}
add_action( 'widgets_init', 'edumodo_widgets_init_kindergarten' );
