<?php
/**
 *
 * Mailchimp Shortcode
 *
 */


class Edumodo_Shortcode_Mailchimp {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-mailchimp';

    /**
     * Instance of class
     */
    private static $instance;

    /**
     * Initialization
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }


    private function __construct() {

        add_shortcode( $this->name, array( $this, 'create_mailchimp_shortcode' ) );
    }


    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    public function create_mailchimp_shortcode( $atts ) {

        ob_start();


            $data = shortcode_atts( array(
                'action'      => '',
                'label_email' => '',
                'label_btn'   => '',
                'btn_class'   => '',
            ), $atts );


            $action      = ( '' === $data['action'] ) ? '#' : esc_url_raw( htmlspecialchars_decode( $data['action'] ) );
            $label_email = ( '' === $data['label_email'] ) ? __( 'Your Email', 'edumodo' ) : esc_html( $data['label_email'] );
            $label_btn   = ( '' === $data['label_btn'] ) ? __( 'Subscribe', 'edumodo' ) : esc_html( $data['label_btn'] );
            $btn_class   = ( '' === $data['btn_class'] ) ? __( '', 'edumodo' ) : esc_html( $data['btn_class'] );


            // If action not set, just exit
            if ( '' === $action ) {
                return;
            }

        ?>

            <div id="mc_embed_signup">
                <form action="<?php echo $action; ?>" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" autocomplete="off">
                    <div id="mc_embed_signup_scroll">
                        <div class="mc-field-group">
                            <input type="email" value="" name="EMAIL" class="required email" id="mce-email" placeholder="<?php echo $label_email; ?>">
                            <input type="submit" value="Subscribe" name="subscribe" id="tx-subscribe" class="button <?php echo $btn_class ?>">
                        </div>
                    </div>
                </form>
            </div>


<?php

        $output = ob_get_clean();

        return $output;

    }



}