<?php

/**
 *
 * Course Shortcode
 *
 */
class Edumodo_Shortcode_Course_Info {


    /**
     *
     * Shortcode Name
     * @var string
     */

    private $name = 'edumodo-course-info';


    /**
     * Instance of class.
     * @var null|Edumodo_CPT_Course
     */
    private static $instance;

    /**
     * Initialization
     *
     * @return Edumodo_CPT_Course
     */
    public static function init() {
        if ( null === self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __construct() {
        add_shortcode( $this->name, array( $this, 'create_edumodo_course_info' ));

    }

    /**
     * Shortcode Function
     *
     * @param $atts
     * @return string
     */

    function create_edumodo_course_info($atts){

        ob_start();
        $prefix = '_edumodo_';
        $start_date = get_post_meta( get_the_ID(), $prefix . 'course_start_date', true );
        $end_date = get_post_meta( get_the_ID(), $prefix . 'course_end_date', true );
        $total_hours = get_post_meta( get_the_ID(), $prefix . 'course_hours', true );
        $total_student = get_post_meta( get_the_ID(), $prefix . 'course_students', true );
        $course_time = get_post_meta( get_the_ID(), $prefix . 'course_time', true );
        $course_Levels = get_post_meta( get_the_ID(), $prefix . 'course_levels', true );
        $course_cost = get_post_meta( get_the_ID(), $prefix . 'course_cost', true );

        $default = array(
            'id' => '',
            
        );

        $option = shortcode_atts($default, $atts);

        ?>

                <div class="course-meta">

                    <div class="panel panel-default">
                        <div class="panel-body">
                            <table class="table table-borderless table-condensed table-hover">

                                

                                <tbody>
                                    <?php if($start_date):?>
                                    <tr>
                                        <td><?php esc_html_e('Course Start Date', 'edumodo');?></td>
                                        <td><?php echo $start_date; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($end_date):?>
                                    <tr>
                                        <td><?php esc_html_e('Course End Date', 'edumodo');?></td>
                                        <td><?php echo $end_date; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($total_hours):?>
                                    <tr>
                                        <td><?php esc_html_e('Estimated Duration', 'edumodo');?></td>
                                        <td><?php echo $total_hours; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($total_student):?>
                                    <tr>
                                        <td><?php esc_html_e('Maximum Students', 'edumodo');?></td>
                                        <td><?php echo $total_student; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($course_time):?>
                                    <tr>
                                        <td><?php esc_html_e('Time', 'edumodo');?></td>
                                        <td><?php echo $course_time; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($course_Levels):?>
                                    <tr>
                                        <td><?php esc_html_e('Levels', 'edumodo');?></td>
                                        <td><?php echo $course_Levels; ?></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php if($course_cost):?>
                                    <tr>
                                        <td><?php esc_html_e('Course Cost', 'edumodo');?></td>
                                        <td><?php echo $course_cost; ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>

                            </table>
                        </div>
                    </div>
                    
                </div>

        <?php

        $output = ob_get_clean();
        return $output;

    }

}
