<?php

/**
 * Metabox for page
 * @field Page Background
 * @field Page Backround
 */

function edumodo_page_metabox(){

    // Start with an underscore to hide fields from custom fields list
    $prefix = '_edumodo_';

    // Page header image
    $page_header_image = new_cmb2_box(
        array(
            'id'           => 'page_header_img',
            'title'        => __('Page Header Image', 'edumodo'),
            'object_types' => array('page', 'tx-course', 'lp_course', 'sfwd-courses', 'tribe_events', 'notice', 'course'), // post type
            // 'context'      => 'side',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                array(
                    'name'    => __('Upload Your Page Header Image', 'edumodo'),
                    'id'      => $prefix . 'header_img',
                    'type'    => 'file',
                    'default' => '',
                ),

                array(
                    'name'    => __('Page Title', 'edumodo'),
                    'id'      => $prefix . 'page_title',
                    'type'    => 'text_medium',
                    'default' => '',
                ),

                array(
                    'name'    => __('Page Heading Enable', 'edumodo'),
                    'id'      => $prefix . 'title_enable',
                    'type'    => 'select',
                    'default' => 'enable',
                    'options' => array(
                        'enable'  => __('Enable', 'edumodo'),
                        'disable' => __('Disable', 'edumodo'),
                    ),
                ),

            ),
        )
    );

}

function edumodo_event_metabox(){
    // Start with an underscore to hide fields from custom fields list
    $prefix = '_edumodo_';
    // Portfolio header image
    $event_meta = new_cmb2_box(
        array(
            'id'           => 'event-default-color',
            'title'        => __('Event Default Color', 'edumodo'),
            'object_types' => array('tribe_events'), // post type
            'context'      => 'side',
            'priority'     => 'default',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                // Portfolio header image
                array(
                    'name'    => __('Choose Your Event Default Color', 'edumodo'),
                    'id'      => $prefix . 'event_color',
                    'type'    => 'colorpicker',
                    'default' => '',
                    'options' => array(
                        'alpha' => true, // make this a rgba color picker.
                    ),
                ),
            ),
        )
    );
}
if (!function_exists('edumodo_woo_metabox')) {
    function edumodo_woo_metabox()
    {
        // Start with an underscore to hide fields from custom fields list
        $prefix = '_edumodo_';
        // Portfolio header image
        $product_author_meta = new_cmb2_box(
            array(
                'id'           => 'product-author-metabox',
                'title'        => __('Product Author', 'edumodo'),
                'object_types' => array('product'), // post type
                'context'      => 'side',
                'priority'     => 'default',
                'show_names'   => true, // Show field names on the left
                'fields'       => array(
                    // Portfolio header image
                    array(
                        'name'    => __('Write Your Product Author Name', 'edumodo'),
                        'id'      => $prefix . 'product_author',
                        'type'    => 'text',
                        'default' => '',
                    ),
                ),
            )
        );
    }
}
add_action('cmb2_admin_init', 'edumodo_woo_metabox');
add_action('cmb2_admin_init', 'edumodo_event_metabox');
add_action('cmb2_admin_init', 'edumodo_page_metabox');
