<?php

/**
 * Metabox for edumodo
 * @field edumodo link
 * @field edumodo link
 */

/**
 * Define the metabox and field configurations.
 */
function edumodo_all_metaboxes(){

    // Start with an underscore to hide fields from custom fields list
    $prefix = '_edumodo_';

    // Teacher meta side
    $meta_boxes = new_cmb2_box(
        array(
            'id'           => 'edumodo_tacher_side',
            'title'        => __('Teacher Details', 'edumodo'),
            'object_types' => array('teacher'), // post type
            'context'      => 'side',
            'priority'     => 'default',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                array(
                    'name' => __('Teacher Image ', 'edumodo'),
                    'id'   => $prefix . 'teacher_img',
                    'type' => 'file',
                ),
                array(
                    'name' => __('Designation', 'edumodo'),
                    'id'   => $prefix . 'teacher_designation',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Email', 'edumodo'),
                    'id'   => $prefix . 'teacher_email',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Phone', 'edumodo'),
                    'id'   => $prefix . 'teacher_phone',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Website', 'edumodo'),
                    'id'   => $prefix . 'teacher_website',
                    'type' => 'text',
                ),

            ),
        )
    );

    // Teacher meta box normal
    $meta_boxes = new_cmb2_box(
        array(
            'id'           => 'edumodo_tacher_normal',
            'title'        => __('Teacher Social Link', 'edumodo'),
            'object_types' => array('teacher'), // post type
            'context'      => 'normal',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                array(
                    'name'    => __('Facebook Link', 'edumodo'),
                    'id'      => $prefix . 'teacher_facebook_link',
                    'type'    => 'text',
                    'default' => '#',
                ),
                array(
                    'name'    => __('Twitter Link', 'edumodo'),
                    'id'      => $prefix . 'teacher_twitter_link',
                    'type'    => 'text',
                    'default' => '#',
                ),
                array(
                    'name'    => __('Google Plus Link', 'edumodo'),
                    'id'      => $prefix . 'teacher_google_plus_link',
                    'type'    => 'text',
                    'default' => '#',
                ),
                array(
                    'name'    => __('Linkedin Link', 'edumodo'),
                    'id'      => $prefix . 'teacher_linkedin_link',
                    'type'    => 'text',
                    'default' => '#',
                ),
            ),
        )
    );

    // Teacher header image
    $course_header_image = new_cmb2_box(
        array(
            'id'           => 'teacher_head',
            'title'        => __('Teacher Header Image', 'edumodo'),
            'object_types' => array('teacher'), // post type
            'context'      => 'normal',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                // teacher header image
                array(
                    'name'    => __('Single teacher Header Image', 'edumodo'),
                    'id'      => $prefix . 'course_single_page_header_img',
                    'type'    => 'file',
                    'default' => '',
                ),
            ),
        )
    );

    // Course header image
    $course_header_image = new_cmb2_box(
        array(
            'id'           => 'course_head',
            'title'        => __('Course Header Image', 'edumodo'),
            'object_types' => array('course'), // post type
            'context'      => 'normal',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(
                // course header image
                array(
                    'name'    => __('Single course Header Image', 'edumodo'),
                    'id'      => $prefix . 'course_single_page_header_img',
                    'type'    => 'file',
                    'default' => '',
                ),
            ),
        )
    );

    // Course information
    $course_image = new_cmb2_box(
        array(
            'id'           => 'course_info',
            'title'        => __('Course Information', 'edumodo'),
            'object_types' => array('tx-course'), // post type
            'context'      => 'normal',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(

                array(
                    'name' => __('Course Start Date', 'edumodo'),
                    'id'   => $prefix . 'course_start_date',
                    'type' => 'text_date',
                ),

                array(
                    'name' => __('Course End Date', 'edumodo'),
                    'id'   => $prefix . 'course_end_date',
                    'type' => 'text_date',
                ),

                array(
                    'name' => __('Estimated Duration', 'edumodo'),
                    'id'   => $prefix . 'course_hours',
                    'type' => 'text',
                ),

                array(
                    'name' => __('Maximum Students', 'edumodo'),
                    'id'   => $prefix . 'course_students',
                    'type' => 'text',
                ),

                array(
                    'name' => __('Time', 'edumodo'),
                    'id'   => $prefix . 'course_time',
                    'type' => 'text',
                ),

                array(
                    'name' => __('Levels', 'edumodo'),
                    'id'   => $prefix . 'course_levels',
                    'type' => 'text',
                ),

            ),
        )
    );

    // course input options
    $course_info = new_cmb2_box(
        array(
            'id'           => 'course_price',
            'title'        => __('Course Cost', 'edumodo'),
            'object_types' => array('tx-course'), // post type
            'context'      => 'side',
            'priority'     => 'default',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(

                array(
                    'id'   => $prefix . 'course_cost',
                    'type' => 'text_medium',
                ),
            ),
        )
    );

    /**
     * Choose Adventures from list
     * you may choose multiple adventure for course teacher
     */

    $dest_adv = new_cmb2_box(array(
        'id'           => $prefix . 'course_teacher',
        'title'        => __('Course Teacher', 'edumodo'),
        'object_types' => array('tx-course'), // Post type
        'context'      => 'normal',
        'priority'     => 'default',
        'show_names'   => true, // Show field names on the left
    ));
    $dest_adv->add_field(array(
        'name'        => __('Title', 'edumodo'),
        'description' => __('Write a Title', 'edumodo'),
        'id'          => $prefix . 'course_teacher_title',
        'type'        => 'text',
    ));

    $dest_adv->add_field(array(
        'name'    => __('Select Teacher', 'edumodo'),
        'desc'    => __('Drag teacher from left to right or click plus iocn to add', 'edumodo'),
        'id'      => $prefix . 'select_course_teacher',
        'type'    => 'custom_attached_posts',
        'options' => array(
            'show_thumbnails' => true, // Show thumbnails on the left
            'filter_boxes'    => true, // Show a text box for filtering the results
            'query_args'      => array(
                'post_type'      => 'teacher',
                'posts_per_page' => 10,
            ), // override the get_posts args
        ),
    ));

    // Testimonial options
    $testimonials = new_cmb2_box(
        array(
            'id'           => 'testimonial',
            'title'        => __('Testimonial Details', 'edumodo'),
            'object_types' => array('edumodo_testimonial'), // post type
            'context'      => 'normal',
            'priority'     => 'high',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(

                array(
                    'name' => __('Name of the Person ', 'edumodo'),
                    'id'   => $prefix . 'testimoni_name',
                    'type' => 'text_medium',
                ),
                array(
                    'name' => __('Designation', 'edumodo'),
                    'id'   => $prefix . 'testimoni_designation',
                    'type' => 'text_medium',
                ),
                array(
                    'name' => __('Testimonial', 'edumodo'),
                    'id'   => $prefix . 'testimoni_details',
                    'type' => 'textarea',
                ),
            ),
        )
    );

    // Learnpress course options
    $lp_course_meta = new_cmb2_box(
        array(
            'id'           => 'edumodo_lp_course',
            'title'        => __('Course Video', 'edumodo'),
            'object_types' => array('lp_course'), // post type
            'context'      => 'side',
            'priority'     => 'default',
            'show_names'   => true, // Show field names on the left
            'fields'       => array(

                array(
                    'name' => '',
                    'desc' => 'Enter your youtube, vimeo Video embad code',
                    'id'   => 'lp_course_video',
                    'type' => 'oembed',
                ),

            ),
        )
    );

}

add_action('cmb2_admin_init', 'edumodo_all_metaboxes');
