<?php

/**
 * Metabox for page
 * @field Page Background
 * @field Page Backround
 */

if (!function_exists('edumodo_venue_and_organizer_metabox')) {
    function edumodo_venue_and_organizer_metabox(){
        // Start with an underscore to hide fields from custom fields list
        $prefix = '_edumodo_';
        // Portfolio header image
        $venue_org_meta = new_cmb2_box(
            array(
                'id'           => 'event-venue-org-metabox',
                'title'        => __('Featured Image', 'edumodo'),
                'object_types' => array('tribe_organizer', 'tribe_venue'), // post type
                'context'      => 'side',
                'priority'     => 'default',
                'show_names'   => true, // Show field names on the left
                'fields'       => array(
                    // Portfolio header image
                    array(
                        'name'    => __('Choose Your Featured Image', 'edumodo'),
                        'id'      => $prefix . 'venue-or-organizer-featured-image',
                        'type'    => 'file',
                        'default' => '',
                    ),
                ),
            )
        );
    }
}
if (!function_exists('edumodo_event_speaker')) {
    function edumodo_event_speaker()
    {
        // Start with an underscore to hide fields from custom fields list
        $prefix = '_edumodo_';
        // Portfolio header image
        $speaker_meta = new_cmb2_box(
            array(
                'id'           => 'event-event-speaker',
                'title'        => __('Event Speaker', 'edumodo'),
                'object_types' => array('tribe_events'), // post type
                //                'context'      => 'side',
                //                'priority'     => 'default',
                'show_names'   => true, // Show field names on the left
            )
        );
        $speaker_meta->add_field(array(
            'name' => __('Purchase Ticket URL', 'edumodo'),
            'id'   => 'purchase_ticket_url',
            'type' => 'text_url',
            // 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
        ));
        $speaker_field = $speaker_meta->add_field(array(
            'id'          => 'speaker_group',
            'type'        => 'group',
            'description' => __('Generates reusable form Speaker', 'edumodo'),
            // 'repeatable'  => false, // use false if you want non-repeatable group
            'options'     => array(
                'group_title'   => __('Speaker {#}', 'edumodo'), // since version 1.1.4, {#} gets replaced by row number
                'add_button'    => __('Add Another Speaker', 'edumodo'),
                'remove_button' => __('Remove Speaker', 'edumodo'),
                'sortable'      => true, // beta
                'closed'        => true, // true to have the groups closed by default
            ),
        ));

        // Id's for group's fields only need to be unique for the group. Prefix is not needed.
        $speaker_meta->add_group_field($speaker_field, array(
            'name' => 'Speaker Name',
            'id'   => 'speaker_name',
            'type' => 'text',
        ));
        $speaker_meta->add_group_field($speaker_field, array(
            'name'        => 'Speaker Role',
            'description' => 'Write session speaker role',
            'id'          => 'speaker_role',
            'type'        => 'text',
        ));
        $speaker_meta->add_group_field($speaker_field, array(
            'name'        => 'Speaker Image',
            'description' => 'Upload speaker image',
            'id'          => 'speaker_image',
            'type'        => 'file',
        ));
    }
}

add_action('cmb2_admin_init', 'edumodo_venue_and_organizer_metabox');
add_action('cmb2_admin_init', 'edumodo_event_speaker');
