<?php

// Some custom query for post grid
function edumodo_get_all_post_type_options()
{

    $post_types = get_post_types(array('public' => true), 'objects');

    $options = ['' => ''];

    foreach ($post_types as $post_type) {
        $options[$post_type->name] = $post_type->label;
    }

    return apply_filters('edumodo_post_type_options', $options);
}

/**
 * Action to handle searching taxonomy terms.
 */
function edumodo_get_all_taxonomy_options()
{

    global $wpdb;

    $results = array();

    $limit = apply_filters('edumodo_taxonomy_terms_dropdown_limit', 500);

    foreach ($wpdb->get_results("
        SELECT terms.slug AS 'slug', terms.name AS 'label', termtaxonomy.taxonomy AS 'type'
        FROM $wpdb->terms AS terms
        JOIN $wpdb->term_taxonomy AS termtaxonomy ON terms.term_id = termtaxonomy.term_id
        LIMIT $limit
    ") as $result) {
        $results[$result->type . ':' . $result->slug] = $result->type . ':' . $result->label;
    }

    return apply_filters('edumodo_taxonomy_options', $results);
}
// get all registered taxonomies
function edumodo_get_taxonomies_map()
{
    $map        = array();
    $taxonomies = get_taxonomies();
    foreach ($taxonomies as $taxonomy) {
        $map[$taxonomy] = $taxonomy;
    }
    return apply_filters('edumodo_taxonomies_map', $map);
}

function edumodo_build_query_args($settings)
{

    $query_args = [
        'orderby'             => $settings['orderby'],
        'order'               => $settings['order'],
        'ignore_sticky_posts' => 1,
        'post_status'         => 'publish',
    ];

    if (!empty($settings['post_in'])) {
        $query_args['post_type'] = 'any';
        $query_args['post__in']  = explode(',', $settings['post_in']);
        $query_args['post__in']  = array_map('intval', $query_args['post__in']);
    } else {
        if (!empty($settings['post_types'])) {
            $query_args['post_type'] = $settings['post_types'];
        }

        if (!empty($settings['tax_query'])) {
            $tax_queries = $settings['tax_query'];

            $query_args['tax_query']             = array();
            $query_args['tax_query']['relation'] = 'OR';
            foreach ($tax_queries as $tq) {
                list($tax, $term) = explode(':', $tq);

                if (empty($tax) || empty($term)) {
                    continue;
                }

                $query_args['tax_query'][] = array(
                    'taxonomy' => $tax,
                    'field'    => 'slug',
                    'terms'    => $term,
                );
            }
        }
    }

    $query_args['posts_per_page'] = $settings['posts_per_page'];

    $query_args['paged'] = max(1, get_query_var('paged'), get_query_var('page'));

    return apply_filters('edumodo_posts_query_args', $query_args, $settings);
}

function edumodo_get_image_html($image_setting, $image_size_key, $settings)
{
    $image_html    = '';
    $attachment_id = $image_setting['id'];
    // Old version of image settings.
    if (!isset($settings[$image_size_key . '_size'])) {
        $settings[$image_size_key . '_size'] = '';
    }
    $size        = $settings[$image_size_key . '_size'];
    $image_class = 'lae-image';
    // If is the new version - with image size.
    $image_sizes   = get_intermediate_image_sizes();
    $image_sizes[] = 'full';

    if (!empty($attachment_id) && in_array($size, $image_sizes)) {
        $image_class .= " attachment-{$size} size-{$size}";
        $image_attr = array(
            'class' => trim($image_class),
            'alt'   => get_the_title($attachment_id),
            'title' => edumodo_get_image_alt($attachment_id),
        );
        $image_html .= wp_get_attachment_image(
            $attachment_id,
            $size,
            false,
            $image_attr
        );
    } else {
        $image_src = Group_Control_Image_Size::get_attachment_image_src($attachment_id, $image_size_key, $settings);
        if (!$image_src && isset($image_setting['url'])) {
            $image_src = $image_setting['url'];
        }

        if (!empty($image_src)) {
            $image_class_html = (!empty($image_class) ? ' class="' . $image_class . '"' : '');
            $image_html .= sprintf(
                '<img src="%s" title="%s" alt="%s"%s />',
                esc_attr($image_src),
                get_the_title($attachment_id),
                edumodo_get_image_alt($attachment_id),
                $image_class_html
            );
        }

    }

    return apply_filters(
        'edumodo_attachment_image_html',
        $image_html,
        $image_setting,
        $image_size_key,
        $settings
    );
}

function edumodo_get_image_alt($attachment_id)
{
    if (empty($attachment_id)) {
        return '';
    }
    if (!$attachment_id) {
        return '';
    }
    $attachment = get_post($attachment_id);
    if (!$attachment) {
        return '';
    }
    $alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);

    if (!$alt) {
        $alt = $attachment->post_excerpt;
        if (!$alt) {
            $alt = $attachment->post_title;
        }
    }

    $alt = trim(strip_tags($alt));
    return apply_filters('edumodo_image_alt', $alt, $attachment_id);
}

function edumodo_get_info_for_taxonomies($taxonomies)
{
    $output = '';
    foreach ($taxonomies as $taxonomy) {
        $output .= edumodo_get_taxonomy_info($taxonomy);
    }
    return apply_filters('edumodo_taxonomies_info', $output, $taxonomies);
}

function edumodo_get_taxonomy_info($taxonomy)
{
    $output = '';
    $terms  = get_the_terms(get_the_ID(), $taxonomy);

    if (!empty($terms) && !is_wp_error($terms)) {
        $output .= '<span class="edumodo-terms">';
        $term_count = 0;
        foreach ($terms as $term) {
            if ($term_count != 0) {
                $output .= ', ';
            }
            $output .= '<a href="' . get_term_link($term->slug, $taxonomy) . '">' . $term->name . '</a>';
            $term_count = $term_count + 1;
        }
        $output .= '</span>';
    }

    return apply_filters('edumodo_taxonomy_info', $output, $taxonomy);
}

function edumodo_entry_author()
{
    $author = '<span class="author vcard">' . esc_html__('By ', 'edumodo') . '<a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '" title="' . esc_attr(get_the_author_meta('display_name')) . '">' . esc_html(get_the_author_meta('display_name')) . '</a></span>';
    return apply_filters('edumodo_entry_author', $author);
}

function edumodo_entry_published($format = null)
{
    if (empty($format)) {
        $format = get_option('date_format');
    }
    $published = '<span class="published"><abbr title="' . sprintf(get_the_time(esc_html__('l, F, Y, g:i a', 'edumodo'))) . '">' . sprintf(get_the_time($format)) . '</abbr></span>';
    return apply_filters('edumodo_entry_published', $published, $format);
    $link = '<span class="published">' . '<a href="' . get_day_link(get_the_time(esc_html__('Y', 'edumodo')), get_the_time(esc_html__('m', 'edumodo')), get_the_time(esc_html__('d', 'edumodo'))) . '" title="' . sprintf(get_the_time(esc_html__('l, F, Y, g:i a', 'edumodo'))) . '">' . '<span class="updated">' . get_the_time($format) . '</span>' . '</a></span>';
    return apply_filters('edumodo_entry_published_link', $link, $format);
}
