<?php

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widgets\Elementor;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * Elementor video popup
 *
 * Elementor widget for  video popup
 *
 * @since 1.0.0
 */
class Edumodo_video_PopUp_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'edumodo-video-popup';
    }

    public function get_title()
    {
        return __('Video PopUp', 'edumodo');
    }

    public function get_icon()
    {
        return 'eicon-play';
    }

    public function get_categories()
    {
        return ['edumodo'];
    }
    public function get_keywords() {
        return [ 'video', 'video popup', 'popup video', 'video play', 'play button','youtube', 'vimeo' ];
    }
    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/
    public function get_script_depends()
    {
        return [];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(

            'section_video',
            [
                'label' => __('Video', 'edumodo'),
            ]
        );

        $this->add_control(
            'video_style',
            [
                'label'   => __('Style', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1'                         => __('Style 1', 'edumodo'),
                    '2'                         => __('Style 2', 'edumodo'),
                    '3'                         => __('Style 3', 'edumodo'),
                    '4'                         => __('Style 4', 'edumodo'),
                    '5'                         => __('Style 5', 'edumodo'),
                    'edumodo-video-popup-left'  => __('Style 6', 'edumodo'),
                    'edumodo-video-popup'       => __('Style 7', 'edumodo'),
                    'edumodo-video-popup-round' => __('Style 8', 'edumodo'),
                ],
            ]
        );
        $this->add_control(
            'popup_text',
            [
                'label'       => __('Video PopUp Text', 'edumodo'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Play Video', 'edumodo'),
                'placeholder' => __('Play Video', 'edumodo'),
                'condition' => [
                    'video_style' => '2',
                ],
            ]
        );
        $this->add_control(
            'video_type',
            [
                'label'   => __('Video Source', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'youtube',
                'options' => [
                    'youtube' => __('YouTube', 'edumodo'),
                    'vimeo'   => __('Vimeo', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'video_link',
            [
                'label'       => __('Link', 'edumodo'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __('Enter your YouTube link', 'edumodo'),
                'default'     => 'https://www.youtube.com/watch?v=9uOETcuFjbE',
                'label_block' => true,
                'condition'   => [
                    'video_type' => 'youtube',
                ],
            ]
        );

        $this->add_control(
            'vimeo_link',
            [
                'label'       => __('Link', 'edumodo'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __('Enter your Vimeo link', 'edumodo'),
                'default'     => 'https://vimeo.com/235215203',
                'label_block' => true,
                'condition'   => [
                    'video_type' => 'vimeo',
                ],
            ]
        );

        $this->add_control(
            'image_overlay',
            [
                'label'   => __('Image', 'edumodo'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'video_style' => array('edumodo-video-popup-left', 'edumodo-video-popup-right', 'edumodo-video-popup-round'),
                ],
            ]
        );

        $this->add_control(
            'heading_youtube',
            [
                'label'     => __('Video Options', 'edumodo'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        // YouTube.
        $this->add_control(
            'yt_autoplay',
            [
                'label' => __('Autoplay', 'edumodo'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'edumodo' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'edumodo' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'edumodo' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'edumodo' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup-wrapper' => 'text-align: {{VALUE}};',
                ],
                'default' => 'center',
                'separator' =>'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_video_style',
            [
                'label' => __('Video', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => __('Icon Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video i'                  => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper a.play-icon-text'                  => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .play-btn::after'                  => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .play-btn:before'                  => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .play-btn'                  => 'Background: radial-gradient(rgba(255, 188, 0, 0.94) 60%, {{VALUE}} 62%);',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video-play-button span'                  => 'border-left-color: {{VALUE}};',
                ],
                'condition' => [
                    'video_style' => array('1', '2', '3', '4', '5'),
                ],
            ]
        );
        $this->add_control(
            'video_border_color',
            [
                'label'     => __('Background', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup::before'                  => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup a.icon-video'             => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup a.icon-video:hover'       => 'background: {{VALUE}};',

                    '{{WRAPPER}} .edumodo-video-popup-round'                    => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-round a.icon-video'       => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-round a.icon-video:hover' => 'background: {{VALUE}};',

                    '{{WRAPPER}} .edumodo-video-popup-left::before'             => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-left a.icon-video'        => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-left a.icon-video:hover'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video i'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .play-btn'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video-play-button:after'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video-play-button:before'  => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'video_style' => array('1', '3', '4', 'edumodo-video-popup-left', 'edumodo-video-popup-right', 'edumodo-video-popup-round'),
                ],
            ]
        );

        $this->add_control(
            'video_overlay_color',
            [
                'label'     => __('Overlay Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup:hover:after'       => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-round:hover:after' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-video-popup-left:hover:after'  => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'video_style' => array('edumodo-video-popup-left', 'edumodo-video-popup-right', 'edumodo-video-popup-round'),
                ],
            ]
        );
        $this->add_control(
            'play_bg_size',
            [
                'label'     => __('Play Background Size', 'edumodo'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup a.icon-video'       => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-round a.icon-video' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-left a.icon-video'  => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video i'  => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'video_style' => array('1', 'edumodo-video-popup-left', 'edumodo-video-popup-right', 'edumodo-video-popup-round'),
                ],
            ]
        );

        $this->add_control(
            'play_icon_size',
            [
                'label'     => __('Play Icon Size', 'edumodo'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-video-popup i.icofont-ui-play'       => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-round i.icofont-ui-play' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-left i.icofont-ui-play'  => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-wrapper .video i'  => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .edumodo-video-popup-left a.icon-video'  => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'video_style' => array('1', 'edumodo-video-popup-left', 'edumodo-video-popup-right', 'edumodo-video-popup-round'),
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Content_typography',
                'selector' => '{{WRAPPER}} .edumodo-video-popup-wrapper a.play-icon-text',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                'condition' => [
                    'video_style' => array('2'),
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {

       $settings = $this->get_settings_for_display();
        $id       = $this->get_id();
        ?>

        <div class="edumodo-video-popup-wrapper">

        <?php if ($settings['video_style'] == '1'): ?>

            <div class="video">
                <a class="<?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>" href="<?php if ($settings['video_type'] == 'youtube'): ?><?php echo $settings['video_link']; ?><?php else:echo $settings['vimeo_link'];endif;?>"><i class="fa fa-play"></i></a>
            </div>

        <?php elseif ($settings['video_style'] == '2'): ?>

          <a href="<?php if ($settings['video_type'] == 'youtube'): ?><?php echo $settings['video_link']; ?><?php else:echo $settings['vimeo_link'];endif;?>" class="icon-video play-icon-text <?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>"><i class="fa fa-play-circle" aria-hidden="true">&nbsp;</i> <?php echo $settings['popup_text']; ?></a>

        <?php elseif ($settings['video_style'] == '3'): ?>

          <a style="<?php if ($settings['align'] == 'left'): echo 'float:left'; elseif($settings['align'] == 'right') : echo 'float:right'; elseif($settings['align'] == 'center'): echo 'float:none'; endif; ?>" class="play-btn <?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>" href="<?php if ($settings['video_type'] == 'youtube'): ?><?php echo $settings['video_link']; ?><?php else:echo $settings['vimeo_link'];endif;?>"></a>

        <?php elseif ($settings['video_style'] == '4'): ?>
            <div class="video-popup-4" style="<?php if ($settings['align'] == 'left'): echo 'float:left'; elseif($settings['align'] == 'right') : echo 'float:right'; elseif($settings['align'] == 'center'): echo 'float:none'; endif; ?>">
            <a id="play-video" class="video-play-button <?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>" href="<?php if ($settings['video_type'] == 'youtube'): ?><?php echo $settings['video_link']; ?><?php else:echo $settings['vimeo_link'];endif;?>">
              <span></span>
            </a>
        </div>s
        <?php elseif ($settings['video_style'] == '5'): ?>
            <div class="video-popup-5" style="<?php if ($settings['align'] == 'left'): echo 'float:left'; elseif($settings['align'] == 'right') : echo 'float:right'; elseif($settings['align'] == 'center'): echo 'float:none'; endif; ?>">
            <a class="<?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>" href="<?php if ($settings['video_type'] == 'youtube'): ?><?php echo $settings['video_link']; ?><?php else:echo $settings['vimeo_link'];endif;?>">
                <svg version="1.1" id="play" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100px" width="100px"
                     viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
                  <path class="stroke-solid" fill="none" stroke="<?php if($settings['icon_color']) : echo $settings['icon_color']; else : echo 'white'; endif; ?>"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                    C97.3,23.7,75.7,2.3,49.9,2.5"/>
                  <path class="stroke-dotted" fill="none" stroke="<?php if($settings['icon_color']) : echo $settings['icon_color']; else : echo 'white'; endif; ?>"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                    C97.3,23.7,75.7,2.3,49.9,2.5"/>
                  <path class="icon" fill="<?php if($settings['icon_color']) : echo $settings['icon_color']; else : echo 'white'; endif; ?>" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/>
                </svg>
            </a>
        </div>
        <?php elseif ($settings['video_style'] == 'edumodo-video-popup' || $settings['video_style'] == 'edumodo-video-popup-left' || $settings['video_style'] == 'edumodo-video-popup-round' & $settings['video_type'] == 'youtube'): ?>

               <div class="<?php echo $settings['video_style'] ?>">
                  <img src="<?php echo $settings['image_overlay']['url']; ?>" alt="Video Overlay Image">
                  <a href="<?php echo $settings['video_link']; ?>" class="icon-video <?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>"><span><i class="fa fa-play"></i></span></a>
               </div>

       <?php elseif ($settings['video_style'] == 'edumodo-video-popup' || $settings['video_style'] == 'edumodo-video-popup-left' || $settings['video_style'] == 'edumodo-video-popup-round' & $settings['video_type'] == 'vimeo'): ?>

               <div class="<?php echo $settings['video_style'] ?>">
                  <img src="<?php echo $settings['image_overlay']['url']; ?>" alt="Video Overlay Image">
                  <a href="<?php echo $settings['vimeo_link']; ?>" class="icon-video <?php echo $id; ?>bla-<?php if ($settings['yt_autoplay'] == 'yes'): echo '1';else:echo '2';endif;?>"><span><i class="fa fa-play"></i></span></a>
               </div>

        <?php endif;?>

        </div>
    <script>
        jQuery(document).ready(function () {
            jQuery(function(){
              jQuery("a.<?php echo $id; ?>bla-1").YouTubePopUp();
              jQuery("a.<?php echo $id; ?>bla-2").YouTubePopUp( { autoplay: 0 } ); // Disable autoplay
            });
        });
    </script>

<?php

    }

}
