<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Course_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-course-1';
	}

	public function get_title() {
		return __( 'TX Courses', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-sidebar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-course-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        ); 

        $this->add_control(
            'enable_ordering_by_meta_box',
            [
                'label' => __( 'Order By Meta Box', 'elementor' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => __('Ascending', 'edumodo'),
                    'DESC' => __('Descending', 'edumodo'),
                ],
                 'condition' => [
                    'enable_ordering_by_meta_box' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'title' => __('Title', 'edumodo'),
                    'name' => __('Name', 'edumodo'),
                    'date' => __('Date', 'edumodo'),
                    'rand' => __('Random', 'edumodo'),
                ],
                'condition' => [
                    'enable_ordering_by_meta_box' => 'yes',
                ],
            ]
        );  
                     
		$this->end_controls_section();

		$this->start_controls_section(
			'edumodo_section_title_typography',
			[
				'label' => __( 'Title', 'edumodo' ),
			]
		);
        $this->add_control(
            'excerpt_title_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 7,
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_meta',
			[
				'label' => __( 'Meta', 'edumodo' ),
			]
		);

        $this->add_control(
            'course_cat_enable',
            [
                'label' => __( 'Show Date', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'course_view_enable',
            [
                'label' => __( 'Show View Count', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_desc_typography',
			[
				'label' => __( 'Description', 'edumodo' ),
			]
		);
        $this->add_control(
            'excerpt_desc_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 1,
                'max' => 300,
                'step' => 1,
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'section_style',
                [
                    'label' => __( 'Title', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 header  a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 header  a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_style_meta',
                [
                    'label' => __( 'Meta', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'meta_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 .type-tx-course .course-details .course-meta .post-date' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-course-1 .type-tx-course .course-details .course-meta .post-view' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-view i, .edumodo-course-1 .type-tx-course .course-details .course-meta .post-view i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta span, .type-tx-course article.tx-course .course-details .course-meta span, .edumodo-course-1 article.tx-course .course-details .course-meta .post-view, .type-tx-course article.tx-course .course-details .course-meta .post-view',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

		$this->start_controls_section(
			'section_style_desc',
				[
					'label' => __( 'Description', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'desc_color',
			[
				'label'     => __( 'Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 .type-tx-course .course-details .entry-content p' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 .entry-content  p',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_border_shadow',
                [
                    'label' => __( 'Style', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'bg_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => __( 'Border Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __( 'Border Width', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [   'label' => __( 'Box Shadow Hover', 'edumodo' ),
                'name' => 'box_shadow_hover',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course, .edumodo-course-1 .type-tx-course:hover',
            ]
        );

        $this->end_controls_section();
	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/tx-course/template/view.php';
	}


}
