<?php
// Silence is golden.

	$settings = $this->get_settings();

  // Global Options
	global $post;
 	// Prefix
  $prefix = '_edumodo_';

?>

    <div class="edumodo-testimonial-element">
        <div class="edumodo-testimonial">
            <?php
               $testimonial = array(
                    'post_type'         => 'edumodo_testimonial',
                    'post_status'       => 'publish',
                    'posts_per_page'    => -1,
                );
                $testimonial_query = new WP_Query( $testimonial );
                if($testimonial_query->have_posts()):
                    while($testimonial_query->have_posts()): 
                        $testimonial_query->the_post(); 

                $testimony_image = get_post_meta($post->ID, $prefix . 'testimoni_image', true); 
                $name = get_post_meta($post->ID, $prefix . 'testimoni_name', true); 
                $designation = get_post_meta($post->ID, $prefix . 'testimoni_designation', true); 
                $testimoni_details = get_post_meta($post->ID, $prefix . 'testimoni_details', true); 
            ?>
            <div class="edumodo-testimoni-wrapper">
                <div class="testimony"><?php the_content(); ?></div>
                <div class="author">

                    <?php
                        if ($settings['testimonial_items'] == '1'):?>
                          <div class="col-md-12 col-sm-12">
                    <?php elseif ($settings['testimonial_items'] == '2'):?>
                        <div class="col-md-3 col-sm-3">
                    <?php else:?>
                       <div class="col-md-4 col-sm-4">
                    <?php endif;?>   

                    <?php if ( has_post_thumbnail() ) : ?>
                      <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                          <img class="testimoni-image" src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                      </a>
                    <?php endif; ?>
                        
                    </div>
                    <?php
                        if ($settings['testimonial_items'] == '1'):?>
                              <div class="col-md-12 col-sm-12">
                        <?php elseif ($settings['testimonial_items'] == '2'):?>
                            <div class="col-md-9 col-sm-9">
                        <?php else:?>
                           <div class="col-md-8 col-sm-8">
                        <?php endif;?>

                      <?php if ($testimoni_details): ?>
                         <p class="desc"><?php echo $testimoni_details; ?></p>
                      <?php endif ?>
                          <div class="name-des">
                              <h4 class="name"><?php echo $name;  ?> <?php esc_html_e('-', 'edumodo');?> </h4>
                              <span class="designation"><?php echo $designation;  ?></span>
                          </div>
                        
                     </div>
                </div>
            </div>
            <?php endwhile; wp_reset_postdata(); endif;  ?>
        </div><!-- /.edumodo-testimonial -->              
    </div><!-- /.div -->

    <script type='text/javascript'>
          jQuery(document).ready(function($) {
            jQuery(".edumodo-testimonial").addClass("owl-carousel").owlCarousel({
                  pagination: true,
                 
                  dots:true,
                  
                  <?php if ($settings['testimonial_items'] == '2'):?>
                      center:false,
                  <?php else: ?>
                      center:true,
                  <?php endif; ?>
                  loop:true,
                  nav: false,
                  navClass: ['owl-carousel-left','owl-carousel-right'],
                  navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                  autoHeight : true,
              <?php if ($settings['autoplay_enable'] == 'yes' ): ?>
                    autoplay:true,
              <?php else: ?>
                     autoplay:false,
              <?php endif; ?>
                  responsive:{
                      0:{
                          items:1
                      },
                      600:{
                          items:2
                      },
                      1000:{
                          items:<?php echo $settings['testimonial_items']; ?>
                      }
                  }
               });
        });


    </script>
