<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo Portfolio 1
 *
 * Elementor widget for edumodo portfolio 1
 *
 * @since 1.0.0
 */
class edumodo_testimonial_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-testimonial-1';
	}

	public function get_title() {
		return __( 'Testimonial', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-testimonial-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_testimonial',
			[
				'label' => __( 'Testimonial', 'edumodo' ),
			]
		);

		$this->add_control(
			'testimonial_items',
			[
				'label'     => __( 'Testimonial Items to Show', 'edumodo' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => [
					'1'   => __( 'Item 1', 'edumodo' ),
					'2'   => __( 'Item 2', 'edumodo' ),
					'3'   => __( 'Item 3', 'edumodo' ),
				],
			]
		);

		$this->add_control(
			'autoplay_enable',
			[
				'label'     => __( 'Auto Play', 'edumodo' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'true'    => __( 'True', 'edumodo' ),
				'false'   => __( 'False', 'edumodo' ),
			]
		);
		
    	$this->add_responsive_control(
            'fixed_height',
            [
                'label' => __( 'Fixed Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-lp-course-1 .lp-course-1' => 'max-height: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_testimoni_style',
			[
				'label' => __( 'Style', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label'     => __( 'Background Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'transparent',
				'selectors' => [
					'{{WRAPPER}} .edumodo-testimonial .edumodo-testimoni-wrapper' => 'background-color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'hover_bg_color',
			[
				'label'     => __( 'Dot Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .edumodo-testimonial .owl-controls .owl-dot.active' => 'background: {{VALUE}}; border-color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-testimonial .owl-controls .owl-dot' => 'border-color: {{VALUE}};',
				],
			]
		);

	$this->end_controls_section();

	$this->start_controls_section(
		'section_style_content',
			[
				'label' => __( 'Content', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

	$this->add_control(
		'testimoni_color',
		[
			'label'     => __( 'Content Color', 'edumodo' ),
			'type'      => Controls_Manager::COLOR,
			'default'   => '#666',
			'selectors' => [
				'{{WRAPPER}} .edumodo-testimoni-wrapper .desc' => 'color: {{VALUE}};',
			],
		]
	);
	$this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'Content_typography',
            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .desc',
            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
        ]
    );
	$this->end_controls_section();

	$this->start_controls_section(
		'section_style_name',
			[
				'label' => __( 'Name', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

	$this->add_control(
		'name_color',
		[
			'label'     => __( 'Name Color', 'edumodo' ),
			'type'      => Controls_Manager::COLOR,
			'default'   => '#182432',
			'selectors' => [
				'{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .name' => 'color: {{VALUE}};',
			],
		]
	);
	$this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'name_typography',
            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .name',
            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
        ]
    );
	$this->end_controls_section();

	$this->start_controls_section(
		'section_style_designation',
			[
				'label' => __( 'Designation', 'edumodo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

	$this->add_control(
		'designation_color',
		[
			'label'     => __( 'Designation Color', 'edumodo' ),
			'type'      => Controls_Manager::COLOR,
			'default'   => '#989898',
			'selectors' => [
				'{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .designation' => 'color: {{VALUE}};',
			],
		]

	);
	$this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'designation_typography',
            'selector' => '{{WRAPPER}} .edumodo-testimoni-wrapper .name-des .designation',
            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
        ]
    );
	$this->end_controls_section();


	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/testimonial-1/template/view.php';
	}


}
