<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor edumodo Blog
 *
 * Elementor widget for edumodo blog
 *
 * @since 1.0.0
 */
class Edumodo_Teachers_2 extends Widget_Base {

	public function get_name() {
		return 'edumodo-teacher-2';
	}

	public function get_title() {
		return __( 'Teacher 2', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-teacher-2' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_icon',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );


		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Title', 'edumodo' ),
			]
		);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

		$this->add_responsive_control(
			'teacher2_title_space',
			[
				'label' => __( 'Title Spacing', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title' => 'margin: {{SIZE}}{{UNIT}} 0;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_style',
				[
					'label' => __( 'Designation', 'edumodo' ),
				]
			);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
				[
					'label' => __( 'Social', 'edumodo' ),
				]
			);

		$this->add_control(
			'icon_size',
			[
				'label' => __( 'Size', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 60,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container:hover .teacher-social i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_width',
			[
				'label' => __( 'Width', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 40,
				],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'icon_height',
			[
				'label' => __( 'Height', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 40,
				],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => __( 'Title Spacing', 'edumodo' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .teacher-person .overlay .person-info .social-links-teacher' => 'margin: {{SIZE}}{{UNIT}} 0;',
				],
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'section_style',
				[
					'label' => __( 'Color', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'overlay_color',
			[
				'label'     => __( 'Overlay Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'rgba(36, 44, 94, 0.8)',
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-block .teacher-image:before' => ' background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_name',
				[
					'label' => __( 'Name', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'name_color',
			[
				'label'     => __( 'Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'name_hover_color',
			[
				'label'     => __( 'Hover Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info .name .teacher-title:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_designation',
				[
					'label' => __( 'Designation', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'degree_color',
			[
				'label'     => __( 'Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-info span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style_icon',
				[
					'label' => __( 'Social', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

        $this->add_control(
            'border_radius_icon',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .teacher-2 .teacher-container .teacher-each-wrap .teacher-social a' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_border_shadow',
				[
					'label' => __( 'Border', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

	        $this->add_control(
            'border_color',
            [
                'label' => __( 'Border Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __( 'Border Width', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [   'label' => __( 'Box Shadow Hover', 'edumodo' ),
                'name' => 'box_shadow_hover',
                'selector' => '{{WRAPPER}} .teacher-2 .teacher-container .teacher-block:hover',
            ]
        );

		$this->end_controls_section();


	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/teacher-2/template/view.php';
	}


}
