<?php
// Silence is golden.

    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';

?>

    <div class="edumodo-teacher-1">
        <div class="row">
            <?php
                    $teacher = array(
                        'post_type'         => 'teacher',
                        'post_status'       => 'publish',
                        'posts_per_page'    => $settings['posts_per_page'],
                    );

                $teacher_query = new WP_Query( $teacher );
                    if($teacher_query->have_posts()):
                        while($teacher_query->have_posts()): 
                            $teacher_query->the_post(); 

                            $teacher_img_links = get_post_meta( $post->ID, $prefix . 'teacher_img', true );
                            $designation = get_post_meta( $post->ID, $prefix . 'teacher_designation', true );
                            $email = get_post_meta( $post->ID, $prefix . 'teacher_email', true );
                            $phone = get_post_meta( $post->ID, $prefix . 'teacher_phone', true );
                            $website = get_post_meta( $post->ID, $prefix . 'teacher_website', true );
                            $teacher_facebook = get_post_meta( $post->ID, $prefix . 'teacher_facebook_link', true );
                            $teacher_twitter = get_post_meta( $post->ID, $prefix . 'teacher_twitter_link', true );
                            $teacher_google_plus = get_post_meta( $post->ID, $prefix . 'teacher_google_plus_link', true );
                            $teacher_linkedin = get_post_meta( $post->ID, $prefix . 'teacher_linkedin_link', true );
            ?>

                  <div class="col-md-<?php echo $settings['posts_column']; ?>">
                       <div class="teacher-person">
                          <?php if ($teacher_img_links) : ?>
                              <div class="person-img">
                                 <img class="img-responsive" src="<?php echo $teacher_img_links; ?>" alt="<?php the_title(); ?>">
                              </div>
                          <?php endif; ?>

                          <div class="overlay">
                             <div class="person-info">
                                <h4 class="teacher-title">
                                   <a href="<?php the_permalink(); ?>">
                                      <?php the_title(); ?>
                                   </a>
                                </h4>

                              <?php if ($designation) : ?>
                                    <p class="teacher-position"><?php echo $designation; ?></p>
                              <?php endif; ?>

                                <div class="social-links-teacher">
                                  <?php if ($teacher_facebook) : ?>
                                          <a class="teacher-facebook" href="<?php echo $teacher_facebook; ?>"><i class="fa fa-facebook"></i></a>
                                  <?php endif; ?>

                                  <?php if ($teacher_twitter) : ?>
                                          <a class="teacher-twitter" href="<?php echo $teacher_twitter; ?>"><i class="fa fa-twitter"></i> </a>
                                  <?php endif; ?>

                                  <?php if ($teacher_google_plus) : ?>
                                          <a class="teacher-gplus" href="<?php echo $teacher_google_plus; ?>"><i class="fa fa-google-plus-square"></i> </a>
                                  <?php endif; ?>

                                  <?php if ($teacher_linkedin) : ?>
                                           <a class="teacher-linkedin" href="<?php echo $teacher_linkedin; ?>"><i class="fa fa-linkedin"></i> </a>
                                  <?php endif; ?>
                                </div>
                             </div>
                          </div>
                       </div>
                  </div>

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div><!-- /.row -->     
    </div> <!-- /.div -->
