<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Slider
 *
 * Elementor widget for edumodo slider
 *
 * @since 1.0.0
 */
class edumodo_slider extends Widget_Base {

	public function get_name() {
		return 'edumodo-slider';
	} 

	public function get_title() {
		return __( 'Edumodo Slider', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-slider' ];
	}

	protected function _register_controls() {

	// Content options Start
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Slider Content', 'edumodo' ),
			]
		);
	$repeater = new Repeater();
	    $repeater->add_control(
		    'title',
		      	[
		          'label' => __( 'Slider Title', 'edumodo' ),
		          'type'  => Controls_Manager::TEXTAREA,
		          'default' => __( 'Jonathan Morgan', 'edumodo' ),
		    	]
	    );

	    $repeater->add_control(
			'title_animation',
				[
					'label'     => __( 'Title Animation', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fadeInDown',
					'options'   => [
						'none'			   => __('None'),
						'fadeInLeft'       => __( 'fadeInLeft', 'edumodo' ),
						'slideInRight'     => __( 'slideInRight', 'edumodo' ),
						'bounceIn'         => __( 'bounceIn', 'edumodo' ),
						'fadeInUp'         => __( 'fadeInUp', 'edumodo' ),
						'fadeInRightBig'   => __( 'fadeInRightBig', 'edumodo' ),
						'fadeInDown'       => __( 'fadeInDown', 'edumodo' ),
						'rotateIn'         => __( 'rotateIn', 'edumodo' ),
						'lightSpeedIn'     => __( 'lightSpeedIn', 'edumodo' ),
						'zoomIn'           => __( 'zoomIn', 'edumodo' ),
						'zoomInDown'       => __( 'zoomInDown', 'edumodo' ),
					],
				]
		);

		$repeater->add_control(
	       'slider_image',
		        [
		          'label' => __( 'Upload Slider Image', 'edumodo' ),
		          'type'  => Controls_Manager::MEDIA
		        ]
	    );

		$repeater->add_control(
		    'slider_content',
		      	[
		          'label' => __( 'Slider Description', 'edumodo' ),
		          'type'  => Controls_Manager::TEXTAREA,
		          'default' => __( 'Corem ipsum dolor si amet consectetur adipisic ingelit sed do adipisicido executiv
						sunse pit lore kome.', 'edumodo' ),
		      	]
		);

	    $repeater->add_control(
			'content_animation',
				[
					'label'     => __( 'Content Animation', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fadeInDown',
					'options'   => [
						'none'			   => __('None'),
						'fadeInLeft'       => __( 'fadeInLeft', 'edumodo' ),
						'slideInRight'     => __( 'slideInRight', 'edumodo' ),
						'bounceIn'         => __( 'bounceIn', 'edumodo' ),
						'fadeInUp'         => __( 'fadeInUp', 'edumodo' ),
						'fadeInRightBig'   => __( 'fadeInRightBig', 'edumodo' ),
						'fadeInDown'       => __( 'fadeInDown', 'edumodo' ),
						'rotateIn'         => __( 'rotateIn', 'edumodo' ),
						'lightSpeedIn'     => __( 'lightSpeedIn', 'edumodo' ),
						'zoomIn'           => __( 'zoomIn', 'edumodo' ),
						'zoomInDown'       => __( 'zoomInDown', 'edumodo' ),
					],
				]
		);

		$repeater->add_control(
			'btn_text',
			[
				'label' => __( 'Button Text', 'edumodo' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Apply Now', 'edumodo' ),
				'placeholder' => __( 'Apply Now', 'edumodo' ),
			]
		);

		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'edumodo' ),
				'type' => Controls_Manager::URL,
				'placeholder' => 'http://your-link.com',
				'default' => [
					'url' => '#',
				],
			]
		);

	    $repeater->add_control(
			'btn_animation',
				[
					'label'     => __( 'Button Animation', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fadeInDown',
					'options'   => [
						'none'			   => __( 'None'),
						'fadeInLeft'       => __( 'fadeInLeft', 'edumodo' ),
						'slideInRight'     => __( 'slideInRight', 'edumodo' ),
						'bounceIn'         => __( 'bounceIn', 'edumodo' ),
						'fadeInUp'         => __( 'fadeInUp', 'edumodo' ),
						'fadeInRightBig'   => __( 'fadeInRightBig', 'edumodo' ),
						'fadeInDown'       => __( 'fadeInDown', 'edumodo' ),
						'rotateIn'         => __( 'rotateIn', 'edumodo' ),
						'lightSpeedIn'     => __( 'lightSpeedIn', 'edumodo' ),
						'zoomIn'           => __( 'zoomIn', 'edumodo' ),
						'zoomInDown'       => __( 'zoomInDown', 'edumodo' ),
					],
				]
		);

		$this->add_control(
		    'slider_option',
		      [
		          'label'       => __( 'Slider Options', 'edumodo' ),
		          'type'        => Controls_Manager::REPEATER,
		          'show_label'  => true,
		          'default'     => [
		              [
		                'title' => __( 'Your Bright Future <span>is Our Mission</span>', 'edumodo' ),
		                'slider_content' => 'For feature for your life and everything education can take place in formal or informal setting. For feature for your life and everything education.',
		                'slider_image' => '',
		                'btn-text' => 'Explore More',
		                'btn-link' => '#',
		                'title_animation' => 'fadeInDown',
		                'content_animation' => 'fadeInDown',
		                'btn_animation' => 'fadeInDown',
		 
		              ]
		          ],
		          'fields'      => array_values( $repeater->get_controls() ),
		          'title_field' => '{{{title}}}',
		      ]
		  );

$this->end_controls_section();
// Content options End

// Color options Start
$this->start_controls_section(
	'section_option',
		[
			'label' => __( 'Content Options', 'edumodo' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]
);



	$this->start_controls_tabs( 'caption_control' );

		

        $this->start_controls_tab(
	        'typo_option',
	          [
	            'label' => __( 'Title Option', 'edumodo' ),
	          ]
        );

        $this->add_control(
			'title_color',
				[
					'label'     => __( 'Title Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-title' => 'color: {{VALUE}};',
					],
				]
		);

        $this->add_control(
			'title_span_color',
				[
					'label'     => __( 'Title Span Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ecb101',
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-title span' => 'color: {{VALUE}};',
					],
				]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => __( 'Title Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption .slider-title',
				]
		);


        $this->add_responsive_control(
			'edumodo_slider_height',
				[
					'label'  => __( 'Slider Height', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'range'  => [
						'px' => [
							'min' => 400,
							'max' => 1500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
		);

        $this->add_responsive_control(
			'caption_position',
				[
					'label'  => __( 'Caption Position', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
                        'size' => 200,
                    ],
					'range'  => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption' => 'top: {{SIZE}}{{UNIT}};',
					],
				]
		);


        $this->add_responsive_control(
            'caption_padding',
            [
                'label' => __( 'Title Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'caption_padding_description',
            [
                'label' => __( 'Caption Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption .slider-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        
		$this->add_responsive_control(
	         'caption_align',
		         [
		           'label' => __( 'Caption Alignment', 'edumodo' ),
		           'type' => Controls_Manager::CHOOSE,
		           'default'   => 'center',
		           'options' => [
		             'left' => [
		               'title' => __( 'Left', 'edumodo' ),
		               'icon' => 'fa fa-align-left',
		             ],
		             'center' => [
		               'title' => __( 'Center', 'edumodo' ),
		               'icon' => 'fa fa-align-center',
		             ],
		             'right' => [
		               'title' => __( 'Right', 'edumodo' ),
		               'icon' => 'fa fa-align-right',
		             ],
		             'justify' => [
		               'title' => __( 'Justified', 'edumodo' ),
		               'icon' => 'fa fa-align-justify',
		             ],
		           ],
		           'selectors' => [
		             '{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption' => 'text-align: {{VALUE}};',
		           ],
	         ]
       );

    $this->end_controls_tab();


$this->start_controls_tab(
	        'color_options',
		          [
		            'label' => __( 'Content Option', 'edumodo' ),
		          ]
	    );

		$this->add_responsive_control(
			'content_spacing',
				[
					'label'  => __( 'Slider Content Specing', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
                        'size' => 20,
                    ],
					'range'  => [
						'px' => [
							'min' => -20,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description' => 'padding-top: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->add_control(
			'content_color',
				[
					'label'     => __( 'Slider Content Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description' => 'color: {{VALUE}};',
					],
				]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'content_typography',
					'label'    => __( 'Content Typography', 'edumodo' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
					'selector' => '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description',
				]
		);

		$this->add_control(
			'item_overlay_color',
			[
				'label'     => __( 'Slider Item Overlay Bg Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'rgba(7,16,38,0.83)',
				'selectors' => [
					'{{WRAPPER}} .carousel .carousel-inner .item:before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-control:before' => 'background-color: {{VALUE}};',
				],
			]
		);


        $this->add_responsive_control(
            'desc_padding',
            [
                'label' => __( 'Description Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .carousel .carousel-inner .item .carousel-caption .slider-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
			'content_margin',
				[
					'label'     => __( 'Content Margin', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'auto',
					'options'   => [
						'none'	  => __( 'None'),
						'0'       => __( '0', 'edumodo' ),
						'auto'	  => __( 'Auto', 'edumodo' ),

					],
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .slider-description' => 'margin: {{VALUE}};',
					],
				]
		);


        $this->end_controls_tab();



    $this->end_controls_tabs();

	$this->end_controls_section();
	// caption options End


		// Button options Start
		$this->start_controls_section(
			'button_style',
				[
					'label' => __( 'Button Options', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-inner .item .carousel-caption .btn-slider',
				'separator' => 'before',
			]
		);

		$this->add_control(
		    'border_radius',
		    [
		        'label' => __( 'Border Radius', 'edumodo' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);

        $this->add_control(
            'text_padding',
            [
                'label' => __( 'Text Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

       $this->add_responsive_control(
			'btn_text_size',
				[
					'label'  => __( 'Button Text Size', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
                        'size' => 14,
                    ],
					'range'  => [
						'px' => [
							'min' => 10,
							'max' => 24,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

       	$this->add_control(
			'text_transform',
			[
				'label'     => __( 'Button Text Transform', 'edumodo' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'uppercase',
				'options'   => [
					'uppercase'   => __( 'UPPERCASE', 'edumodo' ),
					'lowercase'   => __( 'lowercase', 'edumodo' ),
					'capitalize'  => __( 'Capitalize', 'edumodo' ),
				],
				'selectors' => [
					'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'text-transform: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'button_spacing',
				[
					'label'  => __( 'Button Spacing', 'edumodo' ),
					'type'   => Controls_Manager::SLIDER,
					'default' => [
						'size' => 30,
					],
					'range'  => [
						'px' => [
							'min' => 10,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'margin: {{SIZE}}{{UNIT}} 0;',
					],
				]
			);


	$this->start_controls_tabs( 'tabs_button_style' );

    $this->start_controls_tab(
        'tab_button_normal',
          [
            'label' => __( 'Normal', 'edumodo' ),
          ]
    );

    $this->add_control(
        'button_text_color',
          [
            'label' => __( 'Text Color', 'edumodo' ),
            'type' => Controls_Manager::COLOR,
            'default' => '#fff',
            'selectors' => [
              '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'color: {{VALUE}};',
            ],
          ]
    );

    $this->add_control(
        'background_color',
	        [
	            'label' => __( 'Background Color', 'edumodo' ),
	            'type' => Controls_Manager::COLOR,
	            'default' => '#ecb101',
	            'scheme' => [
	              'type' => Scheme_Color::get_type(),
	              'value' => Scheme_Color::COLOR_4,
	              
	            ],
	            'selectors' => [
	              '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'background-color: {{VALUE}};',
	            ],
	        ]
    );

     $this->add_control(
        'button_border_color',
	        [
	            'label' => __( 'Border Color', 'edumodo' ),
	            'type' => Controls_Manager::COLOR,
	            'default' => '#ecb101',
	            'selectors' => [
	              '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider' => 'border: 1px solid {{VALUE}};',
	            ],
	        ]
        );

    $this->end_controls_tab();

    $this->start_controls_tab(
        'tab_button_hover',
	        [
	            'label' => __( 'Hover', 'edumodo' ),
	        ]
    );

    $this->add_control(
        'hover_color',
		    [
		        'label' => __( 'Text Color', 'edumodo' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#fff',
		        'selectors' => [
		          '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider:hover' => 'color: {{VALUE}};',
		        ],
		    ]
    );

    $this->add_control(
        'button_background_hover_color',
		    [
		        'label' => __( 'Background Color', 'edumodo' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#242c5e',
		        'selectors' => [
		          '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider:hover' => 'background-color: {{VALUE}};',
		        ],
		    ]
    );

    $this->add_control(
        'button_hover_border_color',
	        [
	            'label' => __( 'Border Color', 'edumodo' ),
	            'type' => Controls_Manager::COLOR,
	            'default' => '#242c5e',
	            'selectors' => [
	              '{{WRAPPER}} .carousel .carousel-inner .carousel-caption .btn-slider:hover' => 'border-color: {{VALUE}};',
	            ],
	        ]
    );

    $this->end_controls_tab();


    $this->end_controls_tabs();

$this->end_controls_section();
// Button options End




// Control options Start
$this->start_controls_section(
	'control_style',
		[
			'label' => __( 'Control Options', 'edumodo' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]
	);


	$this->start_controls_tabs( 'slider_control' );

		$this->start_controls_tab(
	          'Background Options',
	          [
	            'label' => __( 'Background', 'edumodo' ),
	          ]
	    );

			$this->add_control(
				'slider_interval',
				[
					'label' => __( 'Slider Interval', 'edumodo' ),
					'type' => Controls_Manager::TEXT,
					'default' => '10000',
				]
			);

			$this->add_control(
				'bg_repeat',
				[
					'label'     => __( 'Item Background Repeat', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'no-repeat',
					'options'   => [
						'no-repeat'  => __( 'No Repeat', 'edumodo' ),
						'repeat'     => __( 'Repeat', 'edumodo' ),
						'repeat-x'   => __( 'Repeat X', 'edumodo' ),
						'repeat-y'   => __( 'Repeat Y', 'edumodo' ),
						'inherit'    => __( 'Inherit', 'edumodo' ),
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .item' => 'background-repeat: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_size',
				[
					'label'     => __( 'Item Background Size', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'cover',
					'options'   => [
						'cover'     => __( 'Cover', 'edumodo' ),
						'contain'   => __( 'Contain', 'edumodo' ),
						'inherit'   => __( 'Inherit', 'edumodo' ),
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .item' => 'background-size: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_attachment',
				[
					'label'     => __( 'Item Background Attachment', 'edumodo' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fixed',
					'options'   => [
						'fixed'    => __( 'fixed', 'edumodo' ),
						'inherit'  => __( 'Inherit', 'edumodo' ),
					],
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .item' => 'background-attachment: {{VALUE}};',
					],
				]
			);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slider_nav',
	          [
	            'label' => __( 'Nav Options', 'edumodo' ),
	          ]
	    );

		$this->add_control(
			'nav_enable',
				[
					'label'     => __( 'Nav Enable/Disable', 'edumodo' ),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'enable'    => __( 'Enable', 'edumodo' ),
					'disable'   => __( 'Disable', 'edumodo' ),
				]
		);

		$this->add_control(
			'arrow_enable',
				[
					'label'     => __( 'Arrow Enable/Disable', 'edumodo' ),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'enable'    => __( 'Enable', 'edumodo' ),
					'disable'   => __( 'Disable', 'edumodo' ),
				]
		);

		$this->add_control(
			'nav_color',
				[
					'label'     => __( 'Nav & Arrow Icon Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-control i' => 'color: {{VALUE}};',
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-indicators li' => 'background-color:{{VALUE}};',
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-control' => 'border:1px solid {{VALUE}};',
					],
				]
		);

		$this->add_control(
			'nav_bg_color',
				[
					'label'     => __( 'Nav & Arrow Bg Color', 'edumodo' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ecb101',
					'selectors' => [
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-indicators>li.active' => 'background: {{VALUE}};',
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-indicators li.active' => 'border:1px solid {{VALUE}};',
						'{{WRAPPER}} .edumodo-hero-unit  .carousel-control:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .edumodo-hero-unit .carousel .carousel-control:hover' => 'background-color:{{VALUE}};',
					],
				]
		);

    $this->end_controls_tab();

    $this->end_controls_tabs();

$this->end_controls_section();
// Control options End

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/slider/template/view.php';
	}


}
