<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Post_Grid extends Widget_Base {
        public function get_name() {
        return 'edumodo-posts-grid';
    }

    public function get_title() {
        return __('Post Grid', 'edumodo');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories() {
        return array('edumodo');
    }

    public function get_script_depends() {
        return [
            'jquery-slick',
        ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_posts_carousel',
            [
                'label' => __('Posts Query', 'edumodo'),
            ]
        );

        $this->add_control(
            'post_types',
            [
                'label' => __('Post Types', 'edumodo'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'post',
                'options' => edumodo_get_all_post_type_options(),
                'multiple' => true
            ]
        );

        $this->add_control(
            'tax_query',
            [
                'label' => __('Taxonomies', 'edumodo'),
                'type' => Controls_Manager::SELECT2,
                'options' => edumodo_get_all_taxonomy_options(),
                'multiple' => true,
                'label_block' => true
            ]
        );

        $this->add_control(
            'post_in',
            [
                'label' => __('Post In', 'edumodo'),
                'description' => __('Provide a comma separated list of Post IDs to display in the grid.', 'edumodo'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'advanced',
            [
                'label' => __('Advanced', 'edumodo'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'none' => __('No order', 'edumodo'),
                    'ID' => __('Post ID', 'edumodo'),
                    'author' => __('Author', 'edumodo'),
                    'title' => __('Title', 'edumodo'),
                    'date' => __('Published date', 'edumodo'),
                    'modified' => __('Modified date', 'edumodo'),
                    'parent' => __('By parent', 'edumodo'),
                    'rand' => __('Random order', 'edumodo'),
                    'comment_count' => __('Comment count', 'edumodo'),
                    'menu_order' => __('Menu order', 'edumodo'),
                    'post__in' => __('By include order', 'edumodo'),
                ),
                'default' => 'date',
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'ASC' => __('Ascending', 'edumodo'),
                    'DESC' => __('Descending', 'edumodo'),
                ),
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_content',
            [
                'label' => __('Post Content', 'edumodo'),
            ]
        );
        $this->add_control(
            'taxonomy_chosen',
            [
                'label' => __('Choose the taxonomy to display info.', 'edumodo'),
                'description' => __('Choose the taxonomy to use for display of taxonomy information for posts/custom post types.', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'default' => 'category',
                'options' => edumodo_get_taxonomies_map(),
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size',
                'label' => __('Image Size', 'edumodo'),
                'default' => 'large',
            ]
        );

        $this->add_control(
            'image_linkable',
            [
                'label' => __('Link Images to Posts?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'display_title',
            [
                'label' => __('Display posts title below the post item?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'display_summary',
            [
                'label' => __('Display post excerpt/summary below the post item?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'content_excerpt_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 1,
                'max' => 200,
                'step' => 1,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_meta',
            [
                'label' => __('Post Meta', 'edumodo'),
            ]
        );


        $this->add_control(
            'display_author',
            [
                'label' => __('Display post author info below the post item?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'display_post_date',
            [
                'label' => __('Display post date info below the post item?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'display_taxonomy',
            [
                'label' => __('Display taxonomy info below the post item?', 'edumodo'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'edumodo'),
                'label_off' => __('No', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_carousel_settings',
            [
                'label' => __('Carousel Settings', 'edumodo'),
                //'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        $this->add_control(
            'active_carousel',
            [
                'label' => __( 'Active Carousel', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'epc-active',
            ]
        );
        $this->add_control(
            'arrows',
            [
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('No', 'edumodo'),
                'label_on' => __('Yes', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'label' => __('Prev/Next Arrows?', 'edumodo'),
            ]
        );


        $this->add_control(
            'dots',
            [
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('No', 'edumodo'),
                'label_on' => __('Yes', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'no',
                'label' => __('Show dot indicators for navigation?', 'edumodo'),
            ]
        );

        $this->add_control(
            'pause_on_hover',
            [
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('No', 'edumodo'),
                'label_on' => __('Yes', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'label' => __('Pause on Hover?', 'edumodo'),
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('No', 'edumodo'),
                'label_on' => __('Yes', 'edumodo'),
                'return_value' => 'yes',
                'default' => 'no',
                'label' => __('Autoplay?', 'edumodo'),
                'description' => __('Should the carousel autoplay as in a slideshow.', 'edumodo'),
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => __('Autoplay speed in ms', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3000,
            ]
        );


        $this->add_control(
            'animation_speed',
            [
                'label' => __('Autoplay animation speed in ms', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 300,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_responsive',
            [
                'label' => __('Responsive Options', 'edumodo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_desktop',
            [
                'label' => __('Desktop', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'gutter',
            [
                'label' => __('Gutter', 'edumodo'),
                'description' => __('Space between columns.', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'display_columns',
            [
                'label' => __('Columns per row', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );


        $this->add_control(
            'scroll_columns',
            [
                'label' => __('Columns to scroll', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );

        $this->add_control(
            'heading_tablet',
            [
                'label' => __('Tablet', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'tablet_gutter',
            [
                'label' => __('Gutter', 'edumodo'),
                'description' => __('Space between columns.', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '(tablet-){{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );


        $this->add_control(
            'tablet_display_columns',
            [
                'label' => __('Columns per row', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 2,
            ]
        );

        $this->add_control(
            'tablet_scroll_columns',
            [
                'label' => __('Columns to scroll', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 2,
            ]
        );

        $this->add_control(
            'tablet_width',
            [
                'label' => __('Tablet Resolution', 'edumodo'),
                'description' => __('The resolution to treat as a tablet resolution.', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 800,
            ]
        );


        $this->add_control(
            'heading_mobile',
            [
                'label' => __('Mobile Phone', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'mobile_gutter',
            [
                'label' => __('Mobile Gutter', 'edumodo'),
                'description' => __('Space between columns.', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '(mobile-){{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'mobile_display_columns',
            [
                'label' => __('Columns per row', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'mobile_scroll_columns',
            [
                'label' => __('Columns to scroll', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'mobile_width',
            [
                'label' => __('Mobile Resolution', 'edumodo'),
                'description' => __('The resolution to treat as a mobile resolution.', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 480,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_carousel_item_thumbnail_styling',
            [
                'label' => __('Post Thumbnail', 'edumodo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'thumbnail_hover_bg_color',
            [
                'label' => __('Thumbnail Hover Background Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'thumbnail_hover_opacity',
            [
                'label' => __('Thumbnail Hover Opacity (%)', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0.5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image:before' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_thumbnail_info',
            [
                'label' => __('Thumbnail Info Entry Title', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title HTML Tag', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => __('H1', 'edumodo'),
                    'h2' => __('H2', 'edumodo'),
                    'h3' => __('H3', 'edumodo'),
                    'h4' => __('H4', 'edumodo'),
                    'h5' => __('H5', 'edumodo'),
                    'h6' => __('H6', 'edumodo'),
                    'div' => __('div', 'edumodo'),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_border_color',
            [
                'label' => __('Title Hover Border Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-post-title a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-post-title',
            ]
        );

        $this->add_control(
            'heading_thumbnail_info_taxonomy',
            [
                'label' => __('Thumbnail Info Taxonomy Terms', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'thumbnail_info_tags_color',
            [
                'label' => __('Taxonomy Terms Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-terms, {{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-terms a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tags_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-terms, {{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-project-image .edumodo-image-info .edumodo-terms a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_title_styling',
            [
                'label' => __('Post Entry Title', 'edumodo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'entry_title_tag',
            [
                'label' => __('Entry Title HTML Tag', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => __('H1', 'edumodo'),
                    'h2' => __('H2', 'edumodo'),
                    'h3' => __('H3', 'edumodo'),
                    'h4' => __('H4', 'edumodo'),
                    'h5' => __('H5', 'edumodo'),
                    'h6' => __('H6', 'edumodo'),
                    'div' => __('div', 'edumodo'),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'entry_title_color',
            [
                'label' => __('Entry Title Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .entry-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .entry-title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_summary_styling',
            [
                'label' => __('Post Entry Summary', 'edumodo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'entry_summary_color',
            [
                'label' => __('Entry Summary Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .entry-summary' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_summary_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .entry-summary',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_meta_styling',
            [
                'label' => __('Post Entry Meta', 'edumodo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_entry_meta',
            [
                'label' => __('Entry Meta', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'entry_meta_color',
            [
                'label' => __('Entry Meta Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-entry-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_meta_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-entry-meta span',
            ]
        );


        $this->add_control(
            'heading_entry_meta_link',
            [
                'label' => __('Entry Meta Link', 'edumodo'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'entry_meta_link_color',
            [
                'label' => __('Entry Meta Link Color', 'edumodo'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-entry-meta span a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_meta_link_typography',
                'selector' => '{{WRAPPER}} .edumodo-posts-carousel .edumodo-posts-carousel-item .edumodo-entry-meta span a',
            ]
        );


    }

    protected function render() {

        $settings = $this->get_settings();
        $excerpt_word = $settings['content_excerpt_word'];

        $settings = $this->get_settings_for_display();

        $settings = apply_filters('edumodo_posts_carousel_' . $this->get_id() . '_settings', $settings);

        $taxonomies = array();

        $carousel_settings = [
            'arrows' => ('yes' === $settings['arrows']),
            'dots' => ('yes' === $settings['dots']),
            'autoplay' => ('yes' === $settings['autoplay']),
            'autoplay_speed' => absint($settings['autoplay_speed']),
            'animation_speed' => absint($settings['animation_speed']),
            'pause_on_hover' => ('yes' === $settings['pause_on_hover']),
        ];

        $responsive_settings = [
            'display_columns' => $settings['display_columns'],
            'scroll_columns' => $settings['scroll_columns'],
            'gutter' => $settings['gutter'],
            'tablet_width' => $settings['tablet_width'],
            'tablet_display_columns' => $settings['tablet_display_columns'],
            'tablet_scroll_columns' => $settings['tablet_scroll_columns'],
            'tablet_gutter' => $settings['tablet_gutter'],
            'mobile_width' => $settings['mobile_width'],
            'mobile_display_columns' => $settings['mobile_display_columns'],
            'mobile_scroll_columns' => $settings['mobile_scroll_columns'],
            'mobile_gutter' => $settings['mobile_gutter'],

        ];

        $carousel_settings = array_merge($carousel_settings, $responsive_settings);

        // Use the processed post selector query to find posts.
        $query_args = edumodo_build_query_args($settings);

        $query_args = apply_filters('edumodo_posts_carousel_'. $this->get_id() . '_query_args', $query_args, $settings);

        $loop = new \WP_Query($query_args);

        // Loop through the posts and do something with them.
        if ($loop->have_posts()) :

            $post_id = get_the_ID();
               
            $output = '<div id="edumodo-posts-carousel-' . uniqid()
                . '" class="edumodo-posts-carousel '. $settings['active_carousel'].' edumodo-container" data-settings=\'' . wp_json_encode($carousel_settings) . '\'>';

            $taxonomies[] = $settings['taxonomy_chosen'];

            while ($loop->have_posts()) : $loop->the_post();

                $entry_output = '<div data-id="id-' . get_the_ID() . '" class="edumodo-posts-carousel-item col-md-4">';

                $entry_output .= '<article id="post-' . get_the_ID() . '" class="' . join(' ', get_post_class('', $post_id)) . '">';

                if ($thumbnail_exists = has_post_thumbnail()):

                    $entry_image = '<div class="edumodo-project-image">';

                    $image_setting = ['id' => get_post_thumbnail_id()];

                    $thumbnail_html = edumodo_get_image_html($image_setting, 'thumbnail_size', $settings);

                    if ($settings['image_linkable'] == 'yes'):

                        $thumbnail_html = '<a href="' . get_the_permalink() . '">' . $thumbnail_html . '</a>';

                    endif;

                    $entry_image .= apply_filters('edumodo_posts_carousel_thumbnail_html', $thumbnail_html, $image_setting, $settings);

                    $image_info = '<div class="edumodo-image-info">';

                    $image_info .= '<div class="edumodo-entry-info">';

                    $image_info .= '<' . $settings['title_tag'] . ' class="edumodo-post-title"><a href="' . get_permalink() . '" title="' . get_the_title() . '" rel="bookmark">' . get_the_title() . '</a></' . $settings['title_tag'] . '>';

                    $image_info .= edumodo_get_info_for_taxonomies($taxonomies);

                    $image_info .= '</div>';

                    $image_info .= '</div><!-- .edumodo-image-info -->';

                    $entry_image .= apply_filters('edumodo_posts_carousel_image_info', $image_info, $post_id, $settings);

                    $entry_image .= '</div>';

                    $entry_output .= apply_filters('edumodo_posts_carousel_entry_image', $entry_image, $post_id, $image_setting, $settings);

                endif;

                if (($settings['display_title'] == 'yes') || ($settings['display_summary'] == 'yes')) :

                    $entry_output .= '<div class="edumodo-entry-text-wrap ' . ($thumbnail_exists ? '' : ' nothumbnail') . '">';

                    if ($settings['display_title'] == 'yes') :

                        $entry_title = '<' . $settings['entry_title_tag']
                            . ' class="entry-title"><a href="' . get_permalink()
                            . '" title="' . get_the_title()
                            . '" rel="bookmark">' . get_the_title()
                            . '</a></' . $settings['entry_title_tag'] . '>';

                        $entry_output .= apply_filters('edumodo_posts_carousel_entry_title', $entry_title, $post_id, $settings);

                    endif;

                    if (($settings['display_post_date'] == 'yes') || ($settings['display_author'] == 'yes') || ($settings['display_taxonomy'] == 'yes')) :

                        $entry_meta = '<div class="edumodo-entry-meta">';

                        if ($settings['display_author'] == 'yes'):

                            $entry_meta .= edumodo_entry_author();

                        endif;

                        if ($settings['display_post_date'] == 'yes'):

                            $entry_meta .= edumodo_entry_published();

                        endif;

                        if ($settings['display_taxonomy'] == 'yes'):

                            $entry_meta .= edumodo_get_info_for_taxonomies($taxonomies);

                        endif;

                        $entry_meta .= '</div>';

                        $entry_output .= apply_filters('edumodo_posts_carousel_entry_meta', $entry_meta, $post_id, $settings);

                    endif;

                    if ($settings['display_summary'] == 'yes') :

                        $excerpt = '<div class="entry-summary">';

                        $excerpt .= wp_trim_words(get_the_excerpt(), $excerpt_word, '');

                        $excerpt .= '</div>';

                        $entry_output .= apply_filters('edumodo_posts_carousel_entry_excerpt', $excerpt, $post_id, $settings);

                    endif;

                    $entry_output .= '</div>';

                endif;

                $entry_output .= '</article><!-- .hentry -->';

                $entry_output .= '</div><!-- .edumodo-posts-carousel-item -->';

                $output .= apply_filters('edumodo_posts_carousel_entry_output', $entry_output, $post_id, $settings);

            endwhile;

            wp_reset_postdata();

            $output .= '</div><!-- .edumodo-posts-carousel -->';

            echo apply_filters('edumodo_posts_carousel_output', $output, $settings);

        endif;

    }

    protected function content_template() {
    }
}