<?php
    $settings = $this->get_settings();

    // Global Options
    global $post;
     // Prefix
    $prefix = '_edumodo_';
    
    $cat_enable = $settings['cat_enable'];
    $view_enable = $settings['view_enable'];

?>

    <section class="edumodo-notice-1">
         <div class="row">
                <?php
                        $notice = array(
                            'post_type'         => 'notice',
                            'posts_per_page'    => $settings['posts_per_page']
                        );

                    $notice_query = new WP_Query( $notice );
                        if($notice_query->have_posts()):
                            while($notice_query->have_posts()): 
                                $notice_query->the_post(); 
                ?>

                <div class="col-md-<?php echo $settings['posts_column']; ?> col-sm-6">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('custom-post'); ?>>
                        <?php if ( has_post_thumbnail() ):?>
                            <figure class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php  the_post_thumbnail();?>
                                </a>
                            </figure>
                        <?php endif; ?>

                        <div class="notice-details">
                            <header class="entry-header">
                                <h4 class="notice-entry-title">
                                    <a href="<?php the_permalink();?>">
                                        <?php esc_html_e(wp_trim_words( get_the_title(),7, ''), 'edumodo'); ?>                                     
                                    </a>
                                </h4>       
                            </header><!-- .entry-header -->

                            <div class="notice-meta">
                            <?php if($cat_enable == 'yes'): ?>
                                <span class="post-date">
                                    <i class="fa fa-calendar"></i> 
                                     <?php 
                                        $archive_year  = get_the_time('Y'); 
                                        $archive_month = get_the_time('m'); 
                                        $archive_day   = get_the_time('d'); 
                                    ?>
                                    <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>   
                                </span>
                            <?php endif ; ?>
                             <?php if($view_enable == 'yes'): ?>
                                <span class="post-view">
                                    <i class="fa fa-eye"></i> 
                                    <?php echo getPostViews(get_the_ID()); ?>
                                </span>
                            <?php endif ; ?>
                            </div><!-- .entry-meta -->


                            <?php if ($notice_query):?>
                                <div class="entry-content">
                                    <p><?php esc_html_e(wp_trim_words( get_the_content(),15, ''), 'edumodo'); ?></p>
                                </div><!-- .entry-content -->
                            <?php endif; ?>
                        </div><!-- .notice details -->
                    </article><!-- #post-## -->
                </div> <!-- /.col-md-4 -->

            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div><!-- /.row -->     
    </section> <!-- /.section -->
