<?php


use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Notice
 *
 * Elementor widget for edumodo Notice
 *
 * @since 1.0.0
 */
class Edumodo_Notice_1 extends Widget_Base {

	public function get_name() {
		return 'edumodo-notice-1';
	}

	public function get_title() {
		return __( 'Notice', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-document-file';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-notice-1' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'notice1_section_title_typography',
			[
				'label' => __( 'Title', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'notice1_title_typography',
                'selector' => '{{WRAPPER}} .edumodo-notice-1 .notice-entry-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(

			'section_meta',
			[
				'label' => __( 'Meta', 'edumodo' ),
			]
		);

        $this->add_control(
            'cat_enable',
            [
                'label' => __( 'Show Categorie', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'view_enable',
            [
                'label' => __( 'Show View Count', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'selector' => '{{WRAPPER}} .edumodo-notice-1 article.notice .notice-details .notice-meta span a, .edumodo-notice-1 .type-notice .notice-details .notice-meta span a, .edumodo-notice-1 .type-notice .notice-details .notice-meta .post-date a, .edumodo-notice-1 .type-notice .notice-details .notice-meta span',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_desc_typography',
			[
				'label' => __( 'Description', 'edumodo' ),
			]
		);

       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .edumodo-notice-1 .entry-content  p',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'section_style',
                [
                    'label' => __( 'Title', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .edumodo-notice-1 header  a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_style_meta',
				[
					'label' => __( 'Meta', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

		$this->add_control(
			'meta_color',
			[
				'label'     => __( 'Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
                    '{{WRAPPER}} .edumodo-notice-1 article.notice .notice-details .notice-meta .post-view, .edumodo-notice-1 .type-notice .notice-details .notice-meta .post-view' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-notice-1 article.notice .notice-details .notice-meta .post-date, .edumodo-notice-1 .type-notice .notice-details .notice-meta .post-date' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .edumodo-notice-1 article.notice .notice-details .notice-meta .post-view i, .edumodo-notice-1 .type-notice .notice-details .notice-meta .post-view i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-notice-1 article.notice .notice-details .notice-meta .post-date a, .edumodo-notice-1 .type-notice .notice-details .notice-meta .post-date a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_border_shadow',
				[
					'label' => __( 'Border', 'edumodo' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

	        $this->add_control(
            'border_color',
            [
                'label' => __( 'Border Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .edumodo-notice-1 article.notice, .edumodo-notice-1 .type-notice' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __( 'Border Width', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-notice-1 article.notice, .edumodo-notice-1 .type-notice' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .teacher-2 .edumodo-notice-1 article.notice, .edumodo-notice-1 .type-notice' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .edumodo-notice-1 article.notice, .edumodo-notice-1 .type-notice',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [   'label' => __( 'Box Shadow Hover', 'edumodo' ),
                'name' => 'box_shadow_hover',
                'selector' => '{{WRAPPER}} .edumodo-notice-1 article.notice, .edumodo-notice-1 .type-notice:hover',
            ]
        );

		$this->end_controls_section();

	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/notice-1/template/view.php';
	}


}
