<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Course Categeries
 *
 * @since 1.0.0
 */
class Edumodo_Widget_Learnpress_Categories extends Widget_Base {

	public function get_name() {
		return 'edumodo-learnpress-categories';
	}

	public function get_title() {
		return __( 'Learnpress Categories', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-menu-bar';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function _register_controls() {

        $cat = array();
        $terms = get_terms( array(
            'post_type' => 'lp_course',
            'taxonomy' => 'course_category',
            'hide_empty' => false,
            'fields'   => 'id=>name'
        ) );

        foreach ($terms as $key => $value) {
		//    $cat[ucwords()] = ;
		//    $cat[$key] = $value;
            $cat[$key] = $value;
        }
    

		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Image', 'edumodo' ),
			]
		);

        $this->add_control(
            'lp_course_category_id',
            [
                'label'       => __( 'Course Category ID', 'edumodo' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => '',
                'options' => $cat,
            ]
        );

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'edumodo' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Actually its `image_size`.
				'label' => __( 'Image Size', 'edumodo' ),
				'default' => 'large',
			]
		);

        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'lp_catogories_bg_color',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .lp-course-categories:before',
                ]
        );
        
    $this->add_responsive_control(
            'image_fixed_height',
            [
                'label' => __( 'Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 900,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .lp-course-categories img' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .lp-course-categories' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_control(
            'show_hide_lp_categories_courses',
            [
                'label' => __( 'Show Over Course', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'title_section_style',
                [
                    'label' => __( 'Title', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [   
                    'label' => __( 'Title Typography', 'edumodo' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta a .lp-categories',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta a .lp-categories' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

	}


	/**
	 * Render image widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings();

		if ( empty( $settings['image']['url'] ) ) {
			return;
		}

		$this->add_render_attribute( 'wrapper', 'class', 'elementor-image' );

		if ( ! empty( $settings['shape'] ) ) {
			$this->add_render_attribute( 'wrapper', 'class', 'elementor-image-shape-' . $settings['shape'] );
		}

        $show_hide_lp_categories_courses = $settings['show_hide_lp_categories_courses'];
        $category = get_term($settings['lp_course_category_id']);

        if($settings['lp_course_category_id']):
            $args = array(
                'post_type' => 'lp_course',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'course_category',
                        'field' => 'slug',
                       // 'terms' => array($category->slug),
                    ),
                ),
                'posts_per_page' => -1,
            );
            $loop = new WP_Query( $args );
            $course_count = count($loop->posts);
            $lesson_count = 0;
            $term_link = get_term_link( $category);
            ?>
            
            <div class="lp-course-categories">
                <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings ); ?>
                <div class="content-body">
                    <div class="lp-course-meta">
                        <a href="<?php if($term_link == '') : echo $term_link; endif; ?>"><h2 class="lp-categories"><?php echo esc_html($category->name); ?></h2></a>
                        <?php if($show_hide_lp_categories_courses == 'yes'): ?>
                            <div class="lp-course"><span><?php esc_html_e($course_count.' Courses', 'edumodo') ; ?></span></div>
                         <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif;
	}

}
