<?php
/**
 * Dynamic category
 * =================
 */
add_action( 'wp_ajax_nopriv_dynamicCat', 'dynamic_cat' );
add_action( 'wp_ajax_dynamicCat', 'dynamic_cat' );
if(! function_exists('dynamic_cat')){
    function dynamic_cat(){
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];
        $coursePrice = $_REQUEST['coursePrice'];
        $courseHeight = $_REQUEST['courseHeight'];
        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'sfwd-courses',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'ld_course_category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-coursePrice="<?php echo $coursePrice; ?>"
            data-postsColumn="<?php echo $postsColumn; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            class="cat-post-list dynamic-cat-post-list animated fadeIn">
            <div id="lp-dynamic-course-carousel" class="<?php echo $activeCarousel ? 'lp-dynamic-course-active owl-carousel' : ''; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();


                  global $post; $post_id = $post->ID;
                  $course_id = $post_id;
                  $user_id   = get_current_user_id();
                  $current_id = $post->ID;

                  $enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
                  $embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
                  $button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

                  // Retrive oembed HTML if URL provided
                  if ( preg_match( '/^http/', $embed_code ) ) {
                      $embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
                  }

                  $button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

                  $button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

                  $options = get_option('sfwd_cpt_options');
                  $currency = null;

                  if ( ! is_null( $options ) ) {
                      if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
                      $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
                  }

                  if( is_null( $currency ) )
                      $currency = 'USD';

                  $course_options = get_post_meta($post_id, "_sfwd-courses", true);
                  $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
                  $short_description = @$course_options['sfwd-courses_course_short_description'];

                  $has_access   = sfwd_lms_has_access( $course_id, $user_id );
                  $is_completed = learndash_course_completed( $user_id, $course_id );

                  if( $price == '' )
                      $price .= __( 'Free', 'edumodo' );

                  if ( is_numeric( $price ) ) {
                      if ( $currency == "USD" )
                          $price = '$' . $price;
                      else
                          $price .= ' ' . $currency;
                  }

                  $class       = '';
                  $ribbon_text = '';

                  if ( $has_access && ! $is_completed ) {
                      $class = 'ld_course_grid_price ribbon-enrolled';
                      $ribbon_text = __( 'Enrolled', 'edumodo' );
                  } elseif ( $has_access && $is_completed ) {
                      $class = 'ld_course_grid_price';
                      $ribbon_text = __( 'Completed', 'edumodo' );
                  } else {
                      $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
                      $ribbon_text = $price;
                  }

                        ?>
 
                        <div class="<?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                      <article id="post-<?php the_ID(); ?>" <?php post_class('thumbnail course'); ?>>
                          
                        <?php if ( $post->post_type == 'sfwd-courses' ) : ?>
                        <div class="<?php echo esc_attr( $class ); ?>">
                            <?php echo esc_attr( $ribbon_text ); ?>
                        </div>
                        <?php endif; ?>

                        <?php if ( 1 == $enable_video && ! empty( $embed_code ) ) : ?>
                        <div class="ld_course_grid_video_embed">
                        <?php echo $embed_code; ?>
                        </div>
                        <?php elseif( has_post_thumbnail() ) :?>
                        <a href="<?php the_permalink(); ?>" rel="bookmark">
                            <?php the_post_thumbnail('course-thumb'); ?>
                        </a>
                        <?php else :?>
                        <a href="<?php the_permalink(); ?>" rel="bookmark">
                            <img alt="" src="<?php echo plugins_url( 'no_image.jpg', LEARNDASH_COURSE_GRID_FILE); ?>"/>
                        </a>
                        <?php endif;?>
                        <div class="caption">

                            <h3 class="entry-title">
                                <a class="course-title-link" href="<?php the_permalink();?>">
                                    <?php the_title();?>
                                </a>
                            </h3>

                          <?php if(!empty($short_description)) { ?>
                          <p class="entry-content"><?php echo htmlspecialchars_decode( do_shortcode( $short_description ) ); ?></p>
                          <?php  } ?>

                            <p class="ld_course_grid_button"><a class="btn btn-primary" role="button" href="<?php the_permalink()?>" rel="bookmark"><?php esc_html_e( $button_text, 'edumodo' ); ?></a></p>

                        </div>
                      </article><!-- #post-## -->
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}
