<?php
$settings = $this->get_settings();
global $post;
$prefix = '_edumodo_';

$show_hide_post_author = $settings['show_hide_post_author'];
$latest_title_word     = $settings['latest_title_word'];
$excerpt_word          = $settings['latest_excerpt_word'];
$btn_text              = $settings['btn_text'];
$show_hide_post_image  = $settings['show_hide_post_image'];

?>

    <div id="edumodo-letest-posts3" class="edumodo-letest-posts3">
         <div class="row">
    <?php
        $blog = array(
            'post_type'           => 'post',
            'posts_per_page'      => $settings['posts_per_page'],
            'ignore_sticky_posts' => 1,
    );

    $blog_query = new WP_Query($blog);
    if ($blog_query->have_posts()):
        while ($blog_query->have_posts()):
            $blog_query->the_post();
            ?>

    <div class="edumodo-letest-posts3-content col-md-6 col-sm-6">
        <article id="post-<?php the_ID();?>" <?php post_class('letest-posts3');?>>
            <?php if ($show_hide_post_image): ?>
                <figure class="post-thumbnail">
                    <a href="<?php the_permalink();?>">
                        <?php the_post_thumbnail();?>
                    </a>
                </figure>
            <?php endif; ?>
            <div class="posts3-content-body">

                <header class="entry-header">
                    <h4 class="post-entry-title">
                        <a href="<?php the_permalink();?>">
                           <?php echo wp_trim_words(get_the_title(), $latest_title_word, ''); ?>
                        </a>
                    </h4>
                </header>

                <div class="entry-content">
                     <p><?php echo wp_trim_words(get_the_excerpt(), $excerpt_word, ''); ?></p>
                </div>

            <?php if ($btn_text): ?>
                <footer class="blog-entry-footer">
                    <div class="text-left post-comment">
                        <span> <i class="fa fa-comment" aria-hidden="true"></i> <?php echo get_comments_number(); ?></span>
                    </div>
                    <div class="post-date text-right">
                        <span>
                            <?php
                                $archive_year  = get_the_time('Y');
                                $archive_month = get_the_time('m');
                                $archive_day   = get_the_time('d');
                            ?>
                           <a href="<?php echo get_day_link($archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date('M j, Y'); ?></a>
                        </span>
                    </div>
                </footer>
            <?php endif;?>
        </div>

    </article>
    </div> 

    <?php endwhile;
    wp_reset_postdata();endif;?>
        </div>
    </div> 
