<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo course
 *
 * Elementor widget for edumodo course
 *
 * @since 1.0.0
 */
class Edumodo_Latest_Post extends Widget_Base {

	public function get_name() {
		return 'edumodo-latest-posts';
	}

	public function get_title() {
		return __( 'Latest Blog Posts', 'edumodo' );
	}

	public function get_icon() {
		return 'eicon-post-content';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	public function get_script_depends() {
		return [ 'edumodo-latest-posts' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'edumodo' ),
			]
		);

        $this->add_control(
            'blog_layout',
            [
                'label' => __('Layout', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout_1',
                'options' => [
                    'layout_1' => __('Layout 1', 'edumodo'),
                    'layout_2' => __('Layout 2', 'edumodo'),
                    'layout_3' => __('Layout 3', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => -1,
                'max' => 50,
                'step' => 1,
            ]
        );

        $this->add_control(
            'posts_column',
            [
                'label' => __('Column', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '2' => __('6 Column', 'edumodo'),
                    '3' => __('4 Column', 'edumodo'),
                    '4' => __('3 Column', 'edumodo'),
                    '6' => __('2 Column', 'edumodo'),
                    '12' => __('1 Column', 'edumodo'),
                ],
                'condition' => [
                    'blog_layout' => array('layout_1', 'layout_2'),
                ],
            ]
        );

        $this->add_responsive_control(
            'image_fixed_height',
            [
                'label' => __( 'Image Height', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-thumbnail img' => 'max-height: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'show_hide_post_image',
            [
                'label' => __( 'Image', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]

        );

		$this->end_controls_section();

		$this->start_controls_section(
			'edumodo_section_title_typography',
			[
				'label' => __( 'Title', 'edumodo' ),
			]
		);
        $this->add_control(
            'latest_title_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 7,
                'min' => 1,
                'max' => 50,
                'step' => 1,
            ]
        );
       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'edumodo_title_typography',
                'selector' => '.letest-posts-1 .post-content-body .entry-header .post-entry-title, .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .post-entry-title a, #edumodo-letest-posts3 .edumodo-letest-posts3-content .posts3-content-body h4.post-entry-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .letest-posts-1 .post-content-body .entry-header .post-entry-title a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .post-entry-title a' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .post-entry-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_meta',
			[
				'label' => __( 'Meta', 'edumodo' ),
			]
		);

        $this->add_control(
            'show_hide_post_author',
            [
                'label' => __( 'Author', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'condition' => [
                     'blog_layout' => 'layout_1',
                ]
            ]

        );


        $this->add_control(
            'show_hide_post_date',
            [
                'label' => __( 'Date', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
	           	'condition' => [
	                 'blog_layout' => 'layout_2',
	            ]
            ]

        );

        $this->add_control(
            'show_hide_post_cat',
            [
                'label' => __( 'Categories', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
	           	'condition' => [
	                 'blog_layout' => 'layout_2',
	            ]
            ]

        );

		$this->add_control(
			'latest_post_date_color',
			[
				'label'     => __( 'Date Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .letest-posts-1 .post-content-body .entry-meta .post-date a' => 'color: {{VALUE}};',
				],
			]
		);
		
       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'selector' => '.edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-meta .post-date a, .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-meta .post-cat ul.post-categories li a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        
		$this->end_controls_section();

		$this->start_controls_section(
			'section_desc_typography',
			[
				'label' => __( 'Description', 'edumodo' ),
			]
		);

        $this->add_control(
            'latest_excerpt_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 5,
                'max' => 50,
                'step' => 1,
            ]
        );
		$this->add_control(
			'letest_desc_color',
			[
				'label'     => __( 'Content Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .letest-posts-1 .post-content-body .entry-content' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-content' => 'color: {{VALUE}};',
				],
			]
		);
       	$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .letest-posts-1 .post-content-body .entry-content, .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-content',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->add_responsive_control(
            'desc_padding',
            [
                'label' => __( 'Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'desc_margin',
            [
                'label' => __( 'Margin', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .entry-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_read_more',
			[
				'label' => __( 'Read More', 'edumodo' ),
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => __( 'Typography', 'edumodo' ),
                'name' => 'read_more_btn_typography',
                'selector' => '.edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .blog-btn a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
		$this->add_control(
			'btn_text',
			[
				'label' => __( 'Button Text', 'edumodo' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'edumodo' ),
				'placeholder' => __( 'Read More', 'edumodo' ),
			]
		);
		$this->add_control(
			'read_more_btn_color',
			[
				'label'     => __( 'Button Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts .letest-posts-1 .post-content-body span.blog-btn a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .blog-btn a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'read_more_btn_hover_color',
			[
				'label'     => __( 'Button Hover Color', 'edumodo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts .letest-posts-1 .post-content-body span.blog-btn a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body .blog-btn:hover a' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body footer.blog-entry-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-letest-posts.kindergarten .letest-posts-2 .post-content-body footer.blog-entry-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

		$this->end_controls_section();

        // Style
        $this->start_controls_section(
            'section_style',
                [
                    'label' => __( 'Style', 'edumodo' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
        $this->add_control(
            'bg_color',
            [
                'label'     => __( 'Background', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #edumodo-letest-posts3 .edumodo-letest-posts3-content .posts3-content-body' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => __('Content Padding', 'reptro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}}  #edumodo-letest-posts3 .edumodo-letest-posts3-content .posts3-content-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
        $this->end_controls_section();
	}

	protected function render() {
		require EDUMODO_CORE_ROOT . '/elements/latest-post/template/view.php';
	}


}
