<?php

//tribe_events
//tribe_venue
//tribe_organizer

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Blog
 *
 * Elementor widget for edumodo blog
 *
 * @since 1.0.0
 */
class Edumodo_Event_Config extends Widget_Base {

	public function get_name() {
		return 'edumodo-event';
	}

	public function get_title() {
		return __( 'Event One', 'edumodo' );
	}

	public function get_icon() {
		return ' eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'edumodo' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
//	public function get_script_depends() {
//		return [ 'edumodo-blog-1' ];
//	}

	protected function _register_controls() {
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Content', 'edumodo' ),
            ]
        );
        $this->add_control(
            'posts_column',
            [
                'label' => __('Query Type', 'edumodo'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    'specific-event' => esc_html__('Specific Event', 'edumodo'),
                    'latest-event' => esc_html__('Latest Event', 'edumodo'),
                ],
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Item to Show', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 4,
                'step' => 1,
            ]
        );
        $this->add_control(
            'title_word',
            [
                'label' => __('Title Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );
        $this->add_control(
            'show_thumbnail',
            [
                'label' => __( 'Show Thumbnail', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'excerpt_word',
            [
                'label' => __('Excerpt Word', 'edumodo'),
                'type' => Controls_Manager::NUMBER,
                'default' => 25,
                'min' => 20,
                'max' => 40,
                'step' => 1,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Title', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .event-wrapper .e-event-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .event-wrapper .e-event-title h2',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Content', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label'     => __( 'Content Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .event-wrapper .e-single-event .e-event-description' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .event-wrapper .e-single-event .e-event-description',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Button', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .event-wrapper .e-single-event .link-to-main-post' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .event-wrapper .e-single-event .link-to-main-post',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_meta',
            [
                'label' => __( 'Meta', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label'     => __( 'Color', 'edumodo' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .event-wrapper .e-single-event .e-event-time' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'selector' => '{{WRAPPER}} .event-wrapper .e-single-event .e-event-time',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();
	}

	protected function render() {
        $settings = $this->get_settings();
        $number_of_post = $settings['posts_per_page'];
        $title_word = $settings['title_word'];
        $excerpt_word = $settings['excerpt_word'];
        $column_number = 12 / $number_of_post;
        $show_thumbnail = $settings['show_thumbnail'];

        $args = array(
            'post_type' => 'tribe_events',
            'posts_per_page' => $number_of_post,
        );

        $query = new WP_Query($args);

        if($query->have_posts() and class_exists( 'Tribe__Events__Main' ) ):
            while($query->have_posts()):
                $query->the_post(); ?>
    
                <div class="event-wrapper">
                    <?php $event_color = get_post_meta(get_the_ID(),  '_edumodo_event_color'); ?>
                    <div class="e-single-event col-md-<?php echo $column_number?> col-sm-6" style="
                    background-color:<?php echo $event_color[0]; ?>
                    ">
                        <a href="<?php the_permalink() ?>" class="edumodo-title e-event-title">
                            <h2><?php echo wp_trim_words(get_the_title(), $title_word, ''); ?></h2>
                        </a>

                        <?php if($show_thumbnail == 'yes'): ?>
                        <div class="featured-image e-featured-image">
                            <a href="<?php the_permalink() ?>">
                                <?php if(has_post_thumbnail()): ?>
                                    <?php the_post_thumbnail('full'); ?>
                                <?php endif; ?>
                            </a>
                        </div>
                        <?php endif; ?>

                        <div class="event-description e-event-description">
                            <?php echo wp_trim_words(get_the_excerpt(), $excerpt_word , ''); ?>
                        </div>

                        <a href="<?php the_permalink() ?>" class="link-to-main-post">
                            <span><?php esc_html_e('Read More', 'Edumodo'); ?></span>
                            <i class="fa fa-angle-double-right"></i>
                        </a>

                            <?php
                                $time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
                                $time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

                                $start_datetime = tribe_get_start_date();
                                $start_date = tribe_get_start_date( null, false );
                                $start_time = tribe_get_start_date( null, false, $time_format );
                                $start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

                                $end_datetime = tribe_get_end_date();
                                $end_date = tribe_get_display_end_date( null, false );
                                $end_time = tribe_get_end_date( null, false, $time_format );
                                $end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );
                    
                    if($start_date){ ?>
                        <p class="e-event-time">
                            <i class="fa fa-calendar"></i>
                            <span><?php echo $start_date; ?></span>
                        </p>
                    <?php }
                       
                     ?>
                    </div>
                </div>
             
                <?php
                endwhile; wp_reset_postdata();

              else: ?>
                <p> <?php _e( 'Sorry no post found. Please active & add event under The Event Calender Plugin' ); ?> </p>
           <?php  endif; 
	}
}
