<?php
        $settings = $this->get_settings();
        $event_id = $settings['event_id'];
        $excerpt_desc_word = $settings['excerpt_desc_word'];
        $excerpt_title_word = $settings['excerpt_title_word'];
        $args = array(
            'p' => $event_id,
            'post_type' => 'tribe_events',
        );
        $event_query = new WP_Query($args);

        ?>
        <div id="edumodo-event-wrapper-two" class="edumodo-event-wrapper-two">
            <?php if($event_query->have_posts() and class_exists( 'Tribe__Events__Main' ) ): ?>
                <?php while($event_query->have_posts()): ?>
                    <?php $event_query->the_post(); ?>

                        <div class="ed-event-row">
                          <div class="ed-event-column ed-event-left">
                           <div class="ed-event-date">

                                     <?php 

                                            $time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
                                            $time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

                                            $start_datetime = tribe_get_start_date();
                                            $start_date = tribe_get_start_date( null, false );
                                            $start_time = tribe_get_start_date( null, false, $time_format );
                                            $start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

                                            $end_datetime = tribe_get_end_date();
                                            $end_date = tribe_get_display_end_date( null, false );
                                            $end_time = tribe_get_end_date( null, false, $time_format );
                                            $end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );
                                    ?>
                                    <div class="events-date"> 

                                        <?php 
                                            $string = $start_date;
                                            $timestamp = strtotime($string);
                                         ?>
                                            <div class="date-total">
                                                 <div class="only-month-year">
                                                     <?php echo date("M", $timestamp); ?>
                                                     <?php //echo date("Y", $timestamp); ?>
                                                 </div>
                                                 <div class="only-day">
                                                     <?php echo date("d", $timestamp); ?>
                                                 </div>
                                            </div>

                                    </div>
                           </div>
                          </div>
                          <div class="ed-event-column ed-event-right">
                            <div class="ed-event-content">
                                    <a href="<?php the_permalink() ?>">
                                        <h3 class="ed-event-title">
                                            <?php echo wp_trim_words(get_the_title(), $excerpt_title_word, ''); ?>
                                        </h3>
                                    </a>
                                <div class="ed-event-excerpt">
                                    <?php echo wp_trim_words(get_the_excerpt(), $excerpt_desc_word, ''); ?>
                                </div>
                                    <div class="event-meta">
                                      <?php $ev_start_date = tribe_get_start_date( null, false, 'g:ia' );
                                            $ev_end_date = tribe_get_end_date( null, false, 'g:ia');
                                        if ($ev_start_date or $ev_end_date) : ?>
                                        <span class="event-time">
                                            <i class="fa fa-clock-o fa-fw"></i>
                                            <?php echo tribe_get_start_date( null, false, 'g:ia' ); ?>
                                            <?php esc_html_e('to', 'edumodo'); ?>
                                            <?php echo tribe_get_end_date( null, false, 'g:ia');  ?>
                                        </span>
                                      <?php endif; ?>

                                        <?php $location = tribe_get_city(get_the_ID()); 
                                        if ($location) : ?>
                                        <span class="event-city">
                                            <i class="fa fa-map-marker fa-fw"></i>
                                            <?php echo tribe_get_city(get_the_ID()); ?>
                                        </span>
                                       <?php endif; ?>
                                    </div>
                            </div>
                          </div>
                        </div>

                <?php endwhile; wp_reset_postdata();?>
            <?php  else: ?>
                 <p> <?php _e( 'Sorry no post found. Please active & add event under The Event Calender Plugin' ); ?> </p>
           <?php  endif; ?>

        </div>



