<?php

        $settings = $this->get_settings();
        $event_id = $settings['event_id'];
        $image_position = $settings['image_position'];
        /**
         * Event Query
         */
        $args = array(
            'p' => $event_id,
            'post_type' => 'tribe_events',
        );
        $event_query = new WP_Query($args);

        ?>
        <div class="class-widget-event">
            <?php if($event_query->have_posts() and class_exists( 'Tribe__Events__Main' ) ): ?>
                <?php while($event_query->have_posts()): ?>
                    <?php $event_query->the_post(); ?>
                    <div class="row event-wrapper <?php echo ($image_position == 'right') ? 'image-on-the-right-side': ''; ?>">

                        <?php if($image_position == 'left'): ?>
                            <div class="col-md-6 event-featured-image left-side-image">
                                <div class="featured-image ">

                                    <a href="<?php the_permalink() ?>">

                                     <?php 

                                            $time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
                                            $time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

                                            $start_datetime = tribe_get_start_date();
                                            $start_date = tribe_get_start_date( null, false );
                                            $start_time = tribe_get_start_date( null, false, $time_format );
                                            $start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

                                            $end_datetime = tribe_get_end_date();
                                            $end_date = tribe_get_display_end_date( null, false );
                                            $end_time = tribe_get_end_date( null, false, $time_format );
                                            $end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );
                                    ?>
                                        <?php 
                                            $string = $start_date;
                                            $timestamp = strtotime($string);
                                         ?>
                                    <div class="events-date"> 
                                            <div class="date-total">
                                                 <div class="only-day">
                                                     <?php echo date("d", $timestamp); ?>
                                                 </div>
                                                 <div class="only-month-year">
                                                     <?php echo date("M", $timestamp); ?>
                                                     <?php //echo date("Y", $timestamp); ?>
                                                 </div>
                                            </div>

                                    </div>
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php the_post_thumbnail('full'); ?>
                                        <?php endif; ?>
                                    </a>

                                </div>
                                <!-- end of /.featured-image -->
                            </div>
                            <!-- end of /.left-side-image -->
                        <?php endif; ?>

                        <div class="col-md-6 event-content">
                            <div class="event-content-wrapper">

                                <div class="event-title">
                                    <a href="<?php the_permalink() ?>" class="edumodo-title e-event-title">
                                        <h3 class="tgx-post-title">
                                            <?php echo wp_trim_words(get_the_title(), 10, ''); ?>
                                        </h3>
                                    </a>
                                    <p class="event-meta">
                                        <span class="event-city">
                                            <i class="fa fa-map-marker fa-fw"></i>
                                            <?php echo tribe_get_city(get_the_ID()); ?>
                                        </span>
                                        <span class="event-time">
                                            <i class="fa fa-clock-o fa-fw"></i>
                                            <?php echo tribe_get_start_date( null, false, 'g:ia' ); ?>
                                            <?php esc_html_e('to', 'edumodo'); ?>
                                            <?php echo tribe_get_end_date( null, false, 'g:ia');  ?>
                                        </span>
                                    </p>
                                </div>

                                <div class="event-excerpt">
                                    <?php echo wp_trim_words(get_the_excerpt(), 20 , ''); ?>
                                </div>

                            </div>
                            <!-- end of /.event-content-wrapper -->
                        </div>
                        <!-- end of /.event-content -->

                        <?php if($image_position == 'right'): ?>
                            <div class="col-md-6 event-featured-image right-side-image">
                                <div class="featured-image ">

                                    <a href="<?php the_permalink() ?>">
             
                                                <?php //echo tribe_get_start_date(null, false, 'd M Y'); ?>

                                    <div class="events-date"> 

                                     <?php 

                                            $time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
                                            $time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

                                            $start_datetime = tribe_get_start_date();
                                            $start_date = tribe_get_start_date( null, false );
                                            $start_time = tribe_get_start_date( null, false, $time_format );
                                            $start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

                                            $end_datetime = tribe_get_end_date();
                                            $end_date = tribe_get_display_end_date( null, false );
                                            $end_time = tribe_get_end_date( null, false, $time_format );
                                            $end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );
                                    ?>
                                        <?php 
                                            $string = $start_date;
                                            $timestamp = strtotime($string);
                                         ?>
                                            <div class="date-total">
                                                 <div class="only-day">
                                                     <?php echo date("d", $timestamp); ?>
                                                 </div>
                                                 <div class="only-month-year">
                                                     <?php echo date("M", $timestamp); ?>
                                                     <?php //echo date("Y", $timestamp); ?>
                                                 </div>
                                            </div>

                                    </div>
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php the_post_thumbnail('full'); ?>
                                        <?php endif; ?>
                                    </a>

                                </div>
                                <!-- end of /.featured-image -->
                            </div>
                            <!-- end of /.right-side-image -->
                        <?php endif; ?>

                    </div>
                <?php endwhile; wp_reset_postdata();?>
            <?php  else: ?>
                 <p> <?php _e( 'Sorry no post found. Please active your The Event Calender Plugin' ); ?> </p>
           <?php  endif; ?>

        </div>


