<?php
/**
 * Tag name == Event-1 (for Less file)
 */
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * tgx Schedule One
 *
 * Elementor widget for Schedule One.
 *
 * @since 1.0.0
 */
class Widget_Event_Two extends Widget_Base
{

    public function get_name()
    {
        return 'widget-event-two';
    }

    public function get_title()
    {
        return __('Event Two', 'edumodo');
    }

    public function get_icon()
    {
        return ' eicon-call-to-action';
    }

    public function get_categories()
    {
        return ['edumodo'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
    public function get_script_depends() {
    return [ 'imagesloaded' ];
    }
     */
    public function get_all_event_name_and_id()
    {
        $args = array(
            'post_type' => 'tribe_events',
        );
        $q = new WP_Query($args);
    }

    protected function _register_controls()
    {
        $args = array(
            'post_type'      => 'tribe_events',
            'posts_per_page' => -1,
        );
        $query       = new WP_Query($args);
        $event_names = array();
        foreach ($query->posts as $p):
            $event_names[$p->ID] = $p->post_title;
        endforeach;

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Event', 'edumodo'),
            ]
        );
        $this->add_control(
            'event_style',
            [
                'label'   => __('Style', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style_1',
                'options' => [
                    'style_1' => __('Style 1', 'edumodo'),
                    'style_2' => __('Style 2', 'edumodo'),
                ],
            ]
        );

        $this->add_control(
            'event_id',
            [
                'label'   => __('Event ID', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => '',
                'options' => $event_names,
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label'   => __('Image Posititon', 'edumodo'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'left',
                'options' => [
                    'left'  => __('Left', 'edumodo'),
                    'right' => __('Right', 'edumodo'),
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => __('Event Height', 'edumodo'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 800,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'selectors' => [
                    '{{WRAPPER}} #edumodo-event-wrapper-two .ed-event-column' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'event_style' => 'style_2',
                ]
            ]
        );
        $this->add_responsive_control(
            'margin',
            [
                'label'      => __('Content Padding', 'edumodo'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .class-widget-event .event-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} #edumodo-event-wrapper-two .ed-event-right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __('Title', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-title .tgx-post-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} #edumodo-event-wrapper-two .ed-event-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Hover Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-title .tgx-post-title:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} #edumodo-event-wrapper-two .ed-event-content a:hover .ed-event-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typo',
                'selector' => '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-title .tgx-post-title, #edumodo-event-wrapper-two .ed-event-title',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_meta',
            [
                'label' => __('Meta', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label'     => __('Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-meta' => 'color: {{VALUE}};',
                    '{{WRAPPER}} #edumodo-event-wrapper-two .ed-event-content .event-meta i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __('Content', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label'     => __('Content Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typo',
                'selector' => '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-content .event-excerpt',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_event_content',
            [
                'label' => __('Description', 'edumodo'),
            ]
        );

        $this->add_control(
            'excerpt_title_word',
            [
                'label'   => __('Excerpt Title', 'edumodo'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 80,
                'step'    => 1,
            ]
        );

        $this->add_control(
            'excerpt_desc_word',
            [
                'label'   => __('Excerpt Description', 'edumodo'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 15,
                'min'     => 1,
                'max'     => 150,
                'step'    => 1,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_date',
            [
                'label' => __('Date', 'edumodo'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label'     => __('Color', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .event-time span'              => 'color: {{VALUE}};',
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .events-date .only-day'        => 'color: {{VALUE}};',
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .events-date .only-month-year' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'date_bg_color',
            [
                'label'     => __('Background', 'edumodo'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .event-time span' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .events-date'     => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'date_typography',
                'label'    => __('Date', 'edumodo'),
                'selector' => '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .event-time span',
                'selector' => '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .events-date .only-day',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'month_year_typography',
                'label'    => __('Month Year', 'edumodo'),
                'selector' => '{{WRAPPER}} .class-widget-event .row.event-wrapper .event-featured-image .only-month-year',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings();
        if ($settings['event_style'] == 'style_1'):
            require EDUMODO_CORE_ROOT . '/elements/event-two/template/style1.php';
        elseif ($settings['event_style'] == 'style_2'):
            require EDUMODO_CORE_ROOT . '/elements/event-two/template/style2.php';
        endif;
    }

    protected function _content_template()
    {

    }
}
