<?php
/**
 * Dynamic category
 * =================
 */
add_action( 'wp_ajax_nopriv_dynamicCat', 'dynamic_cat' );
add_action( 'wp_ajax_dynamicCat', 'dynamic_cat' );
if(! function_exists('dynamic_cat')){
    function dynamic_cat(){
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];
        $coursePrice = $_REQUEST['coursePrice'];
        $courseCategory = $_REQUEST['courseCategory'];
        $showRating = $_REQUEST['showRating'];
        $averageRating = $_REQUEST['averageRating'];
        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'lp_course',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'course_category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-coursePrice="<?php echo $coursePrice; ?>"
            data-courseCategory="<?php echo $courseCategory; ?>"
            data-showRating="<?php echo $showRating; ?>"
            data-averageRating="<?php echo $averageRating; ?>"
            data-postsColumn="<?php echo $postsColumn; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            class="cat-post-list dynamic-cat-post-list animated fadeIn">
            <div id="lp-dynamic-course-carousel" class="<?php echo $activeCarousel ? 'lp-dynamic-course-active owl-carousel' : ''; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();
                        ?>
 
                        <div class="<?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                            <article  class="dynamic-category-course">
                                <?php if ( has_post_thumbnail() ):?>
                                    <figure class="post-thumbnail">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php  the_post_thumbnail($regularThumbSize);?>
                                        </a>
                                    </figure>
                                <?php endif; ?>

                                <div class="course-details">
                                    <header class="entry-header">
                                        <h4 class="course-entry-title">
                                            <a class="course-title-link" href="<?php the_permalink();?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h4>
                                    </header>

                                    <div class="course-meta addons-course-meta">

                                        <?php
                                        /**
                                         * category
                                         */
                                        if($courseCategory == 'yes'): ?>
                                            <span class="post-date">
                                              <?php learn_press_course_categories(); ?>
                                            </span>
                                        <?php endif; ?>


                                        <?php
                                        /**
                                         * price
                                         */
                                        if($coursePrice == 'yes'): ?>
                                            <?php $course = LP_Global::course();?>
                                            <?php if ( $price_html = $course->get_price_html() ) { ?>
                                                <?php if ( $course->get_origin_price() != $course->get_price() ) { ?>
                                                    <?php $origin_price_html = $course->get_origin_price_html(); ?>
                                                    <span class="addon-origin-price"><?php echo $origin_price_html; ?></span>
                                                <?php } ?>
                                                <span class="addon-price"><?php echo $price_html; ?></span>
                                            <?php }
                                        endif; ?>


           
                                    </div>

                                        <?php
                                            $course_id       = get_the_ID();
                                            $course_rate_res = learn_press_get_course_rate( $course_id, false );
                                            $course_rate     = $course_rate_res['rated'];
                                            $total           = $course_rate_res['total'];
                                        ?>

                                     <?php if($showRating == 'yes' or $averageRating == 'yes'):  ?>
                                        <div class="edumodo-course-rate-wapper">
                                            <ul class="edumodo-course-rate clearfix">
                                                <li>
                                                <?php if($showRating == 'yes'):  ?>
                                                    <?php echo '<div class="star-rating" title="'.sprintf(__( 'Rated %s out of 5', 'edumodo' ), $course_rate).'"><span style="width:'.( ( $course_rate / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$course_rate.'</strong> '.__( 'out of 5', 'edumodo' ).'</span></div>'; ?>
                                                <?php endif; ?>
                                                <?php if($averageRating == 'yes'):  ?>
                                                        <?php printf( __( ' %1.2f (', 'edumodo'), $course_rate ); ?>
                                                        <?php printf( _n( ' %d )', '%d )', $total, 'edumodo' ), $total ); ?>
                                                <?php endif; ?>
                                                </li>
                                            </ul> 
                                        </div>
                                    <?php endif; ?>
                                </div>


                            </article>
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}
