<?php

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widgets\Elementor;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * Elementor video popup
 *
 * Elementor widget for  video popup
 *
 * @since 1.0.0
 */
class Edumodo_Countdown_Widget extends Widget_Base
{

    public function get_name()
    {
        return 'edumodo-countdown';
    }

    public function get_title()
    {
        return __('countdown', 'edumodo');
    }

    public function get_icon()
    {
        return 'eicon-countdown';
    }

    public function get_categories()
    {
        return ['edumodo'];
    }
    public function get_keywords() {
        return [ 'countdown', 'edumodo countdown', 'coundown', 'timer', 'count' ];
    }
    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/
    public function get_script_depends()
    {
        return [];
    }

    protected function _register_controls()
    {

  
    $this->start_controls_section(
            'ctw_section',
            [
                'label' => __( 'Countdown', 'edumodo' ),
            ]
        );
        $this->add_control(
            'ctw_due_date',
            [
                'label' => __( 'Due Date', 'edumodo' ),
                'type' => Controls_Manager::DATE_TIME,
                'default' => date( 'Y-m-d H:i', strtotime( '+1 month' ) + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ),
                'description' => sprintf( __( 'Date set according to your timezone: %s.', 'edumodo' ), Utils::get_timezone_string() ),
                
            ]
        );
        $this->add_control(
            'ctw_show_days',
            [
                'label' => __( 'Days', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'ctw_show_hours',
            [
                'label' => __( 'Hours', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'ctw_show_minutes',
            [
                'label' => __( 'Minutes', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'ctw_show_seconds',
            [
                'label' => __( 'Seconds', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'edumodo' ),
                'label_off' => __( 'Hide', 'edumodo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section(); 
        
        $this->start_controls_section(
            'ctw_expire_section',
            [
                'label' => __( 'Countdown Expire' , 'edumodo' )
            ]
        );
        $this->add_control(
            'ctw_expire_show_type',
            [
                'label'         => __('Expire Type', 'edumodo'),
                'label_block'   => false,
                'type'          => Controls_Manager::SELECT,
                'description'   => __('Select whether you want to set a message or a redirect link after expire countdown', 'edumodo'),
                'options'       => [
                    'message'       => __('Message', 'edumodo'),
                    'redirect_link'     => __('Redirect to Link', 'edumodo')
                ],
                'default' => 'message'
            ]
        );
        $this->add_control(
            'ctw_expire_message',
            [
                'label'         => __('Expire Message', 'edumodo'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Sorry you are late!','edumodo'),
                'condition'     => [
                    'ctw_expire_show_type' => 'message'
                ]
            ]
        );
        $this->add_control(
            'ctw_expire_redirect_link',
            [
                'label'         => __('Redirect On', 'edumodo'),
                'type'          => Controls_Manager::URL,
                'condition'     => [
                    'ctw_expire_show_type' => 'redirect_link'
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'ctw_label_text_section',
            [
                'label' => __( 'Change Labels Text' , 'edumodo' )
            ]
        );
        $this->add_control(
            'ctw_change_labels',
            [
                'label' => __( 'Change Labels', 'edumodo' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'edumodo' ),
                'label_off' => __( 'No', 'edumodo' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'ctw_label_days',
            [
                'label' => __( 'Days', 'edumodo' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Days', 'edumodo' ),
                'placeholder' => __( 'Days', 'edumodo' ),
                'condition' => [
                    'ctw_change_labels' => 'yes',
                    'ctw_show_days' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'ctw_label_hours',
            [
                'label' => __( 'Hours', 'edumodo' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Hours', 'edumodo' ),
                'placeholder' => __( 'Hours', 'edumodo' ),
                'condition' => [
                    'ctw_change_labels' => 'yes',
                    'ctw_show_hours' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'ctw_label_minuts',
            [
                'label' => __( 'Minutes', 'edumodo' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Minutes', 'edumodo' ),
                'placeholder' => __( 'Minutes', 'edumodo' ),
                'condition' => [
                    'ctw_change_labels' => 'yes',
                    'ctw_show_minutes' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'ctw_label_seconds',
            [
                'label' => __( 'Seconds', 'edumodo' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Seconds', 'edumodo' ),
                'placeholder' => __( 'Seconds', 'edumodo' ),
                'condition' => [
                    'ctw_change_labels' => 'yes',
                    'ctw_show_seconds' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(   
            'ctw_style_section',
            [
                'label' => __( 'Box', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'ctw_box_align',
                [
                    'label'         => esc_html__( 'Alignment', 'edumodo' ),
                    'type'          => Controls_Manager::CHOOSE,
                    'options'       => [
                        'left'      => [
                            'title'=> esc_html__( 'Left', 'edumodo' ),
                            'icon' => 'fa fa-align-left',
                            ],
                        'center'    => [
                            'title'=> esc_html__( 'Center', 'edumodo' ),
                            'icon' => 'fa fa-align-center',
                            ],
                        'right'     => [
                            'title'=> esc_html__( 'Right', 'edumodo' ),
                            'icon' => 'fa fa-align-right',
                            ],
                        ],
                    'toggle'        => false,
                    'default'       => 'center',
                    'selectors'     => [
                        '{{WRAPPER}} .edumodo-countdown-timer-widget' => 'text-align: {{VALUE}};',
                        ],
                ]
        );
        $this->add_control(
            'ctw_box_background_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .countdown-items' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'after',
            ]
        );
        $this->add_responsive_control(
            'ctw_box_size',
            [
                'label' => __( 'Size', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .edumodo-countdown-timer-widget .countdown-items' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'ctw_box_spacing',
            [
                'label' => __( 'Box Gap', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 10,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .countdown-items:not(:first-of-type)' => 'margin-left: calc( {{SIZE}}{{UNIT}}/2 );',
                    'body:not(.rtl) {{WRAPPER}} .countdown-items:not(:last-of-type)' => 'margin-right: calc( {{SIZE}}{{UNIT}}/2 );',
                    'body.rtl {{WRAPPER}} .countdown-items:not(:first-of-type)' => 'margin-right: calc( {{SIZE}}{{UNIT}}/2 );',
                    'body.rtl {{WRAPPER}} .countdown-items:not(:last-of-type)' => 'margin-left: calc( {{SIZE}}{{UNIT}}/2 );',
                ],
            ]
        );        

        $this->add_responsive_control(
            'ctw_digit_spacing',
            [
                'label' => __( 'Digit Gap', 'edumodo' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 200,
                ],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .countdown-items .ctw-digits' => 'height: calc( {{SIZE}}{{UNIT}}/2 );',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .countdown-items',
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'ctw_box_border_radius',
            [
                'label' => __( 'Border Radius', 'edumodo' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .countdown-items' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'ctw_digits_style_section',
            [
                'label' => __( 'Digits', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'ctw_digit_background_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .countdown-items .ctw-digits' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'ctw_digits_color',
            [
                'label' => __( 'Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ctw-digits' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ctw_digits_typography',
                'selector' => '{{WRAPPER}} .ctw-digits',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();   
        
        $this->start_controls_section(
            'ctw_labels_style_section',
            [
                'label' => __( 'Labels', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'ctw_label_background_color',
            [
                'label' => __( 'Background Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .ctw-label' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'ctw_label_color',
            [
                'label' => __( 'Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ctw-label' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ctw_label_typography',
                'selector' => '{{WRAPPER}} .ctw-label',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section();   
        
        $this->start_controls_section(
            'ctw_finish_message_style_section',
            [
                'label' => __( 'Message', 'edumodo' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'ctw_message_color',
            [
                'label' => __( 'Color', 'edumodo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .finished-message' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ctw_message_typography',
                'selector' => '{{WRAPPER}} .finished-message',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->end_controls_section(); 


    }

    protected function render() {
        $settings = $this->get_settings();
        
        $day = $settings['ctw_show_days'];
        $hours = $settings['ctw_show_hours'];
        $minute = $settings['ctw_show_minutes'];
        $seconds = $settings['ctw_show_seconds'];
        ?>
        <div class="edumodo-countdown-timer-widget">
            <div id="countdown-timer-<?php echo esc_attr($this->get_id()); ?>" class="countdown-timer-init"></div>
            <div id="finished-message-<?php echo esc_attr($this->get_id()); ?>" class="finished-message"></div>
        </div>
        <script>
            jQuery(function(){
                jQuery('#countdown-timer-<?php echo esc_attr($this->get_id()); ?>').countdowntimer({
                    dateAndTime : "<?php echo $settings['ctw_due_date'];  ?>",
                    regexpMatchFormat: "([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})",
                    regexpReplaceWith: "<?php if ($day == "yes"){?><div class='countdown-items'><span class='ctw-digits'>$1</span><span class='ctw-label'><?php echo $settings['ctw_label_days']; ?></span> </div><?php } ?><?php if ($hours == "yes"){?> <div class='countdown-items'><span class='ctw-digits'>$2 </span><span class='ctw-label'><?php echo $settings['ctw_label_hours']; ?></span></div><?php } ?><?php if ($minute == "yes"){?><div class='countdown-items'> <span class='ctw-digits'> $3 </span><span class='ctw-label'><?php echo $settings['ctw_label_minuts']; ?></span> </div><?php } ?><?php if ($seconds == "yes"){?><div class='countdown-items'><span class='ctw-digits'> $4</span><span class='ctw-label'><?php echo $settings['ctw_label_seconds']; ?></span></div><?php } ?>",
                    <?php if( $settings['ctw_expire_show_type'] == "redirect_link"){ ?>
                    expiryUrl:link_url,
                    <?php } else { ?>
                    timeUp : timeisUp,
                    <?php } ?>
                });
                <?php if( $settings['ctw_expire_show_type'] == "redirect_link"){ ?>
                    var ele_backend = jQuery('body').find('#elementor').length;
                    if( ele_backend > 0 ) {
                        jQuery(this).find('.countdown-timer-init').html( '<h1>You can not redirect url from elementor Editor!!</h1>' );
                    } else {
                        var link_url = '<?php echo $settings['ctw_expire_redirect_link']['url'] ?>';
                    }
                <?php } else { ?>
                    function timeisUp(){
                        jQuery("#finished-message-<?php echo esc_attr($this->get_id()); ?>").html( "<span><?php echo $settings['ctw_expire_message'];?></span>" );
                    }
                <?php } ?>                  
            });
        
        </script>
        <?php
    }
    protected function _content_template() { 
         
    } 



}
