<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Change default size for single image shortcode
add_action('init', 'vc_update_defaults', 100);
function vc_update_defaults() {
	if ( class_exists( 'WPBMap' ) )  {
		// Set full size for single image by default
		$param = WPBMap::getParam( 'vc_single_image', 'img_size' );
		$param['value'] = 'full';
		vc_update_shortcode_param( 'vc_single_image', $param );
	}
}

// Add moreparams
add_action('init', 'vc_add_new_para', 100);
	function vc_add_new_para() {
	if ( function_exists( 'add_shortcode_param' ) ) {
		if ( defined( 'WPB_VC_VERSION' ) && version_compare( '5.0', WPB_VC_VERSION, '>=' ) ) {
			add_shortcode_param( 'number' , 'edukul_param_number' );
			add_shortcode_param( 'headings' , 'edukul_param_heading' );
		}
	}
	if ( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'number' , 'edukul_param_number' );
		vc_add_shortcode_param( 'headings' , 'edukul_param_heading' );
	}

	// Add Number param
	function edukul_param_number( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$type = isset($settings['type']) ? $settings['type'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$output = '<input type="number" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'. $value.'" style="max-width:100px; margin-right: 10px;" />'. $suffix;
		return $output;
	}

	// Add Heading param
	function edukul_param_heading( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$text = isset($settings['text']) ? $settings['text'] : '';
		$output = '<h4 '. $dependency .' class="wpb_vc_param_value '. $class .'" style="margin: 10px 0 0;padding:10px;font-size:14px; background:#ebebeb;color:#666;">'. $text .'</h4>';
		$output .= '<input type="hidden" name="'. $settings['param_name'].'" class="wpb_vc_param_value '. $settings['param_name'] .' '. $settings['type'] .'_field" value="'. $value.'" '. $dependency.'/>';
		return $output;
	}
}

// Register CSS Icons Styles
add_action( 'vc_base_register_front_css', 'leadinjection_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'leadinjection_vc_iconpicker_base_register_css' );
function leadinjection_vc_iconpicker_base_register_css(){
    wp_enqueue_style('extraicon', plugin_dir_url( __FILE__ ) . 'assets/edukul-icons.css');
}

// Define the Icons for VC Iconpicker
add_filter( 'vc_iconpicker-type-extraicon', 'vc_iconpicker_type_extraicon' );
function vc_iconpicker_type_extraicon() {
    return array(
		array("eduk-abacus" => "abacus"),
		array("eduk-acorn" => "acorn"),
		array("eduk-ad" => "ad"),
		array("eduk-address-book" => "address-book"),
		array("eduk-address-card" => "address-card"),
		array("eduk-adjust" => "adjust"),
		array("eduk-air-freshener" => "air-freshener"),
		array("eduk-alarm-clock" => "alarm-clock"),
		array("eduk-alarm-exclamation" => "alarm-exclamation"),
		array("eduk-alarm-plus" => "alarm-plus"),
		array("eduk-alarm-snooze" => "alarm-snooze"),
		array("eduk-alicorn" => "alicorn"),
		array("eduk-align-center" => "align-center"),
		array("eduk-align-justify" => "align-justify"),
		array("eduk-align-left" => "align-left"),
		array("eduk-align-right" => "align-right"),
		array("eduk-align-slash" => "align-slash"),
		array("eduk-allergies" => "allergies"),
		array("eduk-ambulance" => "ambulance"),
		array("eduk-american-sign-language-interpreting" => "american-sign-language-interpreting"),
		array("eduk-analytics" => "analytics"),
		array("eduk-anchor" => "anchor"),
		array("eduk-angel" => "angel"),
		array("eduk-angle-double-down" => "angle-double-down"),
		array("eduk-angle-double-left" => "angle-double-left"),
		array("eduk-angle-double-right" => "angle-double-right"),
		array("eduk-angle-double-up" => "angle-double-up"),
		array("eduk-angle-down" => "angle-down"),
		array("eduk-angle-left" => "angle-left"),
		array("eduk-angle-right" => "angle-right"),
		array("eduk-angle-up" => "angle-up"),
		array("eduk-angry" => "angry"),
		array("eduk-ankh" => "ankh"),
		array("eduk-apple-alt" => "apple-alt"),
		array("eduk-apple-crate" => "apple-crate"),
		array("eduk-archive" => "archive"),
		array("eduk-archway" => "archway"),
		array("eduk-arrow-alt-circle-down" => "arrow-alt-circle-down"),
		array("eduk-arrow-alt-circle-left" => "arrow-alt-circle-left"),
		array("eduk-arrow-alt-circle-right" => "arrow-alt-circle-right"),
		array("eduk-arrow-alt-circle-up" => "arrow-alt-circle-up"),
		array("eduk-arrow-alt-down" => "arrow-alt-down"),
		array("eduk-arrow-alt-from-bottom" => "arrow-alt-from-bottom"),
		array("eduk-arrow-alt-from-left" => "arrow-alt-from-left"),
		array("eduk-arrow-alt-from-right" => "arrow-alt-from-right"),
		array("eduk-arrow-alt-from-top" => "arrow-alt-from-top"),
		array("eduk-arrow-alt-left" => "arrow-alt-left"),
		array("eduk-arrow-alt-right" => "arrow-alt-right"),
		array("eduk-arrow-alt-square-down" => "arrow-alt-square-down"),
		array("eduk-arrow-alt-square-left" => "arrow-alt-square-left"),
		array("eduk-arrow-alt-square-right" => "arrow-alt-square-right"),
		array("eduk-arrow-alt-square-up" => "arrow-alt-square-up"),
		array("eduk-arrow-alt-to-bottom" => "arrow-alt-to-bottom"),
		array("eduk-arrow-alt-to-left" => "arrow-alt-to-left"),
		array("eduk-arrow-alt-to-right" => "arrow-alt-to-right"),
		array("eduk-arrow-alt-to-top" => "arrow-alt-to-top"),
		array("eduk-arrow-alt-up" => "arrow-alt-up"),
		array("eduk-arrow-circle-down" => "arrow-circle-down"),
		array("eduk-arrow-circle-left" => "arrow-circle-left"),
		array("eduk-arrow-circle-right" => "arrow-circle-right"),
		array("eduk-arrow-circle-up" => "arrow-circle-up"),
		array("eduk-arrow-down" => "arrow-down"),
		array("eduk-arrow-from-bottom" => "arrow-from-bottom"),
		array("eduk-arrow-from-left" => "arrow-from-left"),
		array("eduk-arrow-from-right" => "arrow-from-right"),
		array("eduk-arrow-from-top" => "arrow-from-top"),
		array("eduk-arrow-left" => "arrow-left"),
		array("eduk-arrow-right" => "arrow-right"),
		array("eduk-arrows" => "arrows"),
		array("eduk-arrows-alt" => "arrows-alt"),
		array("eduk-arrows-alt-h" => "arrows-alt-h"),
		array("eduk-arrows-alt-v" => "arrows-alt-v"),
		array("eduk-arrows-h" => "arrows-h"),
		array("eduk-arrow-square-down" => "arrow-square-down"),
		array("eduk-arrow-square-left" => "arrow-square-left"),
		array("eduk-arrow-square-right" => "arrow-square-right"),
		array("eduk-arrow-square-up" => "arrow-square-up"),
		array("eduk-arrows-v" => "arrows-v"),
		array("eduk-arrow-to-bottom" => "arrow-to-bottom"),
		array("eduk-arrow-to-left" => "arrow-to-left"),
		array("eduk-arrow-to-right" => "arrow-to-right"),
		array("eduk-arrow-to-top" => "arrow-to-top"),
		array("eduk-arrow-up" => "arrow-up"),
		array("eduk-assistive-listening-systems" => "assistive-listening-systems"),
		array("eduk-asterisk" => "asterisk"),
		array("eduk-at" => "at"),
		array("eduk-atlas" => "atlas"),
		array("eduk-atom" => "atom"),
		array("eduk-atom-alt" => "atom-alt"),
		array("eduk-audio-description" => "audio-description"),
		array("eduk-award" => "award"),
		array("eduk-axe" => "axe"),
		array("eduk-axe-battle" => "axe-battle"),
		array("eduk-baby" => "baby"),
		array("eduk-baby-carriage" => "baby-carriage"),
		array("eduk-backpack" => "backpack"),
		array("eduk-backspace" => "backspace"),
		array("eduk-backward" => "backward"),
		array("eduk-bacon" => "bacon"),
		array("eduk-badge" => "badge"),
		array("eduk-badge-check" => "badge-check"),
		array("eduk-badge-dollar" => "badge-dollar"),
		array("eduk-badge-percent" => "badge-percent"),
		array("eduk-badger-honey" => "badger-honey"),
		array("eduk-bags-shopping" => "bags-shopping"),
		array("eduk-balance-scale" => "balance-scale"),
		array("eduk-balance-scale-left" => "balance-scale-left"),
		array("eduk-balance-scale-right" => "balance-scale-right"),
		array("eduk-ballot" => "ballot"),
		array("eduk-ballot-check" => "ballot-check"),
		array("eduk-ball-pile" => "ball-pile"),
		array("eduk-ban" => "ban"),
		array("eduk-band-aid" => "band-aid"),
		array("eduk-barcode" => "barcode"),
		array("eduk-barcode-alt" => "barcode-alt"),
		array("eduk-barcode-read" => "barcode-read"),
		array("eduk-barcode-scan" => "barcode-scan"),
		array("eduk-bars" => "bars"),
		array("eduk-baseball" => "baseball"),
		array("eduk-baseball-ball" => "baseball-ball"),
		array("eduk-basketball-ball" => "basketball-ball"),
		array("eduk-basketball-hoop" => "basketball-hoop"),
		array("eduk-bat" => "bat"),
		array("eduk-bath" => "bath"),
		array("eduk-battery-bolt" => "battery-bolt"),
		array("eduk-battery-empty" => "battery-empty"),
		array("eduk-battery-full" => "battery-full"),
		array("eduk-battery-half" => "battery-half"),
		array("eduk-battery-quarter" => "battery-quarter"),
		array("eduk-battery-slash" => "battery-slash"),
		array("eduk-battery-three-quarters" => "battery-three-quarters"),
		array("eduk-bed" => "bed"),
		array("eduk-beer" => "beer"),
		array("eduk-bell" => "bell"),
		array("eduk-bell-exclamation" => "bell-exclamation"),
		array("eduk-bell-plus" => "bell-plus"),
		array("eduk-bells" => "bells"),
		array("eduk-bell-school" => "bell-school"),
		array("eduk-bell-school-slash" => "bell-school-slash"),
		array("eduk-bell-slash" => "bell-slash"),
		array("eduk-bezier-curve" => "bezier-curve"),
		array("eduk-bible" => "bible"),
		array("eduk-bicycle" => "bicycle"),
		array("eduk-biking" => "biking"),
		array("eduk-biking-mountain" => "biking-mountain"),
		array("eduk-binoculars" => "binoculars"),
		array("eduk-biohazard" => "biohazard"),
		array("eduk-birthday-cake" => "birthday-cake"),
		array("eduk-blanket" => "blanket"),
		array("eduk-blender" => "blender"),
		array("eduk-blender-phone" => "blender-phone"),
		array("eduk-blind" => "blind"),
		array("eduk-blog" => "blog"),
		array("eduk-bold" => "bold"),
		array("eduk-bolt" => "bolt"),
		array("eduk-bomb" => "bomb"),
		array("eduk-bone" => "bone"),
		array("eduk-bone-break" => "bone-break"),
		array("eduk-bong" => "bong"),
		array("eduk-book" => "book"),
		array("eduk-book-alt" => "book-alt"),
		array("eduk-book-dead" => "book-dead"),
		array("eduk-book-heart" => "book-heart"),
		array("eduk-bookmark" => "bookmark"),
		array("eduk-book-medical" => "book-medical"),
		array("eduk-book-open" => "book-open"),
		array("eduk-book-reader" => "book-reader"),
		array("eduk-books" => "books"),
		array("eduk-books-medical" => "books-medical"),
		array("eduk-book-spells" => "book-spells"),
		array("eduk-book-user" => "book-user"),
		array("eduk-boot" => "boot"),
		array("eduk-booth-curtain" => "booth-curtain"),
		array("eduk-border-all" => "border-all"),
		array("eduk-border-bottom" => "border-bottom"),
		array("eduk-border-inner" => "border-inner"),
		array("eduk-border-left" => "border-left"),
		array("eduk-border-none" => "border-none"),
		array("eduk-border-outer" => "border-outer"),
		array("eduk-border-right" => "border-right"),
		array("eduk-border-style" => "border-style"),
		array("eduk-border-style-alt" => "border-style-alt"),
		array("eduk-border-top" => "border-top"),
		array("eduk-bow-arrow" => "bow-arrow"),
		array("eduk-bowling-ball" => "bowling-ball"),
		array("eduk-bowling-pins" => "bowling-pins"),
		array("eduk-box" => "box"),
		array("eduk-box-alt" => "box-alt"),
		array("eduk-box-ballot" => "box-ballot"),
		array("eduk-box-check" => "box-check"),
		array("eduk-boxes" => "boxes"),
		array("eduk-boxes-alt" => "boxes-alt"),
		array("eduk-box-fragile" => "box-fragile"),
		array("eduk-box-full" => "box-full"),
		array("eduk-box-heart" => "box-heart"),
		array("eduk-boxing-glove" => "boxing-glove"),
		array("eduk-box-open" => "box-open"),
		array("eduk-box-up" => "box-up"),
		array("eduk-box-usd" => "box-usd"),
		array("eduk-brackets" => "brackets"),
		array("eduk-brackets-curly" => "brackets-curly"),
		array("eduk-braille" => "braille"),
		array("eduk-brain" => "brain"),
		array("eduk-bread-loaf" => "bread-loaf"),
		array("eduk-bread-slice" => "bread-slice"),
		array("eduk-briefcase" => "briefcase"),
		array("eduk-briefcase-medical" => "briefcase-medical"),
		array("eduk-bring-forward" => "bring-forward"),
		array("eduk-bring-front" => "bring-front"),
		array("eduk-broadcast-tower" => "broadcast-tower"),
		array("eduk-broom" => "broom"),
		array("eduk-browser" => "browser"),
		array("eduk-brush" => "brush"),
		array("eduk-bug" => "bug"),
		array("eduk-building" => "building"),
		array("eduk-bullhorn" => "bullhorn"),
		array("eduk-bullseye" => "bullseye"),
		array("eduk-bullseye-arrow" => "bullseye-arrow"),
		array("eduk-bullseye-pointer" => "bullseye-pointer"),
		array("eduk-burger-soda" => "burger-soda"),
		array("eduk-burn" => "burn"),
		array("eduk-burrito" => "burrito"),
		array("eduk-bus" => "bus"),
		array("eduk-bus-alt" => "bus-alt"),
		array("eduk-business-time" => "business-time"),
		array("eduk-bus-school" => "bus-school"),
		array("eduk-cabinet-filing" => "cabinet-filing"),
		array("eduk-calculator" => "calculator"),
		array("eduk-calculator-alt" => "calculator-alt"),
		array("eduk-calendar" => "calendar"),
		array("eduk-calendar-alt" => "calendar-alt"),
		array("eduk-calendar-check" => "calendar-check"),
		array("eduk-calendar-day" => "calendar-day"),
		array("eduk-calendar-edit" => "calendar-edit"),
		array("eduk-calendar-exclamation" => "calendar-exclamation"),
		array("eduk-calendar-minus" => "calendar-minus"),
		array("eduk-calendar-plus" => "calendar-plus"),
		array("eduk-calendar-star" => "calendar-star"),
		array("eduk-calendar-times" => "calendar-times"),
		array("eduk-calendar-week" => "calendar-week"),
		array("eduk-camera" => "camera"),
		array("eduk-camera-alt" => "camera-alt"),
		array("eduk-camera-retro" => "camera-retro"),
		array("eduk-campfire" => "campfire"),
		array("eduk-campground" => "campground"),
		array("eduk-candle-holder" => "candle-holder"),
		array("eduk-candy-cane" => "candy-cane"),
		array("eduk-candy-corn" => "candy-corn"),
		array("eduk-cannabis" => "cannabis"),
		array("eduk-capsules" => "capsules"),
		array("eduk-car" => "car"),
		array("eduk-car-alt" => "car-alt"),
		array("eduk-car-battery" => "car-battery"),
		array("eduk-car-building" => "car-building"),
		array("eduk-car-bump" => "car-bump"),
		array("eduk-car-bus" => "car-bus"),
		array("eduk-car-crash" => "car-crash"),
		array("eduk-caret-circle-down" => "caret-circle-down"),
		array("eduk-caret-circle-left" => "caret-circle-left"),
		array("eduk-caret-circle-right" => "caret-circle-right"),
		array("eduk-caret-circle-up" => "caret-circle-up"),
		array("eduk-caret-down" => "caret-down"),
		array("eduk-caret-left" => "caret-left"),
		array("eduk-caret-right" => "caret-right"),
		array("eduk-caret-square-down" => "caret-square-down"),
		array("eduk-caret-square-left" => "caret-square-left"),
		array("eduk-caret-square-right" => "caret-square-right"),
		array("eduk-caret-square-up" => "caret-square-up"),
		array("eduk-caret-up" => "caret-up"),
		array("eduk-car-garage" => "car-garage"),
		array("eduk-car-mechanic" => "car-mechanic"),
		array("eduk-carrot" => "carrot"),
		array("eduk-cars" => "cars"),
		array("eduk-car-side" => "car-side"),
		array("eduk-cart-arrow-down" => "cart-arrow-down"),
		array("eduk-car-tilt" => "car-tilt"),
		array("eduk-cart-plus" => "cart-plus"),
		array("eduk-car-wash" => "car-wash"),
		array("eduk-cash-register" => "cash-register"),
		array("eduk-cat" => "cat"),
		array("eduk-cauldron" => "cauldron"),
		array("eduk-certificate" => "certificate"),
		array("eduk-chair" => "chair"),
		array("eduk-chair-office" => "chair-office"),
		array("eduk-chalkboard" => "chalkboard"),
		array("eduk-chalkboard-teacher" => "chalkboard-teacher"),
		array("eduk-charging-station" => "charging-station"),
		array("eduk-chart-area" => "chart-area"),
		array("eduk-chart-bar" => "chart-bar"),
		array("eduk-chart-line" => "chart-line"),
		array("eduk-chart-line-down" => "chart-line-down"),
		array("eduk-chart-network" => "chart-network"),
		array("eduk-chart-pie" => "chart-pie"),
		array("eduk-chart-pie-alt" => "chart-pie-alt"),
		array("eduk-chart-scatter" => "chart-scatter"),
		array("eduk-check" => "check"),
		array("eduk-check-circle" => "check-circle"),
		array("eduk-check-double" => "check-double"),
		array("eduk-check-square" => "check-square"),
		array("eduk-cheese" => "cheese"),
		array("eduk-cheeseburger" => "cheeseburger"),
		array("eduk-cheese-swiss" => "cheese-swiss"),
		array("eduk-chess" => "chess"),
		array("eduk-chess-bishop" => "chess-bishop"),
		array("eduk-chess-bishop-alt" => "chess-bishop-alt"),
		array("eduk-chess-board" => "chess-board"),
		array("eduk-chess-clock" => "chess-clock"),
		array("eduk-chess-clock-alt" => "chess-clock-alt"),
		array("eduk-chess-king" => "chess-king"),
		array("eduk-chess-king-alt" => "chess-king-alt"),
		array("eduk-chess-knight" => "chess-knight"),
		array("eduk-chess-knight-alt" => "chess-knight-alt"),
		array("eduk-chess-pawn" => "chess-pawn"),
		array("eduk-chess-pawn-alt" => "chess-pawn-alt"),
		array("eduk-chess-queen" => "chess-queen"),
		array("eduk-chess-queen-alt" => "chess-queen-alt"),
		array("eduk-chess-rook" => "chess-rook"),
		array("eduk-chess-rook-alt" => "chess-rook-alt"),
		array("eduk-chevron-circle-down" => "chevron-circle-down"),
		array("eduk-chevron-circle-left" => "chevron-circle-left"),
		array("eduk-chevron-circle-right" => "chevron-circle-right"),
		array("eduk-chevron-circle-up" => "chevron-circle-up"),
		array("eduk-chevron-double-down" => "chevron-double-down"),
		array("eduk-chevron-double-left" => "chevron-double-left"),
		array("eduk-chevron-double-right" => "chevron-double-right"),
		array("eduk-chevron-double-up" => "chevron-double-up"),
		array("eduk-chevron-down" => "chevron-down"),
		array("eduk-chevron-left" => "chevron-left"),
		array("eduk-chevron-right" => "chevron-right"),
		array("eduk-chevron-square-down" => "chevron-square-down"),
		array("eduk-chevron-square-left" => "chevron-square-left"),
		array("eduk-chevron-square-right" => "chevron-square-right"),
		array("eduk-chevron-square-up" => "chevron-square-up"),
		array("eduk-chevron-up" => "chevron-up"),
		array("eduk-child" => "child"),
		array("eduk-chimney" => "chimney"),
		array("eduk-church" => "church"),
		array("eduk-circle" => "circle"),
		array("eduk-circle-notch" => "circle-notch"),
		array("eduk-city" => "city"),
		array("eduk-claw-marks" => "claw-marks"),
		array("eduk-clinic-medical" => "clinic-medical"),
		array("eduk-clipboard" => "clipboard"),
		array("eduk-clipboard-check" => "clipboard-check"),
		array("eduk-clipboard-list" => "clipboard-list"),
		array("eduk-clipboard-list-check" => "clipboard-list-check"),
		array("eduk-clipboard-prescription" => "clipboard-prescription"),
		array("eduk-clipboard-user" => "clipboard-user"),
		array("eduk-clock" => "clock"),
		array("eduk-clone" => "clone"),
		array("eduk-closed-captioning" => "closed-captioning"),
		array("eduk-cloud" => "cloud"),
		array("eduk-cloud-download" => "cloud-download"),
		array("eduk-cloud-download-alt" => "cloud-download-alt"),
		array("eduk-cloud-drizzle" => "cloud-drizzle"),
		array("eduk-cloud-hail" => "cloud-hail"),
		array("eduk-cloud-hail-mixed" => "cloud-hail-mixed"),
		array("eduk-cloud-meatball" => "cloud-meatball"),
		array("eduk-cloud-moon" => "cloud-moon"),
		array("eduk-cloud-moon-rain" => "cloud-moon-rain"),
		array("eduk-cloud-rain" => "cloud-rain"),
		array("eduk-cloud-rainbow" => "cloud-rainbow"),
		array("eduk-clouds" => "clouds"),
		array("eduk-cloud-showers" => "cloud-showers"),
		array("eduk-cloud-showers-heavy" => "cloud-showers-heavy"),
		array("eduk-cloud-sleet" => "cloud-sleet"),
		array("eduk-clouds-moon" => "clouds-moon"),
		array("eduk-cloud-snow" => "cloud-snow"),
		array("eduk-clouds-sun" => "clouds-sun"),
		array("eduk-cloud-sun" => "cloud-sun"),
		array("eduk-cloud-sun-rain" => "cloud-sun-rain"),
		array("eduk-cloud-upload" => "cloud-upload"),
		array("eduk-cloud-upload-alt" => "cloud-upload-alt"),
		array("eduk-club" => "club"),
		array("eduk-cocktail" => "cocktail"),
		array("eduk-code" => "code"),
		array("eduk-code-branch" => "code-branch"),
		array("eduk-code-commit" => "code-commit"),
		array("eduk-code-merge" => "code-merge"),
		array("eduk-coffee" => "coffee"),
		array("eduk-coffee-togo" => "coffee-togo"),
		array("eduk-coffin" => "coffin"),
		array("eduk-cog" => "cog"),
		array("eduk-cogs" => "cogs"),
		array("eduk-coin" => "coin"),
		array("eduk-coins" => "coins"),
		array("eduk-columns" => "columns"),
		array("eduk-comment" => "comment"),
		array("eduk-comment-alt" => "comment-alt"),
		array("eduk-comment-alt-check" => "comment-alt-check"),
		array("eduk-comment-alt-dollar" => "comment-alt-dollar"),
		array("eduk-comment-alt-dots" => "comment-alt-dots"),
		array("eduk-comment-alt-edit" => "comment-alt-edit"),
		array("eduk-comment-alt-exclamation" => "comment-alt-exclamation"),
		array("eduk-comment-alt-lines" => "comment-alt-lines"),
		array("eduk-comment-alt-medical" => "comment-alt-medical"),
		array("eduk-comment-alt-minus" => "comment-alt-minus"),
		array("eduk-comment-alt-plus" => "comment-alt-plus"),
		array("eduk-comment-alt-slash" => "comment-alt-slash"),
		array("eduk-comment-alt-smile" => "comment-alt-smile"),
		array("eduk-comment-alt-times" => "comment-alt-times"),
		array("eduk-comment-check" => "comment-check"),
		array("eduk-comment-dollar" => "comment-dollar"),
		array("eduk-comment-dots" => "comment-dots"),
		array("eduk-comment-edit" => "comment-edit"),
		array("eduk-comment-exclamation" => "comment-exclamation"),
		array("eduk-comment-lines" => "comment-lines"),
		array("eduk-comment-medical" => "comment-medical"),
		array("eduk-comment-minus" => "comment-minus"),
		array("eduk-comment-plus" => "comment-plus"),
		array("eduk-comments" => "comments"),
		array("eduk-comments-alt" => "comments-alt"),
		array("eduk-comments-alt-dollar" => "comments-alt-dollar"),
		array("eduk-comments-dollar" => "comments-dollar"),
		array("eduk-comment-slash" => "comment-slash"),
		array("eduk-comment-smile" => "comment-smile"),
		array("eduk-comment-times" => "comment-times"),
		array("eduk-compact-disc" => "compact-disc"),
		array("eduk-compass" => "compass"),
		array("eduk-compass-slash" => "compass-slash"),
		array("eduk-compress" => "compress"),
		array("eduk-compress-alt" => "compress-alt"),
		array("eduk-compress-arrows-alt" => "compress-arrows-alt"),
		array("eduk-compress-wide" => "compress-wide"),
		array("eduk-concierge-bell" => "concierge-bell"),
		array("eduk-construction" => "construction"),
		array("eduk-container-storage" => "container-storage"),
		array("eduk-conveyor-belt" => "conveyor-belt"),
		array("eduk-conveyor-belt-alt" => "conveyor-belt-alt"),
		array("eduk-cookie" => "cookie"),
		array("eduk-cookie-bite" => "cookie-bite"),
		array("eduk-copy" => "copy"),
		array("eduk-copyright" => "copyright"),
		array("eduk-corn" => "corn"),
		array("eduk-couch" => "couch"),
		array("eduk-cow" => "cow"),
		array("eduk-credit-card" => "credit-card"),
		array("eduk-credit-card-blank" => "credit-card-blank"),
		array("eduk-credit-card-front" => "credit-card-front"),
		array("eduk-cricket" => "cricket"),
		array("eduk-croissant" => "croissant"),
		array("eduk-crop" => "crop"),
		array("eduk-crop-alt" => "crop-alt"),
		array("eduk-cross" => "cross"),
		array("eduk-crosshairs" => "crosshairs"),
		array("eduk-crow" => "crow"),
		array("eduk-crown" => "crown"),
		array("eduk-crutch" => "crutch"),
		array("eduk-crutches" => "crutches"),
		array("eduk-cube" => "cube"),
		array("eduk-cubes" => "cubes"),
		array("eduk-curling" => "curling"),
		array("eduk-cut" => "cut"),
		array("eduk-dagger" => "dagger"),
		array("eduk-database" => "database"),
		array("eduk-deaf" => "deaf"),
		array("eduk-debug" => "debug"),
		array("eduk-deer" => "deer"),
		array("eduk-deer-rudolph" => "deer-rudolph"),
		array("eduk-democrat" => "democrat"),
		array("eduk-desktop" => "desktop"),
		array("eduk-desktop-alt" => "desktop-alt"),
		array("eduk-dewpoint" => "dewpoint"),
		array("eduk-dharmachakra" => "dharmachakra"),
		array("eduk-diagnoses" => "diagnoses"),
		array("eduk-diamond" => "diamond"),
		array("eduk-dice" => "dice"),
		array("eduk-dice-d4" => "dice-d4"),
		array("eduk-dice-d6" => "dice-d6"),
		array("eduk-dice-d8" => "dice-d8"),
		array("eduk-dice-d10" => "dice-d10"),
		array("eduk-dice-d12" => "dice-d12"),
		array("eduk-dice-d20" => "dice-d20"),
		array("eduk-dice-five" => "dice-five"),
		array("eduk-dice-four" => "dice-four"),
		array("eduk-dice-one" => "dice-one"),
		array("eduk-dice-six" => "dice-six"),
		array("eduk-dice-three" => "dice-three"),
		array("eduk-dice-two" => "dice-two"),
		array("eduk-digging" => "digging"),
		array("eduk-digital-tachograph" => "digital-tachograph"),
		array("eduk-diploma" => "diploma"),
		array("eduk-directions" => "directions"),
		array("eduk-disease" => "disease"),
		array("eduk-divide" => "divide"),
		array("eduk-dizzy" => "dizzy"),
		array("eduk-dna" => "dna"),
		array("eduk-dog" => "dog"),
		array("eduk-dog-leashed" => "dog-leashed"),
		array("eduk-dollar-sign" => "dollar-sign"),
		array("eduk-dolly" => "dolly"),
		array("eduk-dolly-empty" => "dolly-empty"),
		array("eduk-dolly-flatbed" => "dolly-flatbed"),
		array("eduk-dolly-flatbed-alt" => "dolly-flatbed-alt"),
		array("eduk-dolly-flatbed-empty" => "dolly-flatbed-empty"),
		array("eduk-donate" => "donate"),
		array("eduk-do-not-enter" => "do-not-enter"),
		array("eduk-door-closed" => "door-closed"),
		array("eduk-door-open" => "door-open"),
		array("eduk-dot-circle" => "dot-circle"),
		array("eduk-dove" => "dove"),
		array("eduk-download" => "download"),
		array("eduk-drafting-compass" => "drafting-compass"),
		array("eduk-dragon" => "dragon"),
		array("eduk-draw-circle" => "draw-circle"),
		array("eduk-draw-polygon" => "draw-polygon"),
		array("eduk-draw-square" => "draw-square"),
		array("eduk-dreidel" => "dreidel"),
		array("eduk-drone" => "drone"),
		array("eduk-drone-alt" => "drone-alt"),
		array("eduk-drum" => "drum"),
		array("eduk-drum-steelpan" => "drum-steelpan"),
		array("eduk-drumstick" => "drumstick"),
		array("eduk-drumstick-bite" => "drumstick-bite"),
		array("eduk-dryer" => "dryer"),
		array("eduk-dryer-alt" => "dryer-alt"),
		array("eduk-duck" => "duck"),
		array("eduk-dumbbell" => "dumbbell"),
		array("eduk-dumpster" => "dumpster"),
		array("eduk-dumpster-fire" => "dumpster-fire"),
		array("eduk-dungeon" => "dungeon"),
		array("eduk-ear" => "ear"),
		array("eduk-ear-muffs" => "ear-muffs"),
		array("eduk-eclipse" => "eclipse"),
		array("eduk-eclipse-alt" => "eclipse-alt"),
		array("eduk-edit" => "edit"),
		array("eduk-egg" => "egg"),
		array("eduk-egg-fried" => "egg-fried"),
		array("eduk-eject" => "eject"),
		array("eduk-elephant" => "elephant"),
		array("eduk-ellipsis-h" => "ellipsis-h"),
		array("eduk-ellipsis-h-alt" => "ellipsis-h-alt"),
		array("eduk-ellipsis-v" => "ellipsis-v"),
		array("eduk-ellipsis-v-alt" => "ellipsis-v-alt"),
		array("eduk-empty-set" => "empty-set"),
		array("eduk-engine-warning" => "engine-warning"),
		array("eduk-envelope" => "envelope"),
		array("eduk-envelope-open" => "envelope-open"),
		array("eduk-envelope-open-dollar" => "envelope-open-dollar"),
		array("eduk-envelope-open-text" => "envelope-open-text"),
		array("eduk-envelope-square" => "envelope-square"),
		array("eduk-equals" => "equals"),
		array("eduk-eraser" => "eraser"),
		array("eduk-ethernet" => "ethernet"),
		array("eduk-euro-sign" => "euro-sign"),
		array("eduk-exchange" => "exchange"),
		array("eduk-exchange-alt" => "exchange-alt"),
		array("eduk-exclamation" => "exclamation"),
		array("eduk-exclamation-circle" => "exclamation-circle"),
		array("eduk-exclamation-square" => "exclamation-square"),
		array("eduk-exclamation-triangle" => "exclamation-triangle"),
		array("eduk-expand" => "expand"),
		array("eduk-expand-alt" => "expand-alt"),
		array("eduk-expand-arrows" => "expand-arrows"),
		array("eduk-expand-arrows-alt" => "expand-arrows-alt"),
		array("eduk-expand-wide" => "expand-wide"),
		array("eduk-external-link" => "external-link"),
		array("eduk-external-link-alt" => "external-link-alt"),
		array("eduk-external-link-square" => "external-link-square"),
		array("eduk-external-link-square-alt" => "external-link-square-alt"),
		array("eduk-eye" => "eye"),
		array("eduk-eye-dropper" => "eye-dropper"),
		array("eduk-eye-evil" => "eye-evil"),
		array("eduk-eye-slash" => "eye-slash"),
		array("eduk-fan" => "fan"),
		array("eduk-farm" => "farm"),
		array("eduk-fast-backward" => "fast-backward"),
		array("eduk-fast-forward" => "fast-forward"),
		array("eduk-fax" => "fax"),
		array("eduk-feather" => "feather"),
		array("eduk-feather-alt" => "feather-alt"),
		array("eduk-female" => "female"),
		array("eduk-field-hockey" => "field-hockey"),
		array("eduk-fighter-jet" => "fighter-jet"),
		array("eduk-file" => "file"),
		array("eduk-file-alt" => "file-alt"),
		array("eduk-file-archive" => "file-archive"),
		array("eduk-file-audio" => "file-audio"),
		array("eduk-file-certificate" => "file-certificate"),
		array("eduk-file-chart-line" => "file-chart-line"),
		array("eduk-file-chart-pie" => "file-chart-pie"),
		array("eduk-file-check" => "file-check"),
		array("eduk-file-code" => "file-code"),
		array("eduk-file-contract" => "file-contract"),
		array("eduk-file-csv" => "file-csv"),
		array("eduk-file-download" => "file-download"),
		array("eduk-file-edit" => "file-edit"),
		array("eduk-file-excel" => "file-excel"),
		array("eduk-file-exclamation" => "file-exclamation"),
		array("eduk-file-export" => "file-export"),
		array("eduk-file-image" => "file-image"),
		array("eduk-file-import" => "file-import"),
		array("eduk-file-invoice" => "file-invoice"),
		array("eduk-file-invoice-dollar" => "file-invoice-dollar"),
		array("eduk-file-medical" => "file-medical"),
		array("eduk-file-medical-alt" => "file-medical-alt"),
		array("eduk-file-minus" => "file-minus"),
		array("eduk-file-pdf" => "file-pdf"),
		array("eduk-file-plus" => "file-plus"),
		array("eduk-file-powerpoint" => "file-powerpoint"),
		array("eduk-file-prescription" => "file-prescription"),
		array("eduk-file-search" => "file-search"),
		array("eduk-file-signature" => "file-signature"),
		array("eduk-files-medical" => "files-medical"),
		array("eduk-file-spreadsheet" => "file-spreadsheet"),
		array("eduk-file-times" => "file-times"),
		array("eduk-file-upload" => "file-upload"),
		array("eduk-file-user" => "file-user"),
		array("eduk-file-video" => "file-video"),
		array("eduk-file-word" => "file-word"),
		array("eduk-fill" => "fill"),
		array("eduk-fill-drip" => "fill-drip"),
		array("eduk-film" => "film"),
		array("eduk-film-alt" => "film-alt"),
		array("eduk-filter" => "filter"),
		array("eduk-fingerprint" => "fingerprint"),
		array("eduk-fire" => "fire"),
		array("eduk-fire-alt" => "fire-alt"),
		array("eduk-fire-extinguisher" => "fire-extinguisher"),
		array("eduk-fireplace" => "fireplace"),
		array("eduk-fire-smoke" => "fire-smoke"),
		array("eduk-first-aid" => "first-aid"),
		array("eduk-fish" => "fish"),
		array("eduk-fish-cooked" => "fish-cooked"),
		array("eduk-fist-raised" => "fist-raised"),
		array("eduk-flag" => "flag"),
		array("eduk-flag-alt" => "flag-alt"),
		array("eduk-flag-checkered" => "flag-checkered"),
		array("eduk-flag-usa" => "flag-usa"),
		array("eduk-flame" => "flame"),
		array("eduk-flask" => "flask"),
		array("eduk-flask-poison" => "flask-poison"),
		array("eduk-flask-potion" => "flask-potion"),
		array("eduk-flower" => "flower"),
		array("eduk-flower-daffodil" => "flower-daffodil"),
		array("eduk-flower-tulip" => "flower-tulip"),
		array("eduk-flushed" => "flushed"),
		array("eduk-fog" => "fog"),
		array("eduk-folder" => "folder"),
		array("eduk-folder-minus" => "folder-minus"),
		array("eduk-folder-open" => "folder-open"),
		array("eduk-folder-plus" => "folder-plus"),
		array("eduk-folders" => "folders"),
		array("eduk-folder-times" => "folder-times"),
		array("eduk-folder-tree" => "folder-tree"),
		array("eduk-font" => "font"),
		array("eduk-font-awesome-logo-full" => "font-awesome-logo-full"),
		array("eduk-font-case" => "font-case"),
		array("eduk-football-ball" => "football-ball"),
		array("eduk-football-helmet" => "football-helmet"),
		array("eduk-forklift" => "forklift"),
		array("eduk-forward" => "forward"),
		array("eduk-fragile" => "fragile"),
		array("eduk-french-fries" => "french-fries"),
		array("eduk-frog" => "frog"),
		array("eduk-frosty-head" => "frosty-head"),
		array("eduk-frown" => "frown"),
		array("eduk-frown-open" => "frown-open"),
		array("eduk-function" => "function"),
		array("eduk-funnel-dollar" => "funnel-dollar"),
		array("eduk-futbol" => "futbol"),
		array("eduk-game-board" => "game-board"),
		array("eduk-game-board-alt" => "game-board-alt"),
		array("eduk-gamepad" => "gamepad"),
		array("eduk-gas-pump" => "gas-pump"),
		array("eduk-gas-pump-slash" => "gas-pump-slash"),
		array("eduk-gavel" => "gavel"),
		array("eduk-gem" => "gem"),
		array("eduk-genderless" => "genderless"),
		array("eduk-ghost" => "ghost"),
		array("eduk-gift" => "gift"),
		array("eduk-gift-card" => "gift-card"),
		array("eduk-gifts" => "gifts"),
		array("eduk-gingerbread-man" => "gingerbread-man"),
		array("eduk-glass" => "glass"),
		array("eduk-glass-champagne" => "glass-champagne"),
		array("eduk-glass-cheers" => "glass-cheers"),
		array("eduk-glass-citrus" => "glass-citrus"),
		array("eduk-glasses" => "glasses"),
		array("eduk-glasses-alt" => "glasses-alt"),
		array("eduk-glass-martini" => "glass-martini"),
		array("eduk-glass-martini-alt" => "glass-martini-alt"),
		array("eduk-glass-whiskey" => "glass-whiskey"),
		array("eduk-glass-whiskey-rocks" => "glass-whiskey-rocks"),
		array("eduk-globe" => "globe"),
		array("eduk-globe-africa" => "globe-africa"),
		array("eduk-globe-americas" => "globe-americas"),
		array("eduk-globe-asia" => "globe-asia"),
		array("eduk-globe-europe" => "globe-europe"),
		array("eduk-globe-snow" => "globe-snow"),
		array("eduk-globe-stand" => "globe-stand"),
		array("eduk-golf-ball" => "golf-ball"),
		array("eduk-golf-club" => "golf-club"),
		array("eduk-gopuram" => "gopuram"),
		array("eduk-graduation-cap" => "graduation-cap"),
		array("eduk-greater-than" => "greater-than"),
		array("eduk-greater-than-equal" => "greater-than-equal"),
		array("eduk-grimace" => "grimace"),
		array("eduk-grin" => "grin"),
		array("eduk-grin-alt" => "grin-alt"),
		array("eduk-grin-beam" => "grin-beam"),
		array("eduk-grin-beam-sweat" => "grin-beam-sweat"),
		array("eduk-grin-hearts" => "grin-hearts"),
		array("eduk-grin-squint" => "grin-squint"),
		array("eduk-grin-squint-tears" => "grin-squint-tears"),
		array("eduk-grin-stars" => "grin-stars"),
		array("eduk-grin-tears" => "grin-tears"),
		array("eduk-grin-tongue" => "grin-tongue"),
		array("eduk-grin-tongue-squint" => "grin-tongue-squint"),
		array("eduk-grin-tongue-wink" => "grin-tongue-wink"),
		array("eduk-grin-wink" => "grin-wink"),
		array("eduk-grip-horizontal" => "grip-horizontal"),
		array("eduk-grip-lines" => "grip-lines"),
		array("eduk-grip-lines-vertical" => "grip-lines-vertical"),
		array("eduk-grip-vertical" => "grip-vertical"),
		array("eduk-guitar" => "guitar"),
		array("eduk-h1" => "h1"),
		array("eduk-h2" => "h2"),
		array("eduk-h3" => "h3"),
		array("eduk-h4" => "h4"),
		array("eduk-hamburger" => "hamburger"),
		array("eduk-hammer" => "hammer"),
		array("eduk-hammer-war" => "hammer-war"),
		array("eduk-hamsa" => "hamsa"),
		array("eduk-hand-heart" => "hand-heart"),
		array("eduk-hand-holding" => "hand-holding"),
		array("eduk-hand-holding-box" => "hand-holding-box"),
		array("eduk-hand-holding-heart" => "hand-holding-heart"),
		array("eduk-hand-holding-magic" => "hand-holding-magic"),
		array("eduk-hand-holding-seedling" => "hand-holding-seedling"),
		array("eduk-hand-holding-usd" => "hand-holding-usd"),
		array("eduk-hand-holding-water" => "hand-holding-water"),
		array("eduk-hand-lizard" => "hand-lizard"),
		array("eduk-hand-middle-finger" => "hand-middle-finger"),
		array("eduk-hand-paper" => "hand-paper"),
		array("eduk-hand-peace" => "hand-peace"),
		array("eduk-hand-point-down" => "hand-point-down"),
		array("eduk-hand-pointer" => "hand-pointer"),
		array("eduk-hand-point-left" => "hand-point-left"),
		array("eduk-hand-point-right" => "hand-point-right"),
		array("eduk-hand-point-up" => "hand-point-up"),
		array("eduk-hand-receiving" => "hand-receiving"),
		array("eduk-hand-rock" => "hand-rock"),
		array("eduk-hands" => "hands"),
		array("eduk-hand-scissors" => "hand-scissors"),
		array("eduk-handshake" => "handshake"),
		array("eduk-handshake-alt" => "handshake-alt"),
		array("eduk-hands-heart" => "hands-heart"),
		array("eduk-hands-helping" => "hands-helping"),
		array("eduk-hand-spock" => "hand-spock"),
		array("eduk-hands-usd" => "hands-usd"),
		array("eduk-hanukiah" => "hanukiah"),
		array("eduk-hard-hat" => "hard-hat"),
		array("eduk-hashtag" => "hashtag"),
		array("eduk-hat-chef" => "hat-chef"),
		array("eduk-hat-santa" => "hat-santa"),
		array("eduk-hat-winter" => "hat-winter"),
		array("eduk-hat-witch" => "hat-witch"),
		array("eduk-hat-wizard" => "hat-wizard"),
		array("eduk-haykal" => "haykal"),
		array("eduk-hdd" => "hdd"),
		array("eduk-heading" => "heading"),
		array("eduk-headphones" => "headphones"),
		array("eduk-headphones-alt" => "headphones-alt"),
		array("eduk-headset" => "headset"),
		array("eduk-head-side" => "head-side"),
		array("eduk-head-side-brain" => "head-side-brain"),
		array("eduk-head-side-medical" => "head-side-medical"),
		array("eduk-head-vr" => "head-vr"),
		array("eduk-heart" => "heart"),
		array("eduk-heartbeat" => "heartbeat"),
		array("eduk-heart-broken" => "heart-broken"),
		array("eduk-heart-circle" => "heart-circle"),
		array("eduk-heart-rate" => "heart-rate"),
		array("eduk-heart-square" => "heart-square"),
		array("eduk-helicopter" => "helicopter"),
		array("eduk-helmet-battle" => "helmet-battle"),
		array("eduk-hexagon" => "hexagon"),
		array("eduk-highlighter" => "highlighter"),
		array("eduk-hiking" => "hiking"),
		array("eduk-hippo" => "hippo"),
		array("eduk-history" => "history"),
		array("eduk-hockey-mask" => "hockey-mask"),
		array("eduk-hockey-puck" => "hockey-puck"),
		array("eduk-hockey-sticks" => "hockey-sticks"),
		array("eduk-holly-berry" => "holly-berry"),
		array("eduk-home" => "home"),
		array("eduk-home-alt" => "home-alt"),
		array("eduk-home-heart" => "home-heart"),
		array("eduk-home-lg" => "home-lg"),
		array("eduk-home-lg-alt" => "home-lg-alt"),
		array("eduk-hood-cloak" => "hood-cloak"),
		array("eduk-horizontal-rule" => "horizontal-rule"),
		array("eduk-horse" => "horse"),
		array("eduk-horse-head" => "horse-head"),
		array("eduk-hospital" => "hospital"),
		array("eduk-hospital-alt" => "hospital-alt"),
		array("eduk-hospitals" => "hospitals"),
		array("eduk-hospital-symbol" => "hospital-symbol"),
		array("eduk-hospital-user" => "hospital-user"),
		array("eduk-hotdog" => "hotdog"),
		array("eduk-hotel" => "hotel"),
		array("eduk-hot-tub" => "hot-tub"),
		array("eduk-hourglass" => "hourglass"),
		array("eduk-hourglass-end" => "hourglass-end"),
		array("eduk-hourglass-half" => "hourglass-half"),
		array("eduk-hourglass-start" => "hourglass-start"),
		array("eduk-house-damage" => "house-damage"),
		array("eduk-house-flood" => "house-flood"),
		array("eduk-hryvnia" => "hryvnia"),
		array("eduk-h-square" => "h-square"),
		array("eduk-humidity" => "humidity"),
		array("eduk-hurricane" => "hurricane"),
		array("eduk-ice-cream" => "ice-cream"),
		array("eduk-ice-skate" => "ice-skate"),
		array("eduk-icicles" => "icicles"),
		array("eduk-icons" => "icons"),
		array("eduk-icons-alt" => "icons-alt"),
		array("eduk-i-cursor" => "i-cursor"),
		array("eduk-id-badge" => "id-badge"),
		array("eduk-id-card" => "id-card"),
		array("eduk-id-card-alt" => "id-card-alt"),
		array("eduk-igloo" => "igloo"),
		array("eduk-image" => "image"),
		array("eduk-images" => "images"),
		array("eduk-inbox" => "inbox"),
		array("eduk-inbox-in" => "inbox-in"),
		array("eduk-inbox-out" => "inbox-out"),
		array("eduk-indent" => "indent"),
		array("eduk-industry" => "industry"),
		array("eduk-industry-alt" => "industry-alt"),
		array("eduk-infinity" => "infinity"),
		array("eduk-info" => "info"),
		array("eduk-info-circle" => "info-circle"),
		array("eduk-info-square" => "info-square"),
		array("eduk-inhaler" => "inhaler"),
		array("eduk-integral" => "integral"),
		array("eduk-intersection" => "intersection"),
		array("eduk-inventory" => "inventory"),
		array("eduk-island-tropical" => "island-tropical"),
		array("eduk-italic" => "italic"),
		array("eduk-jack-o-lantern" => "jack-o-lantern"),
		array("eduk-jedi" => "jedi"),
		array("eduk-joint" => "joint"),
		array("eduk-journal-whills" => "journal-whills"),
		array("eduk-kaaba" => "kaaba"),
		array("eduk-kerning" => "kerning"),
		array("eduk-key" => "key"),
		array("eduk-keyboard" => "keyboard"),
		array("eduk-keynote" => "keynote"),
		array("eduk-key-skeleton" => "key-skeleton"),
		array("eduk-khanda" => "khanda"),
		array("eduk-kidneys" => "kidneys"),
		array("eduk-kiss" => "kiss"),
		array("eduk-kiss-beam" => "kiss-beam"),
		array("eduk-kiss-wink-heart" => "kiss-wink-heart"),
		array("eduk-kite" => "kite"),
		array("eduk-kiwi-bird" => "kiwi-bird"),
		array("eduk-knife-kitchen" => "knife-kitchen"),
		array("eduk-lambda" => "lambda"),
		array("eduk-lamp" => "lamp"),
		array("eduk-landmark" => "landmark"),
		array("eduk-landmark-alt" => "landmark-alt"),
		array("eduk-language" => "language"),
		array("eduk-laptop" => "laptop"),
		array("eduk-laptop-code" => "laptop-code"),
		array("eduk-laptop-medical" => "laptop-medical"),
		array("eduk-laugh" => "laugh"),
		array("eduk-laugh-beam" => "laugh-beam"),
		array("eduk-laugh-squint" => "laugh-squint"),
		array("eduk-laugh-wink" => "laugh-wink"),
		array("eduk-layer-group" => "layer-group"),
		array("eduk-layer-minus" => "layer-minus"),
		array("eduk-layer-plus" => "layer-plus"),
		array("eduk-leaf" => "leaf"),
		array("eduk-leaf-heart" => "leaf-heart"),
		array("eduk-leaf-maple" => "leaf-maple"),
		array("eduk-leaf-oak" => "leaf-oak"),
		array("eduk-lemon" => "lemon"),
		array("eduk-less-than" => "less-than"),
		array("eduk-less-than-equal" => "less-than-equal"),
		array("eduk-level-down" => "level-down"),
		array("eduk-level-down-alt" => "level-down-alt"),
		array("eduk-level-up" => "level-up"),
		array("eduk-level-up-alt" => "level-up-alt"),
		array("eduk-life-ring" => "life-ring"),
		array("eduk-lightbulb" => "lightbulb"),
		array("eduk-lightbulb-dollar" => "lightbulb-dollar"),
		array("eduk-lightbulb-exclamation" => "lightbulb-exclamation"),
		array("eduk-lightbulb-on" => "lightbulb-on"),
		array("eduk-lightbulb-slash" => "lightbulb-slash"),
		array("eduk-lights-holiday" => "lights-holiday"),
		array("eduk-line-columns" => "line-columns"),
		array("eduk-line-height" => "line-height"),
		array("eduk-link" => "link"),
		array("eduk-lips" => "lips"),
		array("eduk-lira-sign" => "lira-sign"),
		array("eduk-list" => "list"),
		array("eduk-list-alt" => "list-alt"),
		array("eduk-list-ol" => "list-ol"),
		array("eduk-list-ul" => "list-ul"),
		array("eduk-location" => "location"),
		array("eduk-location-arrow" => "location-arrow"),
		array("eduk-location-circle" => "location-circle"),
		array("eduk-location-slash" => "location-slash"),
		array("eduk-lock" => "lock"),
		array("eduk-lock-alt" => "lock-alt"),
		array("eduk-lock-open" => "lock-open"),
		array("eduk-lock-open-alt" => "lock-open-alt"),
		array("eduk-long-arrow-alt-down" => "long-arrow-alt-down"),
		array("eduk-long-arrow-alt-left" => "long-arrow-alt-left"),
		array("eduk-long-arrow-alt-right" => "long-arrow-alt-right"),
		array("eduk-long-arrow-alt-up" => "long-arrow-alt-up"),
		array("eduk-long-arrow-down" => "long-arrow-down"),
		array("eduk-long-arrow-left" => "long-arrow-left"),
		array("eduk-long-arrow-right" => "long-arrow-right"),
		array("eduk-long-arrow-up" => "long-arrow-up"),
		array("eduk-loveseat" => "loveseat"),
		array("eduk-low-vision" => "low-vision"),
		array("eduk-luchador" => "luchador"),
		array("eduk-luggage-cart" => "luggage-cart"),
		array("eduk-lungs" => "lungs"),
		array("eduk-mace" => "mace"),
		array("eduk-magic" => "magic"),
		array("eduk-magnet" => "magnet"),
		array("eduk-mailbox" => "mailbox"),
		array("eduk-mail-bulk" => "mail-bulk"),
		array("eduk-male" => "male"),
		array("eduk-mandolin" => "mandolin"),
		array("eduk-map" => "map"),
		array("eduk-map-marked" => "map-marked"),
		array("eduk-map-marked-alt" => "map-marked-alt"),
		array("eduk-map-marker" => "map-marker"),
		array("eduk-map-marker-alt" => "map-marker-alt"),
		array("eduk-map-marker-alt-slash" => "map-marker-alt-slash"),
		array("eduk-map-marker-check" => "map-marker-check"),
		array("eduk-map-marker-edit" => "map-marker-edit"),
		array("eduk-map-marker-exclamation" => "map-marker-exclamation"),
		array("eduk-map-marker-minus" => "map-marker-minus"),
		array("eduk-map-marker-plus" => "map-marker-plus"),
		array("eduk-map-marker-question" => "map-marker-question"),
		array("eduk-map-marker-slash" => "map-marker-slash"),
		array("eduk-map-marker-smile" => "map-marker-smile"),
		array("eduk-map-marker-times" => "map-marker-times"),
		array("eduk-map-pin" => "map-pin"),
		array("eduk-map-signs" => "map-signs"),
		array("eduk-marker" => "marker"),
		array("eduk-mars" => "mars"),
		array("eduk-mars-double" => "mars-double"),
		array("eduk-mars-stroke" => "mars-stroke"),
		array("eduk-mars-stroke-h" => "mars-stroke-h"),
		array("eduk-mars-stroke-v" => "mars-stroke-v"),
		array("eduk-mask" => "mask"),
		array("eduk-meat" => "meat"),
		array("eduk-medal" => "medal"),
		array("eduk-medkit" => "medkit"),
		array("eduk-megaphone" => "megaphone"),
		array("eduk-meh" => "meh"),
		array("eduk-meh-blank" => "meh-blank"),
		array("eduk-meh-rolling-eyes" => "meh-rolling-eyes"),
		array("eduk-memory" => "memory"),
		array("eduk-menorah" => "menorah"),
		array("eduk-mercury" => "mercury"),
		array("eduk-meteor" => "meteor"),
		array("eduk-microchip" => "microchip"),
		array("eduk-microphone" => "microphone"),
		array("eduk-microphone-alt" => "microphone-alt"),
		array("eduk-microphone-alt-slash" => "microphone-alt-slash"),
		array("eduk-microphone-slash" => "microphone-slash"),
		array("eduk-microscope" => "microscope"),
		array("eduk-mind-share" => "mind-share"),
		array("eduk-minus" => "minus"),
		array("eduk-minus-circle" => "minus-circle"),
		array("eduk-minus-hexagon" => "minus-hexagon"),
		array("eduk-minus-octagon" => "minus-octagon"),
		array("eduk-minus-square" => "minus-square"),
		array("eduk-mistletoe" => "mistletoe"),
		array("eduk-mitten" => "mitten"),
		array("eduk-mobile" => "mobile"),
		array("eduk-mobile-alt" => "mobile-alt"),
		array("eduk-mobile-android" => "mobile-android"),
		array("eduk-mobile-android-alt" => "mobile-android-alt"),
		array("eduk-money-bill" => "money-bill"),
		array("eduk-money-bill-alt" => "money-bill-alt"),
		array("eduk-money-bill-wave" => "money-bill-wave"),
		array("eduk-money-bill-wave-alt" => "money-bill-wave-alt"),
		array("eduk-money-check" => "money-check"),
		array("eduk-money-check-alt" => "money-check-alt"),
		array("eduk-money-check-edit" => "money-check-edit"),
		array("eduk-money-check-edit-alt" => "money-check-edit-alt"),
		array("eduk-monitor-heart-rate" => "monitor-heart-rate"),
		array("eduk-monkey" => "monkey"),
		array("eduk-monument" => "monument"),
		array("eduk-moon" => "moon"),
		array("eduk-moon-cloud" => "moon-cloud"),
		array("eduk-moon-stars" => "moon-stars"),
		array("eduk-mortar-pestle" => "mortar-pestle"),
		array("eduk-mosque" => "mosque"),
		array("eduk-motorcycle" => "motorcycle"),
		array("eduk-mountain" => "mountain"),
		array("eduk-mountains" => "mountains"),
		array("eduk-mouse-pointer" => "mouse-pointer"),
		array("eduk-mug" => "mug"),
		array("eduk-mug-hot" => "mug-hot"),
		array("eduk-mug-marshmallows" => "mug-marshmallows"),
		array("eduk-mug-tea" => "mug-tea"),
		array("eduk-music" => "music"),
		array("eduk-narwhal" => "narwhal"),
		array("eduk-network-wired" => "network-wired"),
		array("eduk-neuter" => "neuter"),
		array("eduk-newspaper" => "newspaper"),
		array("eduk-not-equal" => "not-equal"),
		array("eduk-notes-medical" => "notes-medical"),
		array("eduk-object-group" => "object-group"),
		array("eduk-object-ungroup" => "object-ungroup"),
		array("eduk-octagon" => "octagon"),
		array("eduk-oil-can" => "oil-can"),
		array("eduk-oil-temp" => "oil-temp"),
		array("eduk-om" => "om"),
		array("eduk-omega" => "omega"),
		array("eduk-ornament" => "ornament"),
		array("eduk-otter" => "otter"),
		array("eduk-outdent" => "outdent"),
		array("eduk-overline" => "overline"),
		array("eduk-page-break" => "page-break"),
		array("eduk-pager" => "pager"),
		array("eduk-paint-brush" => "paint-brush"),
		array("eduk-paint-brush-alt" => "paint-brush-alt"),
		array("eduk-paint-roller" => "paint-roller"),
		array("eduk-palette" => "palette"),
		array("eduk-pallet" => "pallet"),
		array("eduk-pallet-alt" => "pallet-alt"),
		array("eduk-paperclip" => "paperclip"),
		array("eduk-paper-plane" => "paper-plane"),
		array("eduk-parachute-box" => "parachute-box"),
		array("eduk-paragraph" => "paragraph"),
		array("eduk-paragraph-rtl" => "paragraph-rtl"),
		array("eduk-parking" => "parking"),
		array("eduk-parking-circle" => "parking-circle"),
		array("eduk-parking-circle-slash" => "parking-circle-slash"),
		array("eduk-parking-slash" => "parking-slash"),
		array("eduk-passport" => "passport"),
		array("eduk-pastafarianism" => "pastafarianism"),
		array("eduk-paste" => "paste"),
		array("eduk-pause" => "pause"),
		array("eduk-pause-circle" => "pause-circle"),
		array("eduk-paw" => "paw"),
		array("eduk-paw-alt" => "paw-alt"),
		array("eduk-paw-claws" => "paw-claws"),
		array("eduk-peace" => "peace"),
		array("eduk-pegasus" => "pegasus"),
		array("eduk-pen" => "pen"),
		array("eduk-pen-alt" => "pen-alt"),
		array("eduk-pencil" => "pencil"),
		array("eduk-pencil-alt" => "pencil-alt"),
		array("eduk-pencil-paintbrush" => "pencil-paintbrush"),
		array("eduk-pencil-ruler" => "pencil-ruler"),
		array("eduk-pen-fancy" => "pen-fancy"),
		array("eduk-pennant" => "pennant"),
		array("eduk-pen-nib" => "pen-nib"),
		array("eduk-pen-square" => "pen-square"),
		array("eduk-people-carry" => "people-carry"),
		array("eduk-pepper-hot" => "pepper-hot"),
		array("eduk-percent" => "percent"),
		array("eduk-percentage" => "percentage"),
		array("eduk-person-booth" => "person-booth"),
		array("eduk-person-carry" => "person-carry"),
		array("eduk-person-dolly" => "person-dolly"),
		array("eduk-person-dolly-empty" => "person-dolly-empty"),
		array("eduk-person-sign" => "person-sign"),
		array("eduk-phone" => "phone"),
		array("eduk-phone-alt" => "phone-alt"),
		array("eduk-phone-laptop" => "phone-laptop"),
		array("eduk-phone-office" => "phone-office"),
		array("eduk-phone-plus" => "phone-plus"),
		array("eduk-phone-slash" => "phone-slash"),
		array("eduk-phone-square" => "phone-square"),
		array("eduk-phone-square-alt" => "phone-square-alt"),
		array("eduk-phone-volume" => "phone-volume"),
		array("eduk-photo-video" => "photo-video"),
		array("eduk-pi" => "pi"),
		array("eduk-pie" => "pie"),
		array("eduk-pig" => "pig"),
		array("eduk-piggy-bank" => "piggy-bank"),
		array("eduk-pills" => "pills"),
		array("eduk-pizza" => "pizza"),
		array("eduk-pizza-slice" => "pizza-slice"),
		array("eduk-place-of-worship" => "place-of-worship"),
		array("eduk-plane" => "plane"),
		array("eduk-plane-alt" => "plane-alt"),
		array("eduk-plane-arrival" => "plane-arrival"),
		array("eduk-plane-departure" => "plane-departure"),
		array("eduk-play" => "play"),
		array("eduk-play-circle" => "play-circle"),
		array("eduk-plug" => "plug"),
		array("eduk-plus" => "plus"),
		array("eduk-plus-circle" => "plus-circle"),
		array("eduk-plus-hexagon" => "plus-hexagon"),
		array("eduk-plus-octagon" => "plus-octagon"),
		array("eduk-plus-square" => "plus-square"),
		array("eduk-podcast" => "podcast"),
		array("eduk-podium" => "podium"),
		array("eduk-podium-star" => "podium-star"),
		array("eduk-poll" => "poll"),
		array("eduk-poll-h" => "poll-h"),
		array("eduk-poll-people" => "poll-people"),
		array("eduk-poo" => "poo"),
		array("eduk-poop" => "poop"),
		array("eduk-poo-storm" => "poo-storm"),
		array("eduk-popcorn" => "popcorn"),
		array("eduk-portrait" => "portrait"),
		array("eduk-pound-sign" => "pound-sign"),
		array("eduk-power-off" => "power-off"),
		array("eduk-pray" => "pray"),
		array("eduk-praying-hands" => "praying-hands"),
		array("eduk-prescription" => "prescription"),
		array("eduk-prescription-bottle" => "prescription-bottle"),
		array("eduk-prescription-bottle-alt" => "prescription-bottle-alt"),
		array("eduk-presentation" => "presentation"),
		array("eduk-print" => "print"),
		array("eduk-print-search" => "print-search"),
		array("eduk-print-slash" => "print-slash"),
		array("eduk-procedures" => "procedures"),
		array("eduk-project-diagram" => "project-diagram"),
		array("eduk-pumpkin" => "pumpkin"),
		array("eduk-puzzle-piece" => "puzzle-piece"),
		array("eduk-qrcode" => "qrcode"),
		array("eduk-question" => "question"),
		array("eduk-question-circle" => "question-circle"),
		array("eduk-question-square" => "question-square"),
		array("eduk-quidditch" => "quidditch"),
		array("eduk-quote-left" => "quote-left"),
		array("eduk-quote-right" => "quote-right"),
		array("eduk-quran" => "quran"),
		array("eduk-rabbit" => "rabbit"),
		array("eduk-rabbit-fast" => "rabbit-fast"),
		array("eduk-racquet" => "racquet"),
		array("eduk-radiation" => "radiation"),
		array("eduk-radiation-alt" => "radiation-alt"),
		array("eduk-rainbow" => "rainbow"),
		array("eduk-raindrops" => "raindrops"),
		array("eduk-ram" => "ram"),
		array("eduk-ramp-loading" => "ramp-loading"),
		array("eduk-random" => "random"),
		array("eduk-receipt" => "receipt"),
		array("eduk-rectangle-landscape" => "rectangle-landscape"),
		array("eduk-rectangle-portrait" => "rectangle-portrait"),
		array("eduk-rectangle-wide" => "rectangle-wide"),
		array("eduk-recycle" => "recycle"),
		array("eduk-redo" => "redo"),
		array("eduk-redo-alt" => "redo-alt"),
		array("eduk-registered" => "registered"),
		array("eduk-remove-format" => "remove-format"),
		array("eduk-repeat" => "repeat"),
		array("eduk-repeat-1" => "repeat-1"),
		array("eduk-repeat-1-alt" => "repeat-1-alt"),
		array("eduk-repeat-alt" => "repeat-alt"),
		array("eduk-reply" => "reply"),
		array("eduk-reply-all" => "reply-all"),
		array("eduk-republican" => "republican"),
		array("eduk-restroom" => "restroom"),
		array("eduk-retweet" => "retweet"),
		array("eduk-retweet-alt" => "retweet-alt"),
		array("eduk-ribbon" => "ribbon"),
		array("eduk-ring" => "ring"),
		array("eduk-rings-wedding" => "rings-wedding"),
		array("eduk-road" => "road"),
		array("eduk-robot" => "robot"),
		array("eduk-rocket" => "rocket"),
		array("eduk-route" => "route"),
		array("eduk-route-highway" => "route-highway"),
		array("eduk-route-interstate" => "route-interstate"),
		array("eduk-rss" => "rss"),
		array("eduk-rss-square" => "rss-square"),
		array("eduk-ruble-sign" => "ruble-sign"),
		array("eduk-ruler" => "ruler"),
		array("eduk-ruler-combined" => "ruler-combined"),
		array("eduk-ruler-horizontal" => "ruler-horizontal"),
		array("eduk-ruler-triangle" => "ruler-triangle"),
		array("eduk-ruler-vertical" => "ruler-vertical"),
		array("eduk-running" => "running"),
		array("eduk-rupee-sign" => "rupee-sign"),
		array("eduk-rv" => "rv"),
		array("eduk-sack" => "sack"),
		array("eduk-sack-dollar" => "sack-dollar"),
		array("eduk-sad-cry" => "sad-cry"),
		array("eduk-sad-tear" => "sad-tear"),
		array("eduk-salad" => "salad"),
		array("eduk-sandwich" => "sandwich"),
		array("eduk-satellite" => "satellite"),
		array("eduk-satellite-dish" => "satellite-dish"),
		array("eduk-sausage" => "sausage"),
		array("eduk-save" => "save"),
		array("eduk-scalpel" => "scalpel"),
		array("eduk-scalpel-path" => "scalpel-path"),
		array("eduk-scanner" => "scanner"),
		array("eduk-scanner-keyboard" => "scanner-keyboard"),
		array("eduk-scanner-touchscreen" => "scanner-touchscreen"),
		array("eduk-scarecrow" => "scarecrow"),
		array("eduk-scarf" => "scarf"),
		array("eduk-school" => "school"),
		array("eduk-screwdriver" => "screwdriver"),
		array("eduk-scroll" => "scroll"),
		array("eduk-scroll-old" => "scroll-old"),
		array("eduk-scrubber" => "scrubber"),
		array("eduk-scythe" => "scythe"),
		array("eduk-sd-card" => "sd-card"),
		array("eduk-search" => "search"),
		array("eduk-search-dollar" => "search-dollar"),
		array("eduk-search-location" => "search-location"),
		array("eduk-search-minus" => "search-minus"),
		array("eduk-search-plus" => "search-plus"),
		array("eduk-seedling" => "seedling"),
		array("eduk-send-back" => "send-back"),
		array("eduk-send-backward" => "send-backward"),
		array("eduk-server" => "server"),
		array("eduk-shapes" => "shapes"),
		array("eduk-share" => "share"),
		array("eduk-share-all" => "share-all"),
		array("eduk-share-alt" => "share-alt"),
		array("eduk-share-alt-square" => "share-alt-square"),
		array("eduk-share-square" => "share-square"),
		array("eduk-sheep" => "sheep"),
		array("eduk-shekel-sign" => "shekel-sign"),
		array("eduk-shield" => "shield"),
		array("eduk-shield-alt" => "shield-alt"),
		array("eduk-shield-check" => "shield-check"),
		array("eduk-shield-cross" => "shield-cross"),
		array("eduk-ship" => "ship"),
		array("eduk-shipping-fast" => "shipping-fast"),
		array("eduk-shipping-timed" => "shipping-timed"),
		array("eduk-shish-kebab" => "shish-kebab"),
		array("eduk-shoe-prints" => "shoe-prints"),
		array("eduk-shopping-bag" => "shopping-bag"),
		array("eduk-shopping-basket" => "shopping-basket"),
		array("eduk-shopping-cart" => "shopping-cart"),
		array("eduk-shovel" => "shovel"),
		array("eduk-shovel-snow" => "shovel-snow"),
		array("eduk-shower" => "shower"),
		array("eduk-shredder" => "shredder"),
		array("eduk-shuttlecock" => "shuttlecock"),
		array("eduk-shuttle-van" => "shuttle-van"),
		array("eduk-sickle" => "sickle"),
		array("eduk-sigma" => "sigma"),
		array("eduk-sign" => "sign"),
		array("eduk-signal" => "signal"),
		array("eduk-signal-1" => "signal-1"),
		array("eduk-signal-2" => "signal-2"),
		array("eduk-signal-3" => "signal-3"),
		array("eduk-signal-4" => "signal-4"),
		array("eduk-signal-alt" => "signal-alt"),
		array("eduk-signal-alt-1" => "signal-alt-1"),
		array("eduk-signal-alt-2" => "signal-alt-2"),
		array("eduk-signal-alt-3" => "signal-alt-3"),
		array("eduk-signal-alt-slash" => "signal-alt-slash"),
		array("eduk-signal-slash" => "signal-slash"),
		array("eduk-signature" => "signature"),
		array("eduk-sign-in" => "sign-in"),
		array("eduk-sign-in-alt" => "sign-in-alt"),
		array("eduk-sign-language" => "sign-language"),
		array("eduk-sign-out" => "sign-out"),
		array("eduk-sign-out-alt" => "sign-out-alt"),
		array("eduk-sim-card" => "sim-card"),
		array("eduk-sitemap" => "sitemap"),
		array("eduk-skating" => "skating"),
		array("eduk-skeleton" => "skeleton"),
		array("eduk-skiing" => "skiing"),
		array("eduk-skiing-nordic" => "skiing-nordic"),
		array("eduk-ski-jump" => "ski-jump"),
		array("eduk-ski-lift" => "ski-lift"),
		array("eduk-skull" => "skull"),
		array("eduk-skull-crossbones" => "skull-crossbones"),
		array("eduk-slash" => "slash"),
		array("eduk-sledding" => "sledding"),
		array("eduk-sleigh" => "sleigh"),
		array("eduk-sliders-h" => "sliders-h"),
		array("eduk-sliders-h-square" => "sliders-h-square"),
		array("eduk-sliders-v" => "sliders-v"),
		array("eduk-sliders-v-square" => "sliders-v-square"),
		array("eduk-smile" => "smile"),
		array("eduk-smile-beam" => "smile-beam"),
		array("eduk-smile-plus" => "smile-plus"),
		array("eduk-smile-wink" => "smile-wink"),
		array("eduk-smog" => "smog"),
		array("eduk-smoke" => "smoke"),
		array("eduk-smoking" => "smoking"),
		array("eduk-smoking-ban" => "smoking-ban"),
		array("eduk-sms" => "sms"),
		array("eduk-snake" => "snake"),
		array("eduk-snooze" => "snooze"),
		array("eduk-snow-blowing" => "snow-blowing"),
		array("eduk-snowboarding" => "snowboarding"),
		array("eduk-snowflake" => "snowflake"),
		array("eduk-snowflakes" => "snowflakes"),
		array("eduk-snowman" => "snowman"),
		array("eduk-snowmobile" => "snowmobile"),
		array("eduk-snowplow" => "snowplow"),
		array("eduk-socks" => "socks"),
		array("eduk-solar-panel" => "solar-panel"),
		array("eduk-sort" => "sort"),
		array("eduk-sort-alpha-down" => "sort-alpha-down"),
		array("eduk-sort-alpha-down-alt" => "sort-alpha-down-alt"),
		array("eduk-sort-alpha-up" => "sort-alpha-up"),
		array("eduk-sort-alpha-up-alt" => "sort-alpha-up-alt"),
		array("eduk-sort-alt" => "sort-alt"),
		array("eduk-sort-amount-down" => "sort-amount-down"),
		array("eduk-sort-amount-down-alt" => "sort-amount-down-alt"),
		array("eduk-sort-amount-up" => "sort-amount-up"),
		array("eduk-sort-amount-up-alt" => "sort-amount-up-alt"),
		array("eduk-sort-down" => "sort-down"),
		array("eduk-sort-numeric-down" => "sort-numeric-down"),
		array("eduk-sort-numeric-down-alt" => "sort-numeric-down-alt"),
		array("eduk-sort-numeric-up" => "sort-numeric-up"),
		array("eduk-sort-numeric-up-alt" => "sort-numeric-up-alt"),
		array("eduk-sort-shapes-down" => "sort-shapes-down"),
		array("eduk-sort-shapes-down-alt" => "sort-shapes-down-alt"),
		array("eduk-sort-shapes-up" => "sort-shapes-up"),
		array("eduk-sort-shapes-up-alt" => "sort-shapes-up-alt"),
		array("eduk-sort-size-down" => "sort-size-down"),
		array("eduk-sort-size-down-alt" => "sort-size-down-alt"),
		array("eduk-sort-size-up" => "sort-size-up"),
		array("eduk-sort-size-up-alt" => "sort-size-up-alt"),
		array("eduk-sort-up" => "sort-up"),
		array("eduk-soup" => "soup"),
		array("eduk-spa" => "spa"),
		array("eduk-space-shuttle" => "space-shuttle"),
		array("eduk-spade" => "spade"),
		array("eduk-sparkles" => "sparkles"),
		array("eduk-spell-check" => "spell-check"),
		array("eduk-spider" => "spider"),
		array("eduk-spider-black-widow" => "spider-black-widow"),
		array("eduk-spider-web" => "spider-web"),
		array("eduk-spinner" => "spinner"),
		array("eduk-spinner-third" => "spinner-third"),
		array("eduk-splotch" => "splotch"),
		array("eduk-spray-can" => "spray-can"),
		array("eduk-square" => "square"),
		array("eduk-square-full" => "square-full"),
		array("eduk-square-root" => "square-root"),
		array("eduk-square-root-alt" => "square-root-alt"),
		array("eduk-squirrel" => "squirrel"),
		array("eduk-staff" => "staff"),
		array("eduk-stamp" => "stamp"),
		array("eduk-star" => "star"),
		array("eduk-star-and-crescent" => "star-and-crescent"),
		array("eduk-star-christmas" => "star-christmas"),
		array("eduk-star-exclamation" => "star-exclamation"),
		array("eduk-star-half" => "star-half"),
		array("eduk-star-half-alt" => "star-half-alt"),
		array("eduk-star-of-david" => "star-of-david"),
		array("eduk-star-of-life" => "star-of-life"),
		array("eduk-stars" => "stars"),
		array("eduk-steak" => "steak"),
		array("eduk-steering-wheel" => "steering-wheel"),
		array("eduk-step-backward" => "step-backward"),
		array("eduk-step-forward" => "step-forward"),
		array("eduk-stethoscope" => "stethoscope"),
		array("eduk-sticky-note" => "sticky-note"),
		array("eduk-stocking" => "stocking"),
		array("eduk-stomach" => "stomach"),
		array("eduk-stop" => "stop"),
		array("eduk-stop-circle" => "stop-circle"),
		array("eduk-stopwatch" => "stopwatch"),
		array("eduk-store" => "store"),
		array("eduk-store-alt" => "store-alt"),
		array("eduk-stream" => "stream"),
		array("eduk-street-view" => "street-view"),
		array("eduk-stretcher" => "stretcher"),
		array("eduk-strikethrough" => "strikethrough"),
		array("eduk-stroopwafel" => "stroopwafel"),
		array("eduk-subscript" => "subscript"),
		array("eduk-subway" => "subway"),
		array("eduk-suitcase" => "suitcase"),
		array("eduk-suitcase-rolling" => "suitcase-rolling"),
		array("eduk-sun" => "sun"),
		array("eduk-sun-cloud" => "sun-cloud"),
		array("eduk-sun-dust" => "sun-dust"),
		array("eduk-sunglasses" => "sunglasses"),
		array("eduk-sun-haze" => "sun-haze"),
		array("eduk-sunrise" => "sunrise"),
		array("eduk-sunset" => "sunset"),
		array("eduk-superscript" => "superscript"),
		array("eduk-surprise" => "surprise"),
		array("eduk-swatchbook" => "swatchbook"),
		array("eduk-swimmer" => "swimmer"),
		array("eduk-swimming-pool" => "swimming-pool"),
		array("eduk-sword" => "sword"),
		array("eduk-swords" => "swords"),
		array("eduk-synagogue" => "synagogue"),
		array("eduk-sync" => "sync"),
		array("eduk-sync-alt" => "sync-alt"),
		array("eduk-syringe" => "syringe"),
		array("eduk-table" => "table"),
		array("eduk-tablet" => "tablet"),
		array("eduk-tablet-alt" => "tablet-alt"),
		array("eduk-tablet-android" => "tablet-android"),
		array("eduk-tablet-android-alt" => "tablet-android-alt"),
		array("eduk-table-tennis" => "table-tennis"),
		array("eduk-tablet-rugged" => "tablet-rugged"),
		array("eduk-tablets" => "tablets"),
		array("eduk-tachometer" => "tachometer"),
		array("eduk-tachometer-alt" => "tachometer-alt"),
		array("eduk-tachometer-alt-average" => "tachometer-alt-average"),
		array("eduk-tachometer-alt-fast" => "tachometer-alt-fast"),
		array("eduk-tachometer-alt-fastest" => "tachometer-alt-fastest"),
		array("eduk-tachometer-alt-slow" => "tachometer-alt-slow"),
		array("eduk-tachometer-alt-slowest" => "tachometer-alt-slowest"),
		array("eduk-tachometer-average" => "tachometer-average"),
		array("eduk-tachometer-fast" => "tachometer-fast"),
		array("eduk-tachometer-fastest" => "tachometer-fastest"),
		array("eduk-tachometer-slow" => "tachometer-slow"),
		array("eduk-tachometer-slowest" => "tachometer-slowest"),
		array("eduk-taco" => "taco"),
		array("eduk-tag" => "tag"),
		array("eduk-tags" => "tags"),
		array("eduk-tally" => "tally"),
		array("eduk-tanakh" => "tanakh"),
		array("eduk-tape" => "tape"),
		array("eduk-tasks" => "tasks"),
		array("eduk-tasks-alt" => "tasks-alt"),
		array("eduk-taxi" => "taxi"),
		array("eduk-teeth" => "teeth"),
		array("eduk-teeth-open" => "teeth-open"),
		array("eduk-temperature-frigid" => "temperature-frigid"),
		array("eduk-temperature-high" => "temperature-high"),
		array("eduk-temperature-hot" => "temperature-hot"),
		array("eduk-temperature-low" => "temperature-low"),
		array("eduk-tenge" => "tenge"),
		array("eduk-tennis-ball" => "tennis-ball"),
		array("eduk-terminal" => "terminal"),
		array("eduk-text" => "text"),
		array("eduk-text-height" => "text-height"),
		array("eduk-text-size" => "text-size"),
		array("eduk-text-width" => "text-width"),
		array("eduk-th" => "th"),
		array("eduk-theater-masks" => "theater-masks"),
		array("eduk-thermometer" => "thermometer"),
		array("eduk-thermometer-empty" => "thermometer-empty"),
		array("eduk-thermometer-full" => "thermometer-full"),
		array("eduk-thermometer-half" => "thermometer-half"),
		array("eduk-thermometer-quarter" => "thermometer-quarter"),
		array("eduk-thermometer-three-quarters" => "thermometer-three-quarters"),
		array("eduk-theta" => "theta"),
		array("eduk-th-large" => "th-large"),
		array("eduk-th-list" => "th-list"),
		array("eduk-thumbs-down" => "thumbs-down"),
		array("eduk-thumbs-up" => "thumbs-up"),
		array("eduk-thumbtack" => "thumbtack"),
		array("eduk-thunderstorm" => "thunderstorm"),
		array("eduk-thunderstorm-moon" => "thunderstorm-moon"),
		array("eduk-thunderstorm-sun" => "thunderstorm-sun"),
		array("eduk-ticket" => "ticket"),
		array("eduk-ticket-alt" => "ticket-alt"),
		array("eduk-tilde" => "tilde"),
		array("eduk-times" => "times"),
		array("eduk-times-circle" => "times-circle"),
		array("eduk-times-hexagon" => "times-hexagon"),
		array("eduk-times-octagon" => "times-octagon"),
		array("eduk-times-square" => "times-square"),
		array("eduk-tint" => "tint"),
		array("eduk-tint-slash" => "tint-slash"),
		array("eduk-tire" => "tire"),
		array("eduk-tired" => "tired"),
		array("eduk-tire-flat" => "tire-flat"),
		array("eduk-tire-pressure-warning" => "tire-pressure-warning"),
		array("eduk-tire-rugged" => "tire-rugged"),
		array("eduk-toggle-off" => "toggle-off"),
		array("eduk-toggle-on" => "toggle-on"),
		array("eduk-toilet" => "toilet"),
		array("eduk-toilet-paper" => "toilet-paper"),
		array("eduk-toilet-paper-alt" => "toilet-paper-alt"),
		array("eduk-tombstone" => "tombstone"),
		array("eduk-tombstone-alt" => "tombstone-alt"),
		array("eduk-toolbox" => "toolbox"),
		array("eduk-tools" => "tools"),
		array("eduk-tooth" => "tooth"),
		array("eduk-toothbrush" => "toothbrush"),
		array("eduk-torah" => "torah"),
		array("eduk-torii-gate" => "torii-gate"),
		array("eduk-tornado" => "tornado"),
		array("eduk-tractor" => "tractor"),
		array("eduk-trademark" => "trademark"),
		array("eduk-traffic-cone" => "traffic-cone"),
		array("eduk-traffic-light" => "traffic-light"),
		array("eduk-traffic-light-go" => "traffic-light-go"),
		array("eduk-traffic-light-slow" => "traffic-light-slow"),
		array("eduk-traffic-light-stop" => "traffic-light-stop"),
		array("eduk-train" => "train"),
		array("eduk-tram" => "tram"),
		array("eduk-transgender" => "transgender"),
		array("eduk-transgender-alt" => "transgender-alt"),
		array("eduk-trash" => "trash"),
		array("eduk-trash-alt" => "trash-alt"),
		array("eduk-trash-restore" => "trash-restore"),
		array("eduk-trash-restore-alt" => "trash-restore-alt"),
		array("eduk-trash-undo" => "trash-undo"),
		array("eduk-trash-undo-alt" => "trash-undo-alt"),
		array("eduk-treasure-chest" => "treasure-chest"),
		array("eduk-tree" => "tree"),
		array("eduk-tree-alt" => "tree-alt"),
		array("eduk-tree-christmas" => "tree-christmas"),
		array("eduk-tree-decorated" => "tree-decorated"),
		array("eduk-tree-large" => "tree-large"),
		array("eduk-tree-palm" => "tree-palm"),
		array("eduk-trees" => "trees"),
		array("eduk-triangle" => "triangle"),
		array("eduk-trophy" => "trophy"),
		array("eduk-trophy-alt" => "trophy-alt"),
		array("eduk-truck" => "truck"),
		array("eduk-truck-container" => "truck-container"),
		array("eduk-truck-couch" => "truck-couch"),
		array("eduk-truck-loading" => "truck-loading"),
		array("eduk-truck-monster" => "truck-monster"),
		array("eduk-truck-moving" => "truck-moving"),
		array("eduk-truck-pickup" => "truck-pickup"),
		array("eduk-truck-plow" => "truck-plow"),
		array("eduk-truck-ramp" => "truck-ramp"),
		array("eduk-tshirt" => "tshirt"),
		array("eduk-tty" => "tty"),
		array("eduk-turkey" => "turkey"),
		array("eduk-turtle" => "turtle"),
		array("eduk-tv" => "tv"),
		array("eduk-tv-retro" => "tv-retro"),
		array("eduk-umbrella" => "umbrella"),
		array("eduk-umbrella-beach" => "umbrella-beach"),
		array("eduk-underline" => "underline"),
		array("eduk-undo" => "undo"),
		array("eduk-undo-alt" => "undo-alt"),
		array("eduk-unicorn" => "unicorn"),
		array("eduk-union" => "union"),
		array("eduk-universal-access" => "universal-access"),
		array("eduk-university" => "university"),
		array("eduk-unlink" => "unlink"),
		array("eduk-unlock" => "unlock"),
		array("eduk-unlock-alt" => "unlock-alt"),
		array("eduk-upload" => "upload"),
		array("eduk-usd-circle" => "usd-circle"),
		array("eduk-usd-square" => "usd-square"),
		array("eduk-user" => "user"),
		array("eduk-user-alt" => "user-alt"),
		array("eduk-user-alt-slash" => "user-alt-slash"),
		array("eduk-user-astronaut" => "user-astronaut"),
		array("eduk-user-chart" => "user-chart"),
		array("eduk-user-check" => "user-check"),
		array("eduk-user-circle" => "user-circle"),
		array("eduk-user-clock" => "user-clock"),
		array("eduk-user-cog" => "user-cog"),
		array("eduk-user-crown" => "user-crown"),
		array("eduk-user-edit" => "user-edit"),
		array("eduk-user-friends" => "user-friends"),
		array("eduk-user-graduate" => "user-graduate"),
		array("eduk-user-hard-hat" => "user-hard-hat"),
		array("eduk-user-headset" => "user-headset"),
		array("eduk-user-injured" => "user-injured"),
		array("eduk-user-lock" => "user-lock"),
		array("eduk-user-md" => "user-md"),
		array("eduk-user-md-chat" => "user-md-chat"),
		array("eduk-user-minus" => "user-minus"),
		array("eduk-user-ninja" => "user-ninja"),
		array("eduk-user-nurse" => "user-nurse"),
		array("eduk-user-plus" => "user-plus"),
		array("eduk-users" => "users"),
		array("eduk-users-class" => "users-class"),
		array("eduk-users-cog" => "users-cog"),
		array("eduk-users-crown" => "users-crown"),
		array("eduk-user-secret" => "user-secret"),
		array("eduk-user-shield" => "user-shield"),
		array("eduk-user-slash" => "user-slash"),
		array("eduk-users-medical" => "users-medical"),
		array("eduk-user-tag" => "user-tag"),
		array("eduk-user-tie" => "user-tie"),
		array("eduk-user-times" => "user-times"),
		array("eduk-utensil-fork" => "utensil-fork"),
		array("eduk-utensil-knife" => "utensil-knife"),
		array("eduk-utensils" => "utensils"),
		array("eduk-utensils-alt" => "utensils-alt"),
		array("eduk-utensil-spoon" => "utensil-spoon"),
		array("eduk-value-absolute" => "value-absolute"),
		array("eduk-vector-square" => "vector-square"),
		array("eduk-venus" => "venus"),
		array("eduk-venus-double" => "venus-double"),
		array("eduk-venus-mars" => "venus-mars"),
		array("eduk-vial" => "vial"),
		array("eduk-vials" => "vials"),
		array("eduk-video" => "video"),
		array("eduk-video-plus" => "video-plus"),
		array("eduk-video-slash" => "video-slash"),
		array("eduk-vihara" => "vihara"),
		array("eduk-voicemail" => "voicemail"),
		array("eduk-volcano" => "volcano"),
		array("eduk-volleyball-ball" => "volleyball-ball"),
		array("eduk-volume" => "volume"),
		array("eduk-volume-down" => "volume-down"),
		array("eduk-volume-mute" => "volume-mute"),
		array("eduk-volume-off" => "volume-off"),
		array("eduk-volume-slash" => "volume-slash"),
		array("eduk-volume-up" => "volume-up"),
		array("eduk-vote-nay" => "vote-nay"),
		array("eduk-vote-yea" => "vote-yea"),
		array("eduk-vr-cardboard" => "vr-cardboard"),
		array("eduk-walker" => "walker"),
		array("eduk-walking" => "walking"),
		array("eduk-wallet" => "wallet"),
		array("eduk-wand" => "wand"),
		array("eduk-wand-magic" => "wand-magic"),
		array("eduk-warehouse" => "warehouse"),
		array("eduk-warehouse-alt" => "warehouse-alt"),
		array("eduk-washer" => "washer"),
		array("eduk-watch" => "watch"),
		array("eduk-watch-fitness" => "watch-fitness"),
		array("eduk-water" => "water"),
		array("eduk-water-lower" => "water-lower"),
		array("eduk-water-rise" => "water-rise"),
		array("eduk-wave-sine" => "wave-sine"),
		array("eduk-wave-square" => "wave-square"),
		array("eduk-wave-triangle" => "wave-triangle"),
		array("eduk-webcam" => "webcam"),
		array("eduk-webcam-slash" => "webcam-slash"),
		array("eduk-weight" => "weight"),
		array("eduk-weight-hanging" => "weight-hanging"),
		array("eduk-whale" => "whale"),
		array("eduk-wheat" => "wheat"),
		array("eduk-wheelchair" => "wheelchair"),
		array("eduk-whistle" => "whistle"),
		array("eduk-wifi" => "wifi"),
		array("eduk-wifi-1" => "wifi-1"),
		array("eduk-wifi-2" => "wifi-2"),
		array("eduk-wifi-slash" => "wifi-slash"),
		array("eduk-wind" => "wind"),
		array("eduk-window" => "window"),
		array("eduk-window-alt" => "window-alt"),
		array("eduk-window-close" => "window-close"),
		array("eduk-window-maximize" => "window-maximize"),
		array("eduk-window-minimize" => "window-minimize"),
		array("eduk-window-restore" => "window-restore"),
		array("eduk-windsock" => "windsock"),
		array("eduk-wind-turbine" => "wind-turbine"),
		array("eduk-wind-warning" => "wind-warning"),
		array("eduk-wine-bottle" => "wine-bottle"),
		array("eduk-wine-glass" => "wine-glass"),
		array("eduk-wine-glass-alt" => "wine-glass-alt"),
		array("eduk-won-sign" => "won-sign"),
		array("eduk-wreath" => "wreath"),
		array("eduk-wrench" => "wrench"),
		array("eduk-x-ray" => "x-ray"),
		array("eduk-yen-sign" => "yen-sign"),
		array("eduk-yin-yang" => "yin-yang")
    );
}

// Return simple fonts array
if ( ! function_exists('edukul_plugin_google_font') ) {
	function edukul_plugin_google_font() {
		if ( function_exists('edukul_google_fonts_array') ) {
			$default = array( 0 => 'Default' );
			return array_merge( $default, edukul_google_fonts_array() );
		} else {
			return array(
				'Default', 'Arial, Helvetica, sans-serif', 'Arial Black, Gadget, sans-serif',
				'Bookman Old Style, serif', 'Comic Sans MS, cursive', 'Courier, monospace',
				'Georgia, serif', 'Garamond, serif', 'Impact, Charcoal, sans-serif', 'Lucida Console, Monaco, monospace',
				'Lucida Sans Unicode, Lucida Grande, sans-serif', 'MS Sans Serif, Geneva, sans-serif', 'MS Serif, New York, sans-serif',
				'Palatino Linotype, Book Antiqua, Palatino, serif', 'Tahoma, Geneva, sans-serif', 'Times New Roman, Times, serif',
				'Trebuchet MS, Helvetica, sans-serif', 'Verdana, Geneva, sans-serif', 'Paratina Linotype', 'Trebuchet MS',
			);
		}
	}
}

// Get icon font base on font icon type
if ( ! function_exists('edukul_get_icon_class') ) {
	function edukul_get_icon_class( $atts, $icon_location ) {
		// Define vars
		$icon = '';
		$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'fontawesome';

		// Generate fontawesome icon class
		if ( 'fontawesome' == $icon_type && ! empty( $atts[$icon_location] ) ) {
			$icon = $atts[$icon_location];
			$icon = str_replace( 'fa-', '', $icon );
			$icon = str_replace( 'fa ', '', $icon );
			$icon = 'fa fa-'. $icon;
		} elseif ( ! empty( $atts[ $icon_location .'_'. $icon_type ] ) ) {
			$icon = $atts[ $icon_location .'_'. $icon_type ];
		}

		// Sanitize
		$icon = in_array( $icon, array( 'icon', 'none' ) ) ? '' : $icon;

		// Return icon class
		return $icon;
	}
}

// Get memberships
function edukul_educator_get_memberships() {
    $return = array( esc_html__(' --- Choose a Plan --- ', 'edukul') => '' );

    $args = array(
        'post_type' => 'edr_membership',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    );

    $posts = get_posts( $args );
    if ( !empty($posts) ) {
        foreach ($posts as $post) {
            $return[$post->post_title] = $post->post_name;
        }
    }

    return $return;
}

// Spacing
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Spacing', 'edukul'),
        'description' => esc_html__('Empty space with custom height.', 'edukul'),
        'base' => 'spacing',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Desktop: Height', 'edukul'),
				'param_name' => 'desktop_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Mobile: Height', 'edukul'),
				'param_name' => 'mobile_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Small Mobile: Height', 'edukul'),
				'param_name' => 'smobile_height',
				'value' => '',
	        ),
        )
    ) );
} );

// Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_carouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Carousel Box', 'edukul'),
		'description' => esc_html__('Scrolling anything.', 'edukul'),
		'base' => 'carouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'testimonials, contentbox, imagebox, iconbox, videoicon, simpleimage, headings, fancytext, singleheading, pricetable, counter'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'edukul' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'edukul'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Center Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_centercarouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Center Carousel Box', 'edukul'),
		'description' => esc_html__('Scrolling anything.', 'edukul'),
		'base' => 'centercarouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, imagebox, iconbox, simpleimage, pricetable'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'true',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Spacing Between', 'edukul' ),
				'param_name' => 'gap',
				'value'      => array(
					'0px' => '0',
					'10px' => '10',
					'20px' => '20',
					'30px' => '30',
					'40px' => '40',
					'50px' => '50',
					'60px' => '60',
				),
				'std'		=> '30',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Slide Show', 'edukul' ),
				'param_name' => 'slide',
				'value'      => array(
					'1' => '1',
					'3' => '3',
				),
				'std'		=> '3',
			),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Padding Content', 'edukul'),
				'param_name' => 'padding',
				'value' => 15,
				'suffix' => '%',
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'40px' => '40',
					'30px' => '30',
					'20px' => '20',
					'10px' => '10',
					'0px' => '0',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
        )
    ) );
} );

// Galleries Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Gallery Grid', 'edukul'),
        'description' => esc_html__('Displaying gallery posts in grid with filter bar.', 'edukul'),
        'base' => 'gallerygrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Margin', 'edukul'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'500 x 500' => 'square2',
					'740 x 500' => 'rectangle',
				),
				'std'		=> 'rectangle',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gapv',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'edukul'),
				'param_name' => 'gaph',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            // Query
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'edukul'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'edukul' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'edukul'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'edukul'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'edukul'),
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'edukul' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'edukul' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
			// Filter
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'edukul' ),
				'param_name' => 'show_filter',
				'group' => esc_html__( 'Filter', 'edukul' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: All', 'edukul'),
				'param_name' => 'filter_button_all',
				'value' => 'All',
				'group' => esc_html__( 'Filter', 'edukul' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'edukul'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'bottom_filter',
				'value' => '',
				'description'	=> esc_html__('Ex: 45px.', 'edukul'),
				'group' => esc_html__( 'Filter', 'edukul' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter Alignment', 'edukul' ),
				'param_name' => 'filter_align',
				'value'      => array(
					'Left' => 'style-1',
					'Center' => 'style-2',
					'Right' => 'style-3',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Filter', 'edukul' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Filter posts by default?', 'edukul' ),
				'param_name' => 'filter_by_default',
				'group' => esc_html__( 'Filter', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'edukul'),
				'param_name' => 'filter_cat_slug',
				'value' => '',
				'group' => esc_html__( 'Filter', 'edukul' ),
				'dependency' => array( 'element' => 'filter_by_default', 'value' => 'yes' ),
				'description'	=> esc_html__('Filter posts from this category by default. Using category-slug.', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'edukul' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Testimonials
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials', 'edukul'),
	    'description' => esc_html__('Displaying testimonials box.', 'edukul'),
	    'base' => 'testimonials',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
			),
	        // Text
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Text', 'edukul'),
				'param_name' 	=> 'text',
				'value' 		=> '',
			),
            // Name
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Name', 'edukul'),
				'param_name' => 'name',
				'value' => 'JOHN JOE',
            ),
            // Position
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Position', 'edukul'),
				'param_name' => 'position',
				'value' => 'Sale Manager',
            ),
	    )
	) );
} );

// Testimonials Group
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials Group', 'conceptseven'),
	    'description' => esc_html__('Displaying testimonials posts.', 'conceptseven'),
	    'base' => 'testimonialsgroup',
		'weight'	=>	180,
		'show_settings_on_create' => false,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'edukul'),
				'param_name' => 'items',
				'value' => '4',
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 65px 70px 65px 70px', 'edukul'),
	        ),
	    )
	) );
} );

// News Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('News Carousel', 'edukul'),
	    'description' => esc_html__('Displaying blog posts in carousel.', 'edukul'),
	    'base' => 'news',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Option', 'edukul' ),
				'param_name' => 'image_option',
				'value'      => array(
					'Post Thumbnail' => 'default',
					'Metabox Thumbnail' => 'custom',
				),
				'std'		=> 'default',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'740 x 740' => 'square',
					'740 x 600' => 'rectangle4',
					'740 x 500' => 'rectangle',
					'570 x 350' => 'rectangle2',
					'570 x 730' => 'rectangle3',
				),
				'std'		=> 'rectangle',
				'dependency' => array( 'element' => 'image_option', 'value' => 'default' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 17px 30px 17px', 'edukul'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'edukul'),
				'param_name' => 'content_background',
				'value' => '#f7f7f7',
            ),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'edukul'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'edukul'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Excerpt Length', 'finax'),
				'param_name' => 'excerpt_lenght',
				'value' => '23',
				'description' => esc_html('The number of words you wish to display in the excerpt. Leave empty to hide the excerpt.', 'finax'),
				'group' => esc_html__( 'Query', 'finax' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Text', 'finax'),
				'param_name' => 'link_text',
				'value' => 'Read more',
				'group' => esc_html__( 'Query', 'finax' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'edukul' ),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'edukul'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	    )
	) );
} );

// Progress Bar
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Bar', 'edukul'),
        'description' => esc_html__('Displaying progress bars.', 'edukul'),
        'base' => 'progressbar',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'edukul'),
				'param_name' => 'title',
				'value' => esc_html__('Title', 'edukul'),
				'description' => esc_html__('Title of the ProgressBar.', 'edukul')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'edukul'),
				'param_name' => 'title_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Percentage', 'edukul'),
				'param_name' => 'percent',
				'value' => '90',
				'description' => esc_html__('Percentage value of the ProgressBar', 'edukul')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percentage Color', 'edukul'),
				'param_name' => 'per_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height of Bars', 'edukul'),
				'param_name' => 'height',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Space between Text & Line', 'edukul'),
				'param_name' => 'space_between',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'edukul'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'edukul'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1', 'edukul'),
				'param_name' => 'line_one',
				'value' => '#636363',
				'group' => esc_html__( 'Line Color', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2', 'edukul'),
				'param_name' => 'line_two',
				'value' => '#e5e5e5',
				'group' => esc_html__( 'Line Color', 'edukul' ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable gradient color?', 'edukul' ),
				'param_name' => 'gradient',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'group' => esc_html__( 'Line Color', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'edukul' ),
				'param_name' => 'font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'edukul' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'edukul'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
        )
    ) );
} );

// Progress Circle
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Circle', 'edukul'),
        'description' => esc_html__('Displaying progress circles.', 'edukul'),
        'base' => 'progresscircle',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'edukul'),
				'param_name' => 'width',
				'value' => '200px',
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Percent', 'edukul'),
				'param_name' => 'percent',
				'value' => 90,
				'suffix' => '%',
		  	),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percent: Color', 'edukul'),
				'param_name' => 'pc',
				'value' => '#222222',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Percent: Font Size', 'edukul'),
				'param_name' => 'ps',
				'value' => '20px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Stroke Width', 'edukul'),
				'param_name' => 'sw',
				'value' => '4px',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Stroke Color', 'edukul'),
				'param_name' => 'sc',
				'value' => '#222222',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Trail Width', 'edukul'),
				'param_name' => 'tw',
				'value' => '4px',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Trail Color', 'edukul'),
				'param_name' => 'tc',
				'value' => '#f7f7f7',
            ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Accordions
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Accordions or Toggles', 'edukul' ),
        'description' => esc_html__('Displaying Accordions or Toggles', 'edukul'),
		'base'        => 'accordions',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'accordion' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Type', 'edukul' ),
				'param_name' => 'type',
				'value'      => array(
					'Accordions' => 'accordions',
					'Toggles' => 'toggles',
				),
				'std'		=> 'accordions',
			),
		)
	) );
} );

// Accordion
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Item', 'edukul' ),
    'description' => esc_html__('Item for Accordions or Toggles', 'edukul'),
		'base'        => 'accordion',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'as_child'    => array( 'only' => 'accordions' ),
		'params'      => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Active by default?', 'edukul' ),
				'param_name' => 'open',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'edukul'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => 5,
				'suffix' => 'px',
				'description'	=> esc_html__('Default: 10px', 'edukul'),
		  	),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Padding', 'edukul'),
				'param_name' => 'heading_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 25px 13px 25px', 'edukul'),
				'group' => esc_html__( 'Heading', 'edukul' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'heading_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 25px', 'edukul'),
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 0px 30px 0px', 'edukul'),
				'group' => esc_html__( 'Content', 'edukul' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Parallax Image Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_parallaxbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Parallax Image Box', 'edukul' ),
        'description' => esc_html__('Parallax Box', 'edukul'),
		'base'        => 'parallaxbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'parallaxitem' ),
		'controls' => 'full',
		'show_settings_on_create' => false,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView'
	) );
} );

// Parallax Box Item
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Item', 'edukul' ),
    'description' => esc_html__('Item for Parallax Image Box', 'edukul'),
		'base'        => 'parallaxitem',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'as_child'    => array( 'only' => 'parallaxbox' ),
		'params'      => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'edukul'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('You can use % or px value. Ex: 50%.', 'edukul'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Rounded', 'edukul'),
				'param_name' => 'image_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'edukul'),
            ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax X', 'edukul'),
	            'param_name' => 'parallax_x',
	            'description'   => esc_html__('X axis translation.', 'edukul'),
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax Y', 'edukul'),
	            'param_name' => 'parallax_y',
	            'description'   => esc_html__('Y axis translation.', 'edukul'),
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Smoothness', 'edukul'),
	            'param_name' => 'smoothness',
	            'value' => '30',
	            'description'   => esc_html__('Slowdown the animation.', 'edukul'),
	        ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Left', 'edukul'),
				'param_name' => 'left',
				'value' => '',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Top', 'edukul'),
				'param_name' => 'top',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
            ),
		)
	) );
} );

// Tabs
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_dtabs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Tabs', 'edukul' ),
        'description' => esc_html__('Displaying Tabbed Content.', 'edukul'),
		'base'        => 'dtabs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'dtab' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Width', 'edukul' ),
				'param_name' => 'title_width',
				'value'      => array(
					'150px' => 'w150',
					'160px' => 'w160',
					'170px' => 'w170',
					'180px' => 'w180',
					'190px' => 'w190',
					'200px' => 'w200',
					'220px' => 'w220',
					'240px' => 'w240',
					'260px' => 'w260',
					'280px' => 'w280',
					'300px' => 'w300',
				),
				'std'		=> 'w190',
				'dependency' => array( 'element' => 'style', 'value' => array('style-3','style-4')),
	        ),
		)
	) );
} );

// Tab
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Tab', 'edukul' ),
    'description' => esc_html__('Displaying Tab.', 'edukul'),
		'base'        => 'dtab',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'as_child'    => array( 'only' => 'dtabs' ),
		'params'      => array(
			// Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'edukul'),
				'param_name' => 'title',
				'value' => 'Tab',
				'group' => esc_html__( 'Title', 'edukul' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 20px 0px 0px 37px;', 'edukul'),
				'group' => esc_html__( 'Content', 'edukul' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Family', 'edukul' ),
				'param_name' => 'title_font_family',
				'value'      => edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Weight', 'edukul' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'edukul'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Line-Height', 'edukul'),
				'param_name' => 'title_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Action Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Action Box', 'edukul'),
	    'description' => esc_html__('Displaying Action-Box or Promo-Box.', 'edukul'),
	    'base' => 'actionbox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Area: Width', 'edukul'),
				'param_name' => 'content_width',
				'value' => '',
				'description'	=> esc_html__('Default: 70%', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Area: Alignment', 'edukul' ),
				'param_name' => 'content_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Area: Width', 'edukul'),
				'param_name' => 'button_width',
				'value' => '',
				'description'	=> esc_html__('Default: 20%', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Area: Alignment', 'edukul' ),
				'param_name' => 'button_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-right',
			),
            // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Text', 'edukul'),
				'param_name' => 'heading_text',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'edukul'),
				'param_name' => 'heading_width',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading', 'edukul' ),
				'param_name' => 'subheading_text',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'edukul'),
				'param_name' => 'subheading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'edukul'),
				'param_name' => 'subheading_width',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            // Button
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Text (Required)', 'edukul'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'edukul' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button URL (Required):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'edukul' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'Button', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'edukul'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'edukul'),
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'edukul'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'edukul'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'edukul'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'Button', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'edukul' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Button', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'edukul'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'edukul'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'edukul'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'edukul'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
            ),
            // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'edukul'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'edukul' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'edukul' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'edukul'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'edukul'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'edukul'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'edukul' ),
				'param_name' => 'button_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'edukul' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'edukul'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'edukul'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Margin', 'edukul'),
				'param_name' => 'heading_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Margin', 'edukul'),
				'param_name' => 'button_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	    )
	) );
} );

// Image Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Image Box', 'edukul'),
	    'description' => esc_html__('Displaying image box.', 'edukul'),
	    'base' => 'imagebox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'edukul'),
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'hading_content',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading URL (Optional):', 'edukul'),
				'param_name' => 'heading_url',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'edukul'),
				'param_name' => 'desc_content',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
			array(
				'type' 		=> 'textarea',
				'holder' => 'div',
				'heading' 	=> esc_html__('Description', 'edukul'),
				'param_name' 	=> 'description',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'edukul'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array( 'style-1', 'style-3' ) ),
            ),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'edukul' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Link Style', 'edukul' ),
				'param_name' => 'link_style',
				'value'      => array(
					'Style 1' => 'link-style-1',
					'Style 2' => 'link-style-2',
				),
				'std'		=> 'link-style-1',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'edukul'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'edukul'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'edukul' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'edukul'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'edukul'),
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'edukul'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'edukul'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'edukul'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'edukul' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border Color', 'edukul'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'edukul'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'edukul'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'edukul'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'edukul'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'edukul' ),
				'param_name' => 'desc_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'edukul' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'edukul'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'edukul'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'edukul'),
				'param_name' => 'btn_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'edukul' ),
				'param_name' => 'button_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'edukul' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'edukul'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'edukul'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'edukul'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'edukul'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	    )
	) );
} );

// Links
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Links', 'edukul' ),
        'description' => esc_html__('Displaying a link.', 'edukul'),
		'base'        => 'advlinks',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content (Required)', 'edukul' ),
				'param_name' => 'content',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Color', 'edukul' ),
				'param_name' => 'color',
				'value'      => array(
					'Acccent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'accent',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (Required)', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'edukul'),
				'param_name' => 'margin',
				'value' => '',
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'edukul' ),
				'param_name' => 'content_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'edukul' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'edukul'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// List
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'List', 'edukul' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'edukul'),
		'base'        => 'advlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'content_background_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'edukul' ),
				'param_name' => 'content_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'content_border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'content_border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 12px 30px 12px 30px', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'content_rounded',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'content_bottom_margin',
				'value' => '',
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'edukul' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'Simple' => 'simple',
					'Background' => 'background',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'edukul'),
				'param_name' => 'icon_bg',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'edukul'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'edukul'),
				'param_name' => 'icon_width',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'edukul'),
				'param_name' => 'icon_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'edukul'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'edukul'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'edukul'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'edukul' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Middle' => 'icon-middle',
					'Top' => 'icon-top',
				),
				'std'		=> 'icon-middle',
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Icon Top Margin', 'edukul' ),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			// Content
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content', 'edukul' ),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'edukul' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'edukul'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Left Padding', 'edukul'),
				'param_name' => 'content_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Content', 'edukul' ),
				'description'	=> esc_html__('Spacing between the icon and the content', 'edukul'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Family', 'edukul' ),
				'param_name' => 'content_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Weight', 'edukul' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Font Size', 'edukul'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Line-Height', 'edukul'),
				'param_name' => 'content_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Menu List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Menu List', 'edukul'),
	    'description' => esc_html__('Menu List.', 'edukul'),
	    'base' => 'menulist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background',
				'value' => '#f5f5f5',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'border_color',
				'value' => '#b2b2b2',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'border_width',
				'value' => '1px 0px 1px 0px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'edukul' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'edukul'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 10px 20px 10px 20px', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => '10',
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'edukul'),
				'param_name' => 'text_content',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'edukul'),
				'param_name' => 'text',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'edukul'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'edukul'),
				'param_name' => 'value_content',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Value', 'edukul'),
				'param_name' => 'value',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'edukul'),
				'param_name' => 'value_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'edukul'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'edukul' ),
				'param_name' => 'text_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'edukul' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'edukul'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'edukul'),
				'param_name' => 'value_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Family', 'edukul' ),
				'param_name' => 'value_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Weight', 'edukul' ),
				'param_name' => 'value_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Value: Font Size', 'edukul'),
				'param_name' => 'value_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Icon Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon Box', 'edukul' ),
        'description' => esc_html__('Displaying Icon Box with custom icon.', 'edukul'),
		'base'        => 'iconbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
					'Icon Left 2' => 'icon-left2',
				),
				'std'		=> 'icon-top',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'edukul' ),
				'param_name' => 'text_align',
				'value'      => array(
					'Left' => 'align-left',
					'Center' => 'align-center',
					'Right' => 'align-right',
				),
				'std'		=> 'align-left',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'edukul' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'edukul'),
				'param_name' => 'wrap_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'edukul'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background', 'edukul'),
				'param_name' => 'wrap_background',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Rounded', 'edukul'),
				'param_name' => 'wrap_rounded',
				'value' => '',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Border Color', 'edukul'),
				'param_name' => 'wrap_border',
				'value' => '#e7e7e7',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Border Width', 'edukul'),
				'param_name' => 'wrap_border_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 1px', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap Border Style', 'edukul' ),
				'param_name' => 'wrap_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'edukul'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 100px', 'edukul'),
				'group' => esc_html__( 'Image', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_fontawesome',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'edukul'),
				'param_name' => 'icon_font_size',
				'value' => '30px',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'edukul'),
				'param_name' => 'icon_width',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'edukul'),
				'param_name' => 'icon_height',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line Height', 'edukul'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'edukul'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'edukul'),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'edukul'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'edukul'),
				'param_name' => 'icon_background',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border Color', 'edukul'),
				'param_name' => 'icon_border',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Border Width', 'edukul'),
				'param_name' => 'icon_border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'edukul'),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Border Style', 'edukul' ),
				'param_name' => 'icon_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'edukul'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background: Hover', 'edukul'),
				'param_name' => 'icon_background_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border: Hover', 'edukul'),
				'param_name' => 'icon_border_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
			// Icon Shadow
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Icon Shadow', 'edukul' ),
				'param_name'  => 'icon_inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'icon_horizontal',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'icon_vertical',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'icon_blur',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'icon_spread',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'icon_shadow_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
			// Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading URL (Optional):', 'edukul'),
				'param_name' => 'heading_url',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Description', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'edukul'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'edukul' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Link Style', 'edukul' ),
				'param_name' => 'link_style',
				'value'      => array(
					'Style 1' => 'link-style-1',
					'Style 2' => 'link-style-2',
					'Style 3' => 'link-style-3',
					'Style 4' => 'link-style-4',
					'Style 5' => 'link-style-5',
				),
				'std'		=> 'link-style-1',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Color', 'edukul' ),
				'param_name' => 'link_color',
				'value'      => array(
					'Acccent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'edukul'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'edukul' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'edukul'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'edukul'),
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'edukul'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'edukul'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'edukul'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'edukul' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'edukul'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'edukul'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'edukul'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'edukul'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'edukul'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'edukul' ),
				'param_name' => 'desc_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'edukul' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'edukul'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'edukul'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'edukul'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'edukul' ),
				'param_name' => 'button_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'edukul' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'edukul'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'edukul'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Margin', 'edukul'),
				'param_name' => 'icon_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Left Padding', 'edukul'),
				'param_name' => 'content_left_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'edukul' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Right Padding', 'edukul'),
				'param_name' => 'content_right_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'edukul' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-right' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Left Margin', 'edukul'),
				'param_name' => 'heading_left_margin',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'edukul' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'edukul'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'edukul'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'edukul'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        // Hover
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hover Style', 'edukul' ),
				'param_name' => 'hover_style',
				'value'      => array(
					'No' => '',
					'Light' => 'hover-style-1',
					'Dark' => 'hover-style-2',
					'Accent' => 'hover-style-3',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'bg_color',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
				'dependency' => array( 'element' => 'hover_style', 'value' => array( 'hover-style-1', 'hover-style-2' ) ),
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'edukul'),
				'param_name' => 'bg_image',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
				'dependency' => array( 'element' => 'hover_style', 'value' => array( 'hover-style-1', 'hover-style-2' ) ),
			),
		)
	) );
} );

// Icon List
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_iconlists extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon List', 'edukul' ),
        'description' => esc_html__('Icon List', 'edukul'),
		'base'        => 'iconlists',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'as_parent' => array( 'only' => 'iconlist' ),
		'controls' => 'full',
		'show_settings_on_create' => false,
		'js_view' => 'VcColumnView',
		'params' => array(
		)
	) );
} );

// Icon List Item
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Item', 'edukul' ),
    'description' => esc_html__('Item for Icon List', 'edukul'),
		'base'        => 'iconlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'as_child'    => array( 'only' => 'iconlists' ),
		'params'      => array(
            array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__('Number', 'edukul'),
				'param_name' => 'number',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'edukul'),
				'param_name' => 'number_color',
				'value' => '',
            ),
            array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Description', 'edukul' ),
				'param_name' => 'description',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'edukul'),
				'param_name' => 'desc_color',
				'value' => '',
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number', 'edukul'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number Font Family', 'edukul' ),
				'param_name' => 'number_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number Font Weight', 'edukul' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number Font Size', 'edukul'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number Line-Height', 'edukul'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'edukul'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'edukul' ),
				'param_name' => 'desc_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'edukul' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'edukul'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'edukul'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			// Spacing
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => '50px',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number Margin', 'edukul'),
				'param_name' => 'number_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Margin', 'edukul'),
				'param_name' => 'heading_margin',
				'value' => '0 0 12px 100px',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Margin', 'edukul'),
				'param_name' => 'desc_margin',
				'value' => '0 0 0 100px',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
		)
	) );
} );

// PriceTable
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Price Table', 'edukul' ),
        'description' => esc_html__('Displaying Price Tables.', 'edukul'),
		'base'        => 'pricetable',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'edukul'),
				'param_name' => 'padding',
				'value' => '',
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'bg_color',
				'value' => '',
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'edukul'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'edukul' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'edukul' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Size', 'edukul' ),
				'param_name'  => 'bg_size',
				'value'       => array(
					'Auto' 	   => '',
					'Cover'        => 'cover',
				),
				'std'		=> '',
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Box Shadow
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
            ),
			// Heading
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Sub-Heading', 'edukul'),
				'param_name' => 'subheading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'edukul'),
				'param_name' => 'subheading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
			// Price
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Price', 'edukul'),
				'param_name' => 'price',
				'value' => '199',
				'group' => esc_html__( 'Price', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Color', 'edukul'),
				'param_name' => 'price_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'edukul' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Currency', 'edukul' ),
				'param_name' => 'currency',
				'value' => '$',
				'group' => esc_html__( 'Price', 'edukul' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Currency Color', 'edukul'),
				'param_name' => 'currency_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'edukul' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Unit', 'edukul' ),
				'param_name' => 'unit',
				'value' => '/MO',
				'group' => esc_html__( 'Price', 'edukul' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Unit Color', 'edukul'),
				'param_name' => 'unit_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'edukul' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Content', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'edukul'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'edukul' ),
            ),
			// Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text (Required)', 'edukul'),
				'param_name' => 'link_text',
				'value' => 'Sign Up',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'edukul' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'edukul'),
				'param_name' => 'button_rounded',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'edukul'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'edukul'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border Color', 'edukul'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'edukul'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'edukul' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'edukul'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'edukul'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'edukul'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'edukul' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),      
			array(
				'type' => 'headings',
				'text' => esc_html__('Price', 'edukul'),
				'param_name' => 'price_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Family', 'edukul' ),
				'param_name' => 'price_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Weight', 'edukul' ),
				'param_name' => 'price_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Font Size', 'edukul'),
				'param_name' => 'price_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Line-Height', 'edukul'),
				'param_name' => 'price_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Unit', 'edukul'),
				'param_name' => 'unit_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Family', 'edukul' ),
				'param_name' => 'unit_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Weight', 'edukul' ),
				'param_name' => 'unit_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Font Size', 'edukul'),
				'param_name' => 'unit_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'edukul'),
				'param_name' => 'unit_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Margin', 'edukul'),
				'param_name' => 'heading_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Margin', 'edukul'),
				'param_name' => 'price_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Margin', 'edukul'),
				'param_name' => 'content_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Margin', 'edukul'),
				'param_name' => 'button_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
		)
	) );
} );

// Content Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_contentbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Content Box', 'edukul'),
		'description' => esc_html__('Content Box.', 'edukul'),
		'base' => 'contentbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'contentbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'edukul'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'edukul' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'edukul' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Size', 'edukul' ),
				'param_name'  => 'bg_size',
				'value'       => array(
					'Auto' 	   => '',
					'Cover'        => 'cover',
				),
				'std'		=> '',
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            // Spacing
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'center',
				),
				'std'		=> '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'edukul'),
				'param_name' => 'width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'description'	=> esc_html__('Ex: 600px', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width on mobile', 'edukul'),
				'param_name' => 'mobile_width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'description'	=> esc_html__('Ex: 400px', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'edukul'),
				'param_name' => 'height',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'description'	=> esc_html__('Ex: 400px', 'edukul'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'edukul'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'edukul'),
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding on mobile', 'edukul'),
				'param_name' => 'mobile_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'edukul'),
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'edukul'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin on mobile', 'edukul'),
				'param_name' => 'mobile_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ), 
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'edukul'),
	        ),
            // Design
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'edukul'),
				'param_name' => 'heading_background',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'edukul'),
				'param_name' => 'heading_border',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'border_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'edukul'),
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'heading_rounded',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'edukul'),
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'edukul'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
	        // Hover
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'edukul'),
				'param_name' => 'heading_background_hover',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'edukul'),
				'param_name' => 'heading_border_hover',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'border_width_hover',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'edukul'),
				'group' => esc_html__( 'Hover', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'heading_rounded_hover',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded_hover',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'edukul'),
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'edukul'),
				'param_name' => 'heading_shadow_hover',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset_hover',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Transforms', 'edukul'),
				'param_name' => 'heading_transforms',
				'group' => esc_html__( 'Hover', 'edukul' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate X', 'edukul'),
				'param_name' => 'translatex',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'edukul' ),
		  	),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate Y', 'edukul'),
				'param_name' => 'translatey',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'edukul' ),
		  	),
        )
    ) );
} );

// Advanced Text
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Advanced Text', 'edukul' ),
        'description' => esc_html__('Displaying a text with some styles.', 'edukul'),
		'base'        => 'advtext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'DIV' => 'div'
				),
				'std'		=> 'h2',
			),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Content', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'edukul'),
				'param_name' => 'color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Max-Width', 'edukul'),
				'param_name' => 'max_width',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'edukul' ),
				'param_name' => 'font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'edukul' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'edukul'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'edukul'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Single Heading
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Single Heading', 'edukul' ),
        'description' => esc_html__('Displaying a single heading with some styles.', 'edukul'),
		'base'        => 'singleheading',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'edukul' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'edukul'),
				'param_name' => 'line_width',
				'value' => '40',
				'group' => esc_html__( 'Line', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'edukul'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Line', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'edukul'),
				'param_name' => 'line_color',
				'value' => '#ff9900',
				'group' => esc_html__( 'Line', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing Between', 'edukul'),
				'param_name' => 'heading_padding',
				'value' => '',
				'group' => esc_html__( 'Line', 'edukul' ),
				'description'	=> esc_html__('Spacing between the line and the text. Ex: 50px.', 'edukul'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Offset Top', 'edukul'),
				'param_name' => 'line_top',
				'value' => '',
				'group' => esc_html__( 'Line', 'edukul' ),
				'description'	=> esc_html__('Ex: 5px.', 'edukul'),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Letter Spacing', 'edukul'),
				'param_name' => 'heading_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
		)
	) );
} );

// Headings
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Headings', 'edukul' ),
        'description' => esc_html__('Displaying awesome heading styles.', 'edukul'),
		'base'        => 'headings',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'edukul' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'edukul'),
				'param_name' => 'heading_width',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'edukul' ),
				'param_name' => 'subheading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'edukul'),
				'param_name' => 'subheading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'edukul'),
				'param_name' => 'subheading_width',
				'value' => '',
            ),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Extra Content', 'edukul'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Extra Content', 'edukul' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Extra Content Max-Width', 'edukul'),
				'param_name' => 'content_width',
				'value' => '',
				'group' => esc_html__( 'Extra Content', 'edukul' ),
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'edukul' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator Position', 'edukul' ),
				'param_name' => 'sep_position',
				'value'      => array(
					'Top' => 'top',
					'Between Heading & Sub-Heading' => 'between',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'between',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => array( 'line', 'image' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'edukul'),
				'param_name' => 'line_width',
				'value' => '70',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'edukul'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Right Margin', 'edukul'),
				'param_name' => 'line_right_margin',
				'value' => '20',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'sep_position', 'value' => 'left' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'edukul'),
				'param_name' => 'line_color',
				'value' => '#ff9900',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'edukul'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'edukul' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size on Mobile', 'edukul'),
				'param_name' => 'heading_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'edukul'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'edukul' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'edukul' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'edukul'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'edukul'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Style', 'edukul' ),
				'param_name' => 'subheading_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'edukul'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Top Margin', 'edukul'),
				'param_name' => 'subheading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'edukul'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
		)
	) );
} );

// Animation Block
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_animationblock extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Animation Block', 'edukul'),
		'description' => esc_html__('Apply animations anywhere.', 'edukul'),
		'base' => 'animationblock',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'animationblock'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
         )
    ) );
} );

// Counter
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Counter', 'edukul' ),
        'description' => esc_html__('Displaying a counter.', 'edukul'),
		'base'        => 'counter',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
				'dependency' => array( 'element' => 'style', 'value' => array('style-1')  ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Left Width', 'edukul'),
				'param_name' => 'left_width',
				'value' => 50,
				'suffix' => '%',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3')  ),
		  	),
			array(
				'type' => 'number',
				'heading' => esc_html__('Right Width', 'edukul'),
				'param_name' => 'right_width',
				'value' => 50,
				'suffix' => '%',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3')  ),
		  	),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon3',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon3',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon3',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'edukul'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'edukul'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'edukul'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
			// Number
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number Tag', 'edukul' ),
				'param_name' => 'number_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Number', 'edukul' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Number', 'edukul' ),
				'param_name' => 'number',
				'group' => esc_html__( 'Number', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'edukul'),
				'param_name' => 'number_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'edukul' ),
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Rolling Time', 'edukul'),
				'param_name' => 'time',
				'value' => 5000,
				'suffix' => 'ms',
				'group' => esc_html__( 'Number', 'edukul' ),
		  	),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Prefix (Optional)', 'edukul' ),
				'param_name' => 'number_prefix',
				'group' => esc_html__( 'Number', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Color', 'edukul'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'edukul' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Suffix (Optional)', 'edukul' ),
				'param_name' => 'number_suffix',
				'group' => esc_html__( 'Number', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Color', 'edukul'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'edukul' ),
            ),
		  	// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'edukul' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'div',
				'group' => esc_html__( 'Heading', 'edukul' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading', 'edukul' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'edukul'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'edukul'),
				'param_name' => 'heading_max_width',
				'value' => '',
				'group' => esc_html__( 'Heading', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-3') ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number Settings', 'edukul'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'edukul' ),
				'param_name' => 'number_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'edukul' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'edukul'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size on Mobile', 'edukul'),
				'param_name' => 'number_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'edukul'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Letter Spacing', 'edukul'),
				'param_name' => 'number_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading Settings', 'edukul'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'edukul' ),
				'param_name' => 'heading_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'edukul' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'edukul'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'edukul'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Letter Spacing', 'edukul'),
				'param_name' => 'heading_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'edukul'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Margin', 'edukul'),
				'param_name' => 'icon_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Top Margin', 'edukul'),
				'param_name' => 'number_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Right Margin', 'edukul'),
				'param_name' => 'number_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Bottom Margin', 'edukul'),
				'param_name' => 'number_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'edukul'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'edukul'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
		)
	) );
} );

// Video Icon
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Video Icon', 'edukul' ),
        'description' => esc_html__('Displaying Icon with custom video popup.', 'edukul'),
		'base'        => 'videoicon',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'White' => 'white',
					'Accent' => 'accent',
					'Outline' => 'white2',
				),
				'std'		=> 'white',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'edukul' ),
				'param_name' => 'size',
				'value'      => array(
					'Big' => 'big',
					'Small' => 'small',
				),
				'std'		=> 'big',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'edukul'),
				'param_name' => 'video_url',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
		)
	) );
} );

// Simple Image
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Simple Image', 'edukul' ),
        'description' => esc_html__('Displaying a simple image with animation.', 'edukul'),
		'base'        => 'simpleimage',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
			),
            // Effect
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effect', 'edukul' ),
				'param_name' => 'effect',
				'value'      => array(
					'No Effect' => 'simple',
					'Reveal' => 'reveal',
					'Background' => 'background',
				),
				'std'		=> 'simple',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Reveal Direction', 'edukul' ),
				'param_name' => 'reveal_dir',
				'value'      => array(
					'Left - Right' => 'lr',
					'Right - Left' => 'rl',
					'Top - Bottom' => 'tb',
					'Bottom - Top' => 'bt',
				),
				'std'		=> 'lr',
				'dependency' => array( 'element' => 'effect', 'value' => 'reveal' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Reveal Background', 'edukul'),
				'param_name' => 'reveal_bg',
				'value' => '#dddddd',
				'dependency' => array( 'element' => 'effect', 'value' => 'reveal' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Background Position', 'edukul' ),
				'param_name' => 'bg_pos',
				'value'      => array(
					'Top' => 'top',
					'Right' => 'right',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'top',
				'dependency' => array( 'element' => 'effect', 'value' => 'background' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'edukul'),
				'param_name' => 'image_width',
				'value' => '',
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'edukul'),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Center Alignment', 'edukul' ),
				'param_name' => 'center_align',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'edukul'),
				'param_name' => 'url',
				'value' => '',
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Box Shadow
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
				'dependency' => array( 'element' => 'effect', 'value' => 'simple' ),
            ),
			// Video Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'White' => 'white',
					'Accent' => 'accent',
					'Outline' => 'white2',
				),
				'std'		=> 'white',
				'group' => esc_html__( 'Video Icon', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'edukul' ),
				'param_name' => 'icon_size',
				'value'      => array(
					'Big' => 'big',
					'Small' => 'small',
				),
				'std'		=> 'big',
				'group' => esc_html__( 'Video Icon', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'edukul'),
				'param_name' => 'video_url',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'edukul' ),
	        ),
			// Advanced
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Stretch', 'edukul' ),
				'param_name' => 'stretch',
				'value'      => array(
					'No Stretch' => '',
					'Stretch To Right' => 'stretch_right',
					'Stretch To Left' => 'stretch_left',
					'Stretch on Mobile' => 'stretch_mobi',
				),
				'std'		=> '',
				'group' => esc_html__( 'Advanced', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Offset Left', 'edukul'),
				'param_name' => 'offset_left',
				'value' => '-22vw',
				'group' => esc_html__( 'Advanced', 'edukul' ),
				'dependency' => array( 'element' => 'stretch', 'value' => 'stretch_left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Offset Right', 'edukul'),
				'param_name' => 'offset_right',
				'value' => '-22vw',
				'group' => esc_html__( 'Advanced', 'edukul' ),
				'dependency' => array( 'element' => 'stretch', 'value' => 'stretch_right' ),
	        ),
		)
	) );
} );

// Icons
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icons', 'edukul' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'edukul'),
		'base'        => 'icons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_fontawesome',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'edukul'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'edukul'),
				'param_name' => 'width',
				'value' => '60',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'edukul'),
				'param_name' => 'height',
				'value' => '60',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'edukul'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'edukul'),
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'edukul'),
				'param_name' => 'color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'border_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'edukul'),
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'edukul' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Design', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'edukul'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Design', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color: Hover', 'edukul'),
				'param_name' => 'color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'edukul'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'edukul'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'edukul' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'edukul' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
		)
	) );
} );

// Divider
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Divider', 'edukul'),
        'description' => esc_html__('Displaying lines separator.', 'edukul'),
        'base' => 'divider',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'divider-left',
					'Center' => 'divider-center',
					'Right' => 'divider-right',
				),
				'std'		=> 'divider-center',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'no-icon' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Width', 'edukul'),
				'param_name' => 'width',
				'value' => '',
				'description' => esc_html__( 'Default: 100%.', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Height', 'edukul'),
				'param_name' => 'height',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'edukul'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line: Color', 'edukul'),
				'param_name' => 'color',
				'value' => '',
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'edukul' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Font' => 'icon-font',
				),
				'std'		=> 'no-icon',
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'edukul'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'edukul'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Padding', 'edukul'),
				'param_name' => 'icon_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'description'	=> esc_html__('Top Right Bottom Left. Default: 0px 12px 0px 12px', 'edukul'),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'edukul'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Top Margin', 'edukul'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Bottom Margin', 'edukul'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
	        ),
        )
    ) );
} );

// Alignment Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_alignbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Alignment Box', 'edukul' ),
        'description' => esc_html__('Align elements.', 'edukul'),
		'base'        => 'alignbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'alignbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide on Mobile?', 'edukul' ),
				'param_name' => 'mobi_hide',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
		)
	) );
} );

// Featured Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_featuredbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Featured Box', 'edukul' ),
        'description' => esc_html__('Featured Box.', 'edukul'),
		'base'        => 'featuredbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'featuredbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Left Image' => 'style-1',
					'Right Image' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Height', 'edukul'),
				'param_name' => 'height',
				'value' => 570,
				'suffix' => 'px',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'edukul'),
            ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            // Image
	        array(
				'type' => 'number',
				'heading' => esc_html__('Image Width', 'edukul'),
				'param_name' => 'img_width',
				'value' => 50,
				'suffix' => '%',
				'group' => esc_html__( 'Image', 'edukul' ),
	        ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'edukul' ),
			),
			// Content
	        array(
				'type' => 'number',
				'heading' => esc_html__('Content Width', 'edukul'),
				'param_name' => 'content_width',
				'value' => 50,
				'suffix' => '%',
				'group' => esc_html__( 'Content', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'edukul' ),
				'param_name' => 'content_align',
				'value'      => array(
					'Top' => 'top',
					'Middle' => 'middle',
					'Bottom' => 'bottom',
				),
				'std'		=> 'top',
				'group' => esc_html__( 'Content', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'edukul'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'edukul'),
				'group' => esc_html__( 'Content', 'edukul' ),
	        ),
		)
	) );
} );

// Grid Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_gridbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Grid Box', 'edukul'),
		'description' => esc_html__('Grid Box.', 'edukul'),
		'base' => 'gridbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'gridbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Grid', 'edukul' ),
				'param_name' => 'grid',
				'value'      => array(
					'Grid 4' => '4',
					'Grid 3' => '3',
					'Grid 2' => '2',
				),
				'std'		=> '3',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Type?', 'edukul' ),
				'param_name' => 'border_type',
				'value' => array(
					'Separator' => 'separator',
					'Wrap' => 'wrap',
					'No Border' => 'no',
				),
				'std'		=> 'separator',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Color', 'edukul' ),
				'param_name' => 'border_color',
				'value' => array(
					'Light' => 'light',
					'Dark' => 'dark',
					'Very Light' => 'verylight',
				),
				'std'		=> 'light',
				'dependency' => array( 'element' => 'border_type', 'value' => array('separator', 'wrap') ),
			),
			array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gapv',
				'value'      => array(
					'0' => '0',
					'5' => '5',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
				),
				'std'		=> '30',
				'dependency' => array( 'element' => 'border_type', 'value' => 'no' ),
			),
			array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Spacing below items', 'edukul'),
				'param_name' => 'gaph',
				'value'      => array(
					'0' => '0',
					'5' => '5',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'60' => '60',
				),
				'std'		=> '15',
				'dependency' => array( 'element' => 'border_type', 'value' => 'no' ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Buttons
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Buttons', 'edukul'),
        'description' => esc_html__('Advanced Buttons.', 'edukul'),
        'base' => 'buttons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'edukul'),
				'param_name' => 'text',
				'value' => 'Button Text',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'edukul' ),
				'param_name' => 'size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'edukul'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'edukul'),
				'param_name' => 'background_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'edukul'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'edukul'),
				'param_name' => 'border_width',
				'value' => '1px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'edukul' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'edukul'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'edukul'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'edukul'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'edukul'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Full-width Button?', 'edukul' ),
				'param_name' => 'full_width',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'edukul'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'edukul'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'edukul'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Hover
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color: Hover', 'edukul'),
				'param_name' => 'text_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'edukul'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'edukul'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'edukul'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'edukul' ),
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'edukul' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'No Icon' => 'no_icon',
					'Icon Style 1' => 'icon_style_1',
					'Icon Style 2' => 'icon_style_2',
					'Custom Icon' => 'custom',
				),
				'std'		=> 'no_icon',
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'edukul' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'edukul' ),
				'value' => array(
					esc_html__( '', 'edukul' ) => '',
					esc_html__( 'Edukul Icons', 'edukul' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'edukul' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'edukul' ) => 'openiconic',
					esc_html__( 'Typicons', 'edukul' ) => 'typicons',
					esc_html__( 'Entypo', 'edukul' ) => 'entypo',
					esc_html__( 'Linecons', 'edukul' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'edukul' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'edukul' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'edukul' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'edukul'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'edukul'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'edukul' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-right',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'edukul'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'edukul'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Left Padding', 'edukul'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'edukul'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-right' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon: Offset', 'edukul' ),
				'param_name' => 'icon_offset',
				'value'      => array(
					'-15px' => '-15',
					'-14px' => '-14',
					'-13px' => '-13',
					'-12px' => '-12',
					'-11px' => '-11',
					'-10px' => '-10',
					'-9px' => '-9',
					'-8px' => '-8',
					'-7px' => '-7',
					'-6px' => '-6',
					'-5px' => '-5',
					'-4px' => '-4',
					'-3px' => '-3',
					'-2px' => '-2',
					'-1px' => '-1',
					'0px' => '0',
					'1px' => '1',
					'2px' => '2',
					'3px' => '3',
					'4px' => '4',
					'5px' => '5',
					'6px' => '6',
					'7px' => '7',
					'8px' => '8',
					'9px' => '9',
					'10px' => '10',
					'11px' => '11',
					'12px' => '12',
					'13px' => '13',
					'14px' => '14',
					'15px' => '15',
				),
				'std'		=> '0',
				'group' => esc_html__( 'Icon', 'edukul' ),
				'description'	=> esc_html__('Use this to change the distance middle the icon and top of button.', 'edukul'),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'edukul'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'edukul' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'edukul' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'edukul' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
			// Box Shadow
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'edukul'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'edukul' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'edukul'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'edukul'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'edukul'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'edukul'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'edukul'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'edukul' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'edukul' ),
				'param_name' => 'font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'edukul' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'edukul'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'edukul'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
        )
    ) );
} );

// Hero Section
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_hero extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Hero Section', 'edukul'),
        'description' => esc_html__('Hero Section.', 'edukul'),
        'base' => 'hero',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'hero'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hero Height', 'edukul' ),
				'param_name' => 'hero_height',
				'value'      => array(
					'Full Screen' => 'full-height',
					'Custom Height' => 'custom-height',
				),
				'std'		=> 'full-height',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Hero Custom Height', 'edukul'),
				'param_name' => 'hero_custom_height',
				'value' => '',
				'description'	=> esc_html__('Ex: 600px.', 'edukul'),
				'dependency' => array( 'element' => 'hero_height', 'value' => 'custom-height' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'edukul' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Background Slideshow' => 'slideshow',
					'Background Video' => 'video',
				),
				'std'		=> 'slideshow',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Background Images', 'edukul'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for background slideshow.', 'edukul'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effects', 'edukul' ),
				'param_name' => 'effect',
				'value'      => array(
					'fade' => 'fade',
					'fade2' => 'fade2',
					'slideLeft' => 'slideLeft',
					'slideLeft2' => 'slideLeft2',
					'slideRight' => 'slideRight',
					'slideRight2' => 'slideRight2',
					'slideUp' => 'slideUp',
					'slideDown' => 'slideDown',
					'slideDown2' => 'slideDown2',
					'zoomIn' => 'zoomIn',
					'zoomIn2' => 'zoomIn2',
					'zoomOut' => 'zoomOut',
					'zoomOut2' => 'zoomOut2',
					'swirlLeft' => 'swirlLeft',
					'swirlLeft2' => 'swirlLeft2',
					'swirlRight' => 'swirlRight',
					'swirlRight2' => 'swirlRight2',
					'burn' => 'burn',
					'burn2' => 'burn2',
					'blur' => 'blur',
					'blur2' => 'blur2',
					'flash' => 'flash',
					'flash2' => 'flash2'
				),
				'std'		=> 'fade',
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Youtube link (URL)', 'edukul'),
				'param_name' => 'video_link',
				'value' => '',
				'description' => esc_html__('Youtube link or ID. Ex: https://www.youtube.com/watch?v=vQqZIFCab9o', 'edukul'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'video' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Pattern Overlay', 'edukul' ),
				'param_name' => 'pattern_overlay',
				'value'      => array(
					'No Parttern' => '',
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
					'Style 6' => 'style-6',
					'Style 7' => 'style-7',
					'Style 8' => 'style-8',
					'Style 9' => 'style-9',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color Overlay', 'edukul'),
				'param_name' => 'color_overlay',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Top Margin', 'edukul'),
				'param_name' => 'content_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px. In case you want to set a spacing above the content area.', 'edukul'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Content area into Grid?', 'edukul' ),
				'param_name' => 'grid',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			// Arrow
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show arrow?', 'edukul' ),
				'param_name' => 'scroll',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
				'group' => esc_html__( 'Arrow', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'edukul' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Arrow', 'edukul' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Scroll to Row (ID)', 'edukul'),
				'param_name' => 'scroll_id',
				'value' => '',
				'description' => esc_html__('Enter the anchor ID you assigned to the element.', 'edukul'),
				'group' => esc_html__( 'Arrow', 'edukul' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Images Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Grid', 'edukul' ),
		'description' => esc_html__('Displaying images in masonry or mosaic grid.', 'edukul'),
		'base' => 'imagesgrid',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Layout', 'edukul' ),
				'param_name' => 'mode',
				'value'      => array(
					'Masonry' => 'grid',
					'Masonry' => 'mosaic',
				),
				'std'		=> 'grid',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'640 x 640' => 'square',
					'370 x 260' => 'rectangle',
					'370 x 570' => 'rectangle2',
				),
				'std'		=> 'square',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'edukul'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'edukul')
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Rounded', 'edukul'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gapv',
				'value' => '0',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'edukul'),
				'param_name' => 'gaph',
				'value' => '0',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px.', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Column Options', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px.', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Column Options', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px.', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Column Options', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px.', 'edukul' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Column Options', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// Images Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Carousel', 'edukul' ),
		'description' => esc_html__('Displaying images in carousel.', 'edukul'),
		'base' => 'imagescarousel',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'640 x 640' => 'square',
					'370 x 260' => 'rectangle',
					'370 x 570' => 'rectangle2',
				),
				'std'		=> 'full',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'edukul'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'edukul')
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Border?', 'edukul' ),
				'param_name' => 'show_borders',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'edukul' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'edukul'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// Scroll Target
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Scroll to ID Target', 'edukul' ),
        'description' => esc_html__('Displaying a arrow for scrolling down when clicked.', 'edukul'),
		'base'        => 'scrolltarget',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
		'params'      => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('ID Target', 'edukul'),
				'param_name' => 'id_target',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'edukul'),
				'param_name' => 'color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Size', 'edukul'),
				'param_name' => 'size',
				'value' => '',
	        ),
		)
	) );
} );

// Special Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Special Text', 'edukul'),
        'description' => esc_html__('Awesome Texts.', 'edukul'),
        'base' => 'specialtext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'Div' => 'div',
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'div',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 1 (Optional)', 'edukul' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 2 (Optional)', 'edukul' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 3 (Optional)', 'edukul' ),
				'param_name' => 'text3',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 1 Color', 'edukul'),
				'param_name' => 'color1',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 2 Color', 'edukul'),
				'param_name' => 'color2',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 3 Color', 'edukul'),
				'param_name' => 'color3',
				'value' => '',
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 1', 'edukul'),
				'param_name' => 'text1_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Family', 'edukul' ),
				'param_name' => 'text1_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Weight', 'edukul' ),
				'param_name' => 'text1_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Font Size', 'edukul'),
				'param_name' => 'text1_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Style', 'edukul' ),
				'param_name' => 'text1_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 2', 'edukul'),
				'param_name' => 'text2_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Family', 'edukul' ),
				'param_name' => 'text2_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Weight', 'edukul' ),
				'param_name' => 'text2_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Font Size', 'edukul'),
				'param_name' => 'text2_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Style', 'edukul' ),
				'param_name' => 'text2_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 3', 'edukul'),
				'param_name' => 'text3_typograpy',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Family', 'edukul' ),
				'param_name' => 'text3_font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Weight', 'edukul' ),
				'param_name' => 'text3_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 3: Font Size', 'edukul'),
				'param_name' => 'text3_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'edukul' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Style', 'edukul' ),
				'param_name' => 'text3_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			// Spacing
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Right Padding', 'edukul'),
				'param_name' => 'text1_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Right Padding', 'edukul'),
				'param_name' => 'text2_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'edukul' ),
            ),
        )
    ) );
} );

// Fancy Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Fancy Text', 'edukul'),
        'description' => esc_html__('Awesome Animation Text.', 'edukul'),
        'base' => 'fancytext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'edukul' ),
				'param_name' => 'animation',
				'value'      => array(
					'Scrolling' => 'scroll',
					'Typing' => 'typed',
				),
				'std'		=> 'scroll',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1 (Optional)', 'edukul' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2 (Optional)', 'edukul' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 3 (Optional)', 'edukul' ),
				'param_name' => 'text3',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 4 (Optional)', 'edukul' ),
				'param_name' => 'text4',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 5 (Optional)', 'edukul' ),
				'param_name' => 'text5',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix Text (Optional)', 'edukul' ),
				'param_name' => 'prefix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'edukul' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix Text (Optional)', 'edukul' ),
				'param_name' => 'suffix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'edukul' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'edukul'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Text Color', 'edukul'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'edukul' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Text Color', 'edukul'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'edukul' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'edukul' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'edukul' ),
				'param_name' => 'font_family',
				'value'      =>  edukul_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'edukul' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'edukul' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Max', 'edukul' ),
				'param_name' => 'font_max',
				'value' => 70,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'edukul' ),
				'description'	=> esc_html__('Important! This size only appear exactly on the full-width grid, 65px max-size on the 1170 grid and 32px max-size on the 570px grid.', 'edukul'),
		  	),
		  	array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Min', 'edukul' ),
				'param_name' => 'font_min',
				'value' => 22,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'edukul' ),
		  	),
        )
    ) );
} );

// Partner Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Partner Carousel', 'edukul'),
	    'description' => esc_html__('Displaying partner posts in carousel.', 'edukul'),
	    'base' => 'partners',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Border?', 'edukul' ),
				'param_name' => 'show_border',
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gap',
				'value' => '10',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'edukul' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'edukul'),
			),
			// Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'edukul'),
				'param_name' => 'items',
				'value' => '5',
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'edukul'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Only show posts from specific category-slug (optional).', 'edukul'),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
	    )
	) );
} );

// Subscribe Form
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Subscribe Form', 'edukul'),
        'description' => esc_html__('Displaying mailchimp newsletter form.', 'edukul'),
        'base' => 'subscribe',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Max-Width', 'edukul'),
				'param_name' => 'width',
				'value' => '',
            ),
        )
    ) );
} );

// Google Maps
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Google Maps', 'edukul'),
        'description' => esc_html__('Displaying Google Maps.', 'edukul'),
        'base' => 'googlemap',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Latitude', 'edukul' ),
				'param_name'  => 'lat',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'edukul').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'edukul'),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Longitude', 'edukul' ),
				'param_name'  => 'lng',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'edukul').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'edukul'),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Width', 'edukul' ),
				'param_name' => 'width',
				'value'      => ''
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Height', 'edukul' ),
				'param_name' => 'height',
				'value'      => 300
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Zoom Level', 'edukul' ),
				'param_name'  => 'zoom',
				'description' => esc_html__( 'Select the default zoom level for the Maps', 'edukul' ),
				'value'       => array_combine( range( 1, 24 ), range( 1, 24 ) ),
				'std'		  => '14'
			),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Mobile' ),
                'param_name' => 'drag_mobile',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Desktop' ),
                'param_name' => 'drag_desktop',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Show The Marker', 'edukul' ),
				'param_name'  => 'marker_type',
				'value'       => array(
					'Simple'          => 'simple',
					'Custom Image' => 'image',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Maker', 'edukul' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'edukul'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Maker', 'edukul' ),
				'dependency' => array( 'element' => 'marker_type', 'value' => 'image' ),
			),
        )
    ) );
} );

// Products Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Products Carousel', 'edukul'),
        'description' => esc_html__('Displaying products in carousel.', 'edukul'),
        'base' => 'dproducts',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'edukul'),
				'param_name' => 'number',
				'value' => '4',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'edukul'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Countdown
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('CountDown', 'edukul'),
        'description' => esc_html__('Displaying Countdown Timer.', 'edukul'),
        'base' => 'countdown',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Time', 'edukul' ),
				'param_name' => 'time',
				'value' => 'December 30, 2020 8:30:00'
			),
        )
    ) );
} );

// Courses Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Courses Carousel', 'edukul'),
        'description' => esc_html__('Displaying course posts in carousel.', 'edukul'),
        'base' => 'courses',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Background', 'edukul' ),
				'param_name' => 'content_bg',
				'value'      => array(
					'Gray' => 'gray',
					'White' => 'white',
				),
				'std'		=> 'gray',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3') ),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Get Course By", 'edukul'),
				"param_name" => "course_type",
				'value' 	=> array(
					esc_html__('Lastest Courses', 'edukul') => 'most_recent', 
					esc_html__('Random Courses', 'edukul') => 'random', 
				)
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Number', 'edukul' ),
				'param_name' => 'items',
				'value' => 4
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Courses Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Courses Grid', 'edukul'),
        'description' => esc_html__('Displaying course posts in grids.', 'edukul'),
        'base' => 'coursesgrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gapv',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'edukul'),
				'param_name' => 'gaph',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Background', 'edukul' ),
				'param_name' => 'content_bg',
				'value'      => array(
					'Gray' => 'gray',
					'White' => 'white',
				),
				'std'		=> 'gray',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3') ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'edukul' ),
				'param_name' => 'show_filter',
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
            // Query
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Get Course By", 'edukul'),
				"param_name" => "course_type",
				'value' 	=> array(
					esc_html__('Lastest Courses', 'edukul') => 'most_recent', 
					esc_html__('Random Courses', 'edukul') => 'random', 
				)
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'edukul'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'edukul' ),
				'value' => '8',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'edukul' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Event Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Events Carousel', 'edukul'),
        'description' => esc_html__('Displaying event posts in carousel.', 'edukul'),
        'base' => 'events',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Option', 'edukul' ),
				'param_name' => 'image_option',
				'value'      => array(
					'Post Thumbnail' => 'default',
					'Metabox Thumbnail' => 'custom',
				),
				'std'		=> 'default',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'740 x 740' => 'square',
					'740 x 600' => 'rectangle4',
					'740 x 500' => 'rectangle',
					'570 x 350' => 'rectangle2',
					'570 x 730' => 'rectangle3',
				),
				'std'		=> 'rectangle',
				'dependency' => array( 'element' => 'image_option', 'value' => 'default' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'edukul'),
				'param_name' => 'items',
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'edukul'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'edukul'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Events Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Events Grid', 'edukul'),
        'description' => esc_html__('Displaying event posts in grids.', 'edukul'),
        'base' => 'eventsgrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Option', 'edukul' ),
				'param_name' => 'image_option',
				'value'      => array(
					'Post Thumbnail' => 'default',
					'Metabox Thumbnail' => 'custom',
				),
				'std'		=> 'default',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'edukul' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'740 x 740' => 'square',
					'740 x 600' => 'rectangle4',
					'740 x 500' => 'rectangle',
					'570 x 350' => 'rectangle2',
					'570 x 730' => 'rectangle3',
				),
				'std'		=> 'rectangle',
				'dependency' => array( 'element' => 'image_option', 'value' => 'default' ),
			),
            // Query
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'edukul'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'edukul' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'edukul'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'edukul' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'edukul'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'edukul'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'edukul'),
				'group' => esc_html__( 'Query', 'edukul' ),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'edukul' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'edukul' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
        )
    ) );
} );

// Courses Search Form
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Courses Search Form', 'edukul'),
        'description' => esc_html__('Displaying course search form.', 'edukul'),
        'base' => 'coursessearch',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Light' => 'light',
					'Dark' => 'dark',
				),
				'std'		=> 'dark',
			),
        )
    ) );
} );

// Lecturers Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Lecturers', 'edukul'),
	    'description' => esc_html__('Displaying lecturers in carousel.', 'edukul'),
	    'base' => 'lecturer',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'edukul'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'edukul'),
				'param_name' => 'items',
				'value' => '4',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gap',
				'value' => '30',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'edukul' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'edukul' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'edukul'),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'edukul'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'edukul' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullet Color', 'edukul' ),
				'param_name' => 'bullet_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'edukul' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'100px' => '100',
					'95px' => '95',
					'90px' => '90',
					'85px' => '85',
					'80px' => '80',
					'75px' => '75',
					'70px' => '70',
					'65px' => '65',
					'60px' => '60',
					'55px' => '55',
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'edukul'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'edukul' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'edukul' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array( esc_html__( 'Yes, please.', 'edukul' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Color', 'edukul' ),
				'param_name' => 'arrow_color',
				'value'      => array(
					'Accent' => '',
					'White' => 'white',
				),
				'std'		=> '',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'edukul' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'edukul' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'0' => '0',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'edukul' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'edukul' ),
				'value'      => array(
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
	    )
	) );
} );

// Lecturers Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Lecturers Grid', 'edukul'),
        'description' => esc_html__('Displaying lecturers in grid.', 'edukul'),
        'base' => 'lecturergrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'edukul'),
				'param_name' => 'gapv',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'edukul'),
				'param_name' => 'gaph',
				'value' => '30',
				'description'	=> esc_html__('Ex: 30', 'edukul'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'edukul'),
				'param_name' => 'items',
				'value' => '8',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'edukul' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'edukul' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'edukul' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'edukul' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'edukul' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Membership
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Membership', 'edukul'),
        'description' => esc_html__('Membership.', 'edukul'),
        'base' => 'coursemembership',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'edukul'),
        'params' => array(
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Choose a membership", 'edukul'),
				"param_name" => "plan_name",
				'value' 	=> edukul_educator_get_memberships()
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'edukul' ),
				'param_name' => 'style',
				'value'      => array(
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'dark',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'edukul' ),
				'param_name' => 'align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background', 'edukul'),
				'param_name' => 'background',
				'value' => '#f7f7f7',
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'edukul'),
				'param_name' => 'bg_image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding.', 'edukul'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 65px 70px 65px 70px', 'edukul'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'edukul' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Style 1' => 'accent',
					'Style 2' => 'altcolor',
					'Style 3' => 'white',
				),
				'std'		=> 'accent',
			),
        )
    ) );
} );