<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
	'show_border' => '',
	'auto_scroll' => 'false',
	'loop' => 'false',
	'items'		=> '5',
	'cat_slug' => '',
	'gap'		=> '10',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c'
), $atts ) );

$gap = intval( $gap );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( empty( $items ) ) return;

if ( $show_arrows ) {
	$cls .= ' has-arrows' .' arrow-'. $arrow_color;
	if ( $arrow_position == 'center' ) {
	    $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
	} else {
	    $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
	}
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

$query_args = array(
    'post_type' => 'partner',
    'posts_per_page' => $items
);

if ( ! empty( $cat_slug ) ) {
	$query_args['tax_query'] = array(
		array(
			'taxonomy' => 'partner_category',
			'field'    => 'slug',
			'terms'    => $cat_slug
		),
	);
}

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { echo "Partner post not found!"; return; }
ob_start(); ?>

<div class="edukul-partner <?php echo esc_attr( $cls ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-loop="<?php echo esc_attr( $loop ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>">
<?php if ( $query->have_posts() ) : ?>
	<?php wp_enqueue_script( 'edukul-owlcarousel' ); ?>

	<div class="owl-carousel owl-theme">
	    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
        	<div class="partner-item clearfix">
        		<div class="inner">
		            <?php if ( has_post_thumbnail() ) : ?>
		            	<a target="_blank" href="<?php echo esc_html( edukul_metabox( 'partner_hyperlink' ) ); ?>">
	    				<div class="thumb">
		    				<?php echo get_the_post_thumbnail( get_the_ID(), 'full' ); ?>
	    				</div>
	    				</a>
	         		<?php endif; ?>
        		</div>
            </div>
		<?php endwhile; ?>
	</div><!-- /.owl-carousel -->

<?php endif; ?>
<?php wp_reset_postdata(); ?>
</div><!-- /.edukul-partner -->

<?php
$return = ob_get_clean();
echo $return;