<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = $inner_css = '';

extract( shortcode_atts( array(
	'items'			=> '8',
	'gapv'			=> '30',
	'gaph'			=> '30',
	'column'		=> '4c',
	'column2'		=> '3c',
	'column3'		=> '2c',
	'column4'		=> '1c'
), $atts ) );

$gapv = intval( $gapv );
$gaph = intval( $gaph );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );
$column4 = intval( $column4 );

if ( empty( $items ) ) return;

if ( empty( $gapv ) ) $gapv = 0;
if ( empty( $gaph ) ) $gaph = 0;

$roles = array( 'lecturer' );
$users = get_users( array( 'role__in' => $roles, 'number' => $items ) );

if ( ! empty( $users ) ) { ?>
	<?php wp_enqueue_script( 'edukul-cubeportfolio' ); ?>

	<div class="edukul-lecturers-grid" data-layout="grid" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-column4="<?php echo esc_attr( $column4 ); ?>" data-gaph="<?php echo esc_attr( $gaph ); ?>" data-gapv="<?php echo esc_attr( $gapv ); ?>">

		<div id="lecturers" class="cbp">

		    <?php 
		    foreach ( $users as $user ) {
		    	$author_id = $user->ID;
		    	?>
				<div class="member-item cbp-item clearfix">
					<div class="inner">
				        <div class="thumb">
							<?php echo get_avatar( $author_id, 370); ?>			
						</div><!-- /.thumb -->
				 		
				 	    <div class="text-wrap">
					        <h4 class="name">
								<?php
								if ( $url = get_the_author_meta( 'user_singlebio', $author_id ) ) {
									echo '<a href="'. esc_url( $url ) .'">'. get_the_author_meta('display_name', $author_id ) .'</a>';
								} else {
									echo get_the_author_meta('display_name', $author_id );
								}
								?>
					        </h4>
					        
					        <div class="position"><?php echo get_the_author_meta( 'user_position', $author_id ); ?></div>

				            <ul class="socials clearfix">
				                <?php if ( $url = get_the_author_meta( 'user_twitter', $author_id ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Twitter', 'edukul' ); ?>">
				                        <i class="core-icon-twitter"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_facebook', $author_id ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Facebook', 'edukul' ); ?>">
				                        <i class="core-icon-facebook"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_instagram', $author_id ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Instagram', 'edukul' ); ?>">
				                        <i class="core-icon-instagram"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_youtube', $author_id ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Youtube', 'edukul' ); ?>">
				                        <i class="core-icon-youtube"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_tumblr' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Tumblr', 'edukul' ); ?>">
				                        <i class="core-icon-tumblr"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_pinterest' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Pinterest', 'edukul' ); ?>">
				                        <i class="core-icon-pinterest"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_behance' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Behance', 'edukul' ); ?>">
				                        <i class="core-icon-behance"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_linkedin' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Linkedin', 'edukul' ); ?>">
				                        <i class="core-icon-linkedin"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_dribbble' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Dribbble', 'edukul' ); ?>">
				                        <i class="core-icon-dribbble"></i>
				                    </a></li>
				                <?php endif; ?>

				                <?php if ( $url = get_the_author_meta( 'user_vimeo' ) ) : ?>
				                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Vimeo', 'edukul' ); ?>">
				                        <i class="core-icon-vimeo"></i>
				                    </a></li>
				                <?php endif; ?>
				            </ul>
					    </div>
				    </div><!-- /.inner -->
				</div>
			<?php } ?>

		</div><!-- /#lecturers -->

	</div><!-- /.edukul-lecturers-grid -->
<?php }