<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$html = '';
$cls = '';

extract( shortcode_atts( array(
    'image_crop' => 'full',
    'images'    => '',
    'show_borders' => '',
    'auto_scroll' => 'false',
    'loop' => 'false',
    'gap' => '30',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c'
), $atts ) );

$gap = intval( $gap );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( $show_arrows ) {
    $cls .= ' has-arrows' .' arrow-'. $arrow_color;
    if ( $arrow_position == 'center' ) {
        $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
    } else {
        $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
    }
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

if ( ! empty( $images ) ) {
    wp_enqueue_script( 'edukul-owlcarousel' );
    $images = explode( ',', trim( $images ) );

    $html  .= '<div class="edukul-images-carousel '. $cls .'" data-auto="'. $auto_scroll .'" data-loop="'. $loop .'" data-gap="'. $gap .'" data-column="'. $column .'" data-column2="'. $column2 .'" data-column3="'. $column3 .'">
        <div class="owl-carousel owl-theme">';

    for ( $i=0; $i<count( $images ); $i++ ) {
        $img_size = 'full';
        if ( $image_crop == 'square' ) $img_size = 'edukul-square';
        if ( $image_crop == 'rectangle' ) $img_size = 'edukul-rectangle';

        $img_b = wp_get_attachment_image_src( $images[$i], $img_size );
        $img_f = wp_get_attachment_image_src( $images[$i], 'full' );

        $html .= sprintf(
            '<div class="item-wrap"><a class="zoom-popup popup-image" href="%2$s"></a><img src="%1$s" alt="Image"></div>',
            $img_b[0],
            $img_f[0]
        );
    }

    $html .= '</div></div>';
}

echo $html;