<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$filter_css = $filter_wrap_css  = $filter_data = '';

extract( shortcode_atts( array(
	'style' => 'style-1',
	'image_option' => 'default',
	'image_crop' => 'square',
	'items'			=> '8',
	'cat_slug'	=> '',
	'exclude_cat_slug' => '',
	'pagination' => 'false'
), $atts ) );

$items = intval( $items );

if ( empty( $items ) ) return;

if ( get_query_var('paged') ) {
   $paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
   $paged = get_query_var('page');
} else {
   $paged = 1;
}

$query_args = array(
    'post_type' => 'event',
    'posts_per_page' => $items,
    'paged'     => $paged
);

if ( ! empty( $cat_slug ) ) {
	$query_args['tax_query'] = array(
		array(
			'taxonomy' => 'event_category',
			'field'    => 'slug',
			'terms'    => $cat_slug
		),
	);
}

if ( ! empty( $exclude_cat_slug ) ) {
	$query_args['tax_query'] = array(
	    array(
	        'taxonomy' => 'event_category',
	        'field' => 'slug',
	        'terms' => $exclude_cat_slug,
	        'operator' => 'NOT IN',
	    ),
	);
}

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { echo "Event item not found!"; return; }
ob_start(); ?>

<div class="edukul-events-grid clearfix">

	<?php if ( $query->have_posts() ) : ?>

		
		    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
		    	<div class="event-wrap">
					<div class="event-box <?php echo esc_attr( $style ); ?>">
						<?php
						$img_size = $thumb_html = $title = $title_html = $desc_html = $time_html = '';

						if ( $image_option == 'default' ) {
							if ( has_post_thumbnail() ) {
								if ( $image_crop == 'full' ) $img_size = 'full';
								if ( $image_crop == 'square' ) $img_size = 'edukul-square';
								if ( $image_crop == 'rectangle' ) $img_size = 'edukul-rectangle';
								if ( $image_crop == 'rectangle2' ) $img_size = 'edukul-rectangle2';
								if ( $image_crop == 'rectangle3' ) $img_size = 'edukul-rectangle3';
								if ( $image_crop == 'rectangle4' ) $img_size = 'edukul-rectangle4';

								$thumb_html = get_the_post_thumbnail( get_the_ID(), $img_size );
							}
						} else {
							$size = 'edukul-'. edukul_metabox('event_image_crop');
							$image = edukul_metabox( 'event_image', array( 'size' => $size ) );

							if ( $image ) $thumb_html = '<img src="'. $image['url'] .'" alt="Image" />';
						}

						$title = edukul_metabox( 'title' ) ? edukul_metabox( 'event_title' ) : get_the_title();
		            	$title_html = sprintf('<h4 class="title"><a href="%1$s" title="%2$s">%2$s</a></h4>', esc_url( get_the_permalink() ), esc_attr( $title ) );
		            	$desc_html = sprintf('<div class="desc">%1$s</div>', esc_html( edukul_metabox( 'event_desc' ) ) );
		            	$meta_html = sprintf('<div class="meta"><span class="date">%1$s</span><span class="time">%2$s</span></div>', esc_html( edukul_metabox( 'event_date' ) ), esc_html( edukul_metabox( 'event_time' ) ) );

		            	if ( $style == 'style-1' )
							echo '<div class="thumb">'. $thumb_html .'<div class="text-wrap">'. $meta_html . $title_html .'</div><a class="arrow" href="'. esc_url( get_the_permalink() ) .'"><span class="eduk-long-arrow-right"></span></a></div>';

						if ( $style == 'style-2' )
							echo '<div class="thumb">'. $thumb_html .'</div><div class="text-wrap">'. $title_html . $desc_html . $meta_html .'<div class="link"><a class="edukul-links link-style-5 dark" href="'. esc_url( get_the_permalink() ) .'"><span class="text">'. esc_html__( 'LEARN MORE', 'edukul' ) .'</span></a></div></div>';
						?>
					</div><!-- /.event-box -->
				</div>
			<?php endwhile; ?>
		

		<?php if ( 'true' == $pagination ) {
			echo '<div class="event-nav">';
			edukul_pagination($query);
			echo '</div>';
		}
		?>
	<?php endif; ?>

	<?php wp_reset_postdata(); ?>

</div><!-- /.edukul-event -->

<?php
$return = ob_get_clean();
echo $return;