<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
	'style' => 'style-1',
	'image_option' => 'default',
	'image_crop' => 'rectangle',
	'items'			=> '8',
	'gap'			=> '30',
	'cat_slug'	=> '',
	'exclude_cat_slug' => '',
	'auto_scroll' => 'false',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c'
), $atts ) );

$gap = intval( $gap );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( empty( $items ) ) return;

if ( $show_arrows ) {
	$cls .= ' has-arrows' .' arrow-'. $arrow_color;
	if ( $arrow_position == 'center' ) {
	    $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
	} else {
	    $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
	}
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

$query_args = array(
    'post_type' => 'event',
    'posts_per_page' => $items
);

if ( ! empty( $cat_slug ) ) {
	$query_args['tax_query'] = array(
		array(
			'taxonomy' => 'event_category',
			'field'    => 'slug',
			'terms'    => $cat_slug,
		),
	);
}

if ( ! empty( $exclude_cat_slug ) ) {
	$query_args['tax_query'] = array(
	    array(
	        'taxonomy' => 'event_category',
	        'field' => 'slug',
	        'terms' => $exclude_cat_slug,
	        'operator' => 'NOT IN',
	    ),
	);
}

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { echo "Project item not found!"; return; }
ob_start(); ?>

<div class="edukul-events <?php echo esc_attr( $cls ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>">

<?php if ( $query->have_posts() ) : ?>
	<?php wp_enqueue_script( 'edukul-owlcarousel' ); ?>

	<div class="owl-carousel owl-theme">
	    <?php while ( $query->have_posts() ) : $query->the_post(); global $post; ?>
			<div class="event-box <?php echo esc_attr( $style ); ?>">
				<?php
				$img_size = $thumb_html = $title = $title_html = $desc_html = $time_html = '';

				if ( $image_option == 'default' ) {
					if ( has_post_thumbnail() ) {
						if ( $image_crop == 'full' ) $img_size = 'full';
						if ( $image_crop == 'square' ) $img_size = 'edukul-square';
						if ( $image_crop == 'rectangle' ) $img_size = 'edukul-rectangle';
						if ( $image_crop == 'rectangle2' ) $img_size = 'edukul-rectangle2';
						if ( $image_crop == 'rectangle3' ) $img_size = 'edukul-rectangle3';
						if ( $image_crop == 'rectangle4' ) $img_size = 'edukul-rectangle4';

						$thumb_html = get_the_post_thumbnail( get_the_ID(), $img_size );
					}
				} else {
					$size = 'edukul-'. edukul_metabox('event_image_crop');
					$image = edukul_metabox( 'event_image', array( 'size' => $size ) );

					if ( $image ) $thumb_html = '<img src="'. $image['url'] .'" alt="Image" />';
				}

				$title = edukul_metabox( 'title' ) ? edukul_metabox( 'event_title' ) : get_the_title();
            	$title_html = sprintf('<h4 class="title"><a href="%1$s" title="%2$s">%2$s</a></h4>', esc_url( get_the_permalink() ), esc_attr( $title ) );
            	$desc_html = sprintf('<div class="desc">%1$s</div>', esc_html( edukul_metabox( 'event_desc' ) ) );
            	$meta_html = sprintf('<div class="meta"><span class="date">%1$s</span><span class="time">%2$s</span></div>', esc_html( edukul_metabox( 'event_date' ) ), esc_html( edukul_metabox( 'event_time' ) ) );

				echo '<div class="thumb">'. $thumb_html .'</div>'. $title_html . $desc_html . $meta_html .'<div class="link"><a href="'. esc_url( get_the_permalink() ) .'"><span>'. esc_html__( 'Learn More', 'edukul' ) .'</span></a></div>';
				?>
			</div><!-- /.event-box -->
		<?php endwhile; ?>
	</div><!-- /.owl-carousel -->

<?php endif; ?>
<?php wp_reset_postdata(); ?>

</div><!-- /.edukul-events -->

<?php
$return = ob_get_clean();
echo $return;