<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
	'style' => 'dark',
), $atts ) );

if ( $style == 'light' ) $cls .= ' light-form';

?>
<div class="edukul-courses-search-form">
	<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
		<div class="clearfix">
			<div class="keyword-wrap">
				<!-- keyword -->
				<input type="text" class="input_search form-control <?php esc_attr_e( $cls ); ?>" name="s" value="" placeholder="<?php esc_html_e('Enter Keyword...', 'edukul'); ?>"/>
			</div>

			<div class="submit-wrap">
				<button type="submit">					
					<span><?php esc_html_e('Search Course', 'edukul'); ?></span>
				</button>
			</div>
		</div>
		<input type="hidden" name="post_type" value="<?php echo defined('EDR_PT_COURSE') ? EDR_PT_COURSE : ''; ?>" class="post_type" />
	</form>
</div>