<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
	'style' => 'style-1',
	'gapv'			=> '30',
	'gaph'			=> '30',
	'content_bg' => 'gray',
	'show_filter'	=> 'false',
	'course_type' => 'most_recent',
	'items'			=> '8',
	'column'		=> '3c',
	'column2'		=> '3c',
	'column3'		=> '2c',
	'column4'		=> '1c'
), $atts ) );

if ( get_query_var('paged') ) {
   $paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
   $paged = get_query_var('page');
} else {
   $paged = 1;
}

$loop = edukul_educator_get_courses( $course_type, $items );

$cls = $style .' '. $content_bg;
$filter_css = $filter_wrap_css  = $filter_data = '';
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );
$column4 = intval( $column4 ); ?>

<div class="edukul-courses-grid <?php echo esc_attr( $cls ); ?>" data-layout="masonry" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-column4="<?php echo esc_attr( $column4 ); ?>" data-gaph="<?php echo esc_attr( $gaph ); ?>" data-gapv="<?php echo esc_attr( $gapv ); ?>">
	<?php
	if ( $show_filter == 'true' ) {
        echo '<div id="course-filter" style="'. $filter_wrap_css .'" class="cbp-l-filters-alignCenter clearfix"><div class="inner">';

    		echo '<div data-filter="*" class="cbp-filter-item button-all"><span>All</span><div class="cbp-filter-counter"></div></div>';

				$terms = get_terms('edr_course_category');
			    foreach ( $terms as $term ) {
			        echo '<div data-filter=".'. esc_attr( $term->slug ) .'" class="cbp-filter-item" title="'. esc_attr( $term->name ) .'" style="'. $filter_css .'"><span>'. $term->name . '</span><div class="cbp-filter-counter"></div></div>';
				}
        echo '</div></div>';
    } ?>
	<div id="courses" class="cbp">
		<?php if ( $loop->have_posts() ) : ?>
			<?php 
			wp_enqueue_script( 'edukul-cubeportfolio' ); 

















			?>
				<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
						<?php Edr_View::template_part( 'content', 'course' ); ?>
				<?php endwhile; ?>

				<?php wp_reset_postdata(); ?>
		<?php endif; ?>
	</div><!-- /#courses -->
</div><!-- /.edukul-courses-grid -->
