<?php 
/*
Plugin Name: WPRT Addons for Edukul
Plugin URI: https://ninzio.com/
Description: Extend WPBakery with Advanced Shortcodes.
Version: 1.0
Author: Ninzio Themes
Author URI: https://ninzio.com/
*/

/**
 * Plugin Name: NinzioFramework
 * Description: Open Setting, Post Type, Shortcode ... for theme 
 * Version: 1.0
 * Author: Ninzio Themes
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Enqueue scripts
add_action( 'wp_enqueue_scripts', 'loadCssAndJs', 999999 );
function loadCssAndJs() {
	wp_enqueue_style( 'edukul-owlcarousel', plugins_url('assets/owl.carousel.css', __FILE__), array(), '2.2.1' );
	wp_register_script( 'edukul-owlcarousel', plugins_url('assets/owl.carousel.min.js', __FILE__), array('jquery'), '2.2.1', true );
	wp_enqueue_style( 'slick', plugins_url('assets/slick.css', __FILE__), array(), '1.6.0' );
	wp_register_script( 'slick', plugins_url('assets/slick.js', __FILE__), array('jquery'), '1.6.0', true );
	wp_enqueue_script( 'edukul-imagesloaded', plugins_url('assets/imagesloaded.js', __FILE__), array('jquery'), '4.1.3', true );
	wp_enqueue_style( 'edukul-cubeportfolio', plugins_url('assets/cubeportfolio.min.css', __FILE__), array(), '3.4.0' );
	wp_register_script( 'edukul-cubeportfolio', plugins_url('assets/cubeportfolio.min.js', __FILE__), array('jquery'), '3.4.0', true );
	wp_register_script( 'edukul-countto', plugins_url('assets/countto.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'edukul-equalize', plugins_url('assets/equalize.min.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_style( 'edukul-magnificpopup', plugins_url('assets/magnific.popup.css', __FILE__), array(), '1.0.0' );
	wp_enqueue_script( 'edukul-magnificpopup', plugins_url('assets/magnific.popup.min.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_style( 'edukul-vegas', plugins_url('assets/vegas.css', __FILE__), array(), '2.3.1' );
	wp_register_script( 'edukul-vegas', plugins_url('assets/vegas.js', __FILE__), array('jquery'), '2.3.1', true );
	wp_enqueue_style( 'edukul-ytplayer', plugins_url('assets/ytplayer.css', __FILE__), array(), '3.0.2' );
	wp_register_script( 'edukul-ytplayer', plugins_url('assets/ytplayer.js', __FILE__), array('jquery'), '3.0.2', true );
	wp_register_script( 'edukul-fittext', plugins_url('assets/fittext.js', __FILE__), array('jquery'), '1.1.0', true );
	wp_register_script( 'edukul-flowtype', plugins_url('assets/flowtype.js', __FILE__), array('jquery'), '1.3.0', true );
	wp_register_script( 'edukul-typed', plugins_url('assets/typed.js', __FILE__), array('jquery'), '1.1.0', true );
	wp_register_script( 'edukul-countdown', plugins_url('assets/countdown.js', __FILE__), array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'edukul-appear', plugins_url('assets/appear.js', __FILE__), array('jquery'), '0.3.6', true );
	wp_enqueue_script( 'edukul-wow', plugins_url('assets/wow.min.js', __FILE__), array('jquery'), '0.3.6', true );
	wp_enqueue_script( 'edukul-anime', plugins_url('assets/anime.js', __FILE__), array('jquery'), '0.1.0', true );
	wp_enqueue_script( 'edukul-reveal', plugins_url('assets/reveal.js', __FILE__), array('jquery'), '0.1.0', true );
	wp_enqueue_script( 'edukul-parallaxscroll', plugins_url('assets/parallax-scroll.js', __FILE__), array('jquery'), '0.2.6', true );
	wp_enqueue_script( 'edukul-progressbar', plugins_url('assets/progressbar.min.js', __FILE__), array('jquery'), '0.9.0', true );
	wp_enqueue_script( 'edukul-shortcode', plugins_url('assets/shortcodes.js', __FILE__), array('jquery'), '1.0', true );
	wp_enqueue_script('google-maps-api', 'https://maps.googleapis.com/maps/api/js', array(), 'v3');
}

// Add image sizes
add_action( 'after_setup_theme', 'add_image_sizes' );
function add_image_sizes() {
	add_image_size( 'edukul-square', 740, 740, true );
	add_image_size( 'edukul-square2', 500, 500, true );
	add_image_size( 'edukul-rectangle', 740, 500, true );
	add_image_size( 'edukul-rectangle2', 570, 350, true );
	add_image_size( 'edukul-rectangle3', 570, 730, true );
	add_image_size( 'edukul-rectangle4', 740, 600, true );
}

// Map shortcodes to Visual Composer
require_once __DIR__ . '/vc-map.php';

// Include shortcodes files for Visual Composer
foreach ( glob( plugin_dir_path( __FILE__ ) . '/shortcodes/*.php' ) as $file ) {
	$filename = basename( $file );
	$tagname  = str_replace( '-', '_', pathinfo( $file, PATHINFO_FILENAME ) );

	add_shortcode( $tagname, function( $atts, $content = '' ) use( $file, $filename ) {
		ob_start();
		include $file;
		return ob_get_clean();
	} );
}

// Add user contact methods
function edukul_socials_user_contact_methods() {
	$user_contact['user_singlebio']  = esc_html( 'Biographical URL' );
	$user_contact['user_position']  = esc_html( 'Position' );
	$user_contact['user_twitter'] = esc_html( 'Twitter URL' );
	$user_contact['user_facebook']   = esc_html( 'Facebook URL' );
	$user_contact['user_instagram'] = esc_html( 'Instagram URL' );
	$user_contact['user_youtube'] = esc_html( 'Youtube URL' );
	$user_contact['user_tumblr'] = esc_html( 'Tumblr URL' );
	$user_contact['user_pinterest'] = esc_html( 'Pinterest URL' );
	$user_contact['user_behance'] = esc_html( 'Behance URL' );
	$user_contact['user_linkedin'] = esc_html( 'LinkedIn URL' );
	$user_contact['user_dribbble'] = esc_html( 'Dribbble URL' );
	$user_contact['user_vimeo'] = esc_html( 'Vimeo URL' );

	return $user_contact;
}
add_filter( 'user_contactmethods', 'edukul_socials_user_contact_methods' );

// Enable shortcode in text-widget and contact form 7
add_action( 'after_setup_theme', function() {
	if ( ! has_filter( 'widget_text', 'do_shortcode' ) ) {
		add_filter( 'widget_text', 'do_shortcode' );
	}

	if ( ! has_filter( 'wpcf7_form_elements', 'do_shortcode' ) ) {
		add_filter( 'wpcf7_form_elements', 'do_shortcode' );
	}
});

// Google API
require_once __DIR__ . '/google-api.php';

// Custom Post Type
require_once __DIR__ . '/cpt/init.php';

// Widgets
require_once __DIR__ . '/widgets/init.php';