<?php

// Set global var
global $edukul_galleries_config;

class WPEX_Galleries_Config {

	// Get things started.
	public function __construct() {

		if ( is_admin() ) {
			add_action( 'admin_menu', array( $this, 'add_page' ) );
			add_action( 'admin_init', array( $this,'register_page_options' ) );
			add_action( 'admin_notices', array( $this, 'setting_notice' ) );
		}	
	}

	// Add sub menu page for the Galleries Editor.
	public function add_page() {
		$edukul_galleries_editor = add_submenu_page(
			'edit.php?post_type=gallery',
			esc_html__( 'Archive Page', 'edukul' ),
			esc_html__( 'Archive Page', 'edukul' ),
			'administrator',
			'wpex-galleries-editor',
			array( $this, 'create_admin_page' )
		);
		add_action( 'load-'. $edukul_galleries_editor, array( $this, 'flush_rewrite_rules' ) );
	}

	// Flush re-write rules
	public static function flush_rewrite_rules() {
		$screen = get_current_screen();
		if ( $screen->id == 'galleries_page_wpex-galleries-editor' ) {
			flush_rewrite_rules();
		}
	}

	// Function that will register the galleries editor admin page.
	public function register_page_options() {
		register_setting( 'edukul_galleries_options', 'edukul_galleries_editor', array( $this, 'sanitize' ) );
	}

	// Displays saved message after settings are successfully saved
	public static function setting_notice() {
		settings_errors( 'edukul_galleries_editor_page_notices' );
	}

	// Sanitizes input and saves theme_mods.
	public static function sanitize( $options ) {

		// Save values to theme mod
		if ( ! empty ( $options ) ) {
			// Not checkboxes
			foreach( $options as $key => $value ) {
				if ( $value ) {
					set_theme_mod( $key, $value );
				} else {
					remove_theme_mod( $key );
				}
			}

			// Add notice
			add_settings_error(
				'edukul_galleries_editor_page_notices',
				esc_attr( 'settings_updated' ),
				esc_html__( 'Settings saved.', 'edukul' ),
				'updated'
			);

		}

		// Lets delete the options as we are saving them into theme mods
		$options = '';
		return $options;
	}

	// Output for the actual Galleries Editor admin page.
	public static function create_admin_page() {

		// Delete option as we are using theme_mods instead
		delete_option( 'edukul_galleries_editor' ); ?>

		<div class="wrap">
			<h2><?php esc_html_e( 'Setting', 'edukul' ); ?></h2>
			<form method="post" action="options.php">
				<?php settings_fields( 'edukul_galleries_options' ); ?>
				<table class="form-table">
					<tr valign="top">
						<th scope="row"><?php esc_html_e( 'Archive Page', 'edukul' ); ?></th>
						<td><?php
						// Display dropdown of pages to select from
						wp_dropdown_pages( array(
							'echo'             => true,
							'selected'         => edukul_get_mod( 'galleries_page' ),
							'name'             => 'edukul_galleries_editor[galleries_page]',
							'show_option_none' => esc_html__( 'None', 'edukul' ),
							'exclude'          => get_option( 'page_for_posts' ),
						) ); ?></td>
					</tr>
				</table>
				<?php submit_button(); ?>
			</form>
		</div>
	<?php }
}
$edukul_galleries_config = new WPEX_Galleries_Config;