<?php
if ( ! defined('ABSPATH') ) {
	die('Please do not load this file directly!');
}

add_action('init', 'register_event_post_type');
/**
  * Register event post type
*/
function register_event_post_type() {
    $event_slug = 'event';

    $labels = array(
        'name'               => esc_html__( 'Events', 'edukul' ),
        'singular_name'      => esc_html__( 'Event Item', 'edukul' ),
        'add_new'            => esc_html__( 'Add New', 'edukul' ),
        'add_new_item'       => esc_html__( 'Add New Item', 'edukul' ),
        'new_item'           => esc_html__( 'New Item', 'edukul' ),
        'edit_item'          => esc_html__( 'Edit Item', 'edukul' ),
        'view_item'          => esc_html__( 'View Item', 'edukul' ),
        'all_items'          => esc_html__( 'All Items', 'edukul' ),
        'search_items'       => esc_html__( 'Search Items', 'edukul' ),
        'parent_item_colon'  => esc_html__( 'Parent Items:', 'edukul' ),
        'not_found'          => esc_html__( 'No items found.', 'edukul' ),
        'not_found_in_trash' => esc_html__( 'No items found in Trash.', 'edukul' )
    );

    $args = array(
        'labels'        => $labels,
        'rewrite'       => array( 'slug' => $event_slug ),
        'supports'      => array( 'title', 'editor', 'thumbnail' ),
        'public'        => true
    );

    register_post_type( 'event', $args );
}

add_filter( 'post_updated_messages', 'event_updated_messages' );
/**
  * Event update messages.
*/
function event_updated_messages( $messages ) {
    $post             = get_post();
    $post_type        = get_post_type( $post );
    $post_type_object = get_post_type_object( $post_type );

    $messages['event'] = array(
        0  => '', // Unused. Messages start at index 1.
        1  => esc_html__( 'Event updated.', 'edukul' ),
        2  => esc_html__( 'Custom field updated.', 'edukul' ),
        3  => esc_html__( 'Custom field deleted.', 'edukul' ),
        4  => esc_html__( 'Event updated.', 'edukul' ),
        5  => isset( $_GET['revision'] ) ? sprintf( esc_html__( 'Event restored to revision from %s', 'edukul' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => esc_html__( 'Event published.', 'edukul' ),
        7  => esc_html__( 'Event saved.', 'edukul' ),
        8  => esc_html__( 'Event submitted.', 'edukul' ),
        9  => sprintf(
            esc_html__( 'Event scheduled for: <strong>%1$s</strong>.', 'edukul' ),
            date_i18n( esc_html__( 'M j, Y @ G:i', 'edukul' ), strtotime( $post->post_date ) )
        ),
        10 => esc_html__( 'Event draft updated.', 'edukul' )
    );
    return $messages;
}

add_action( 'init', 'register_event_taxonomy' );
/**
  * Register event taxonomy
*/
function register_event_taxonomy() {
    $cat_slug = 'event_category';

    $labels = array(
        'name'                       => esc_html__( 'Event Categories', 'edukul' ),
        'singular_name'              => esc_html__( 'Category', 'edukul' ),
        'search_items'               => esc_html__( 'Search Categories', 'edukul' ),
        'menu_name'                  => esc_html__( 'Categories', 'edukul' ),
        'all_items'                  => esc_html__( 'All Categories', 'edukul' ),
        'parent_item'                => esc_html__( 'Parent Category', 'edukul' ),
        'parent_item_colon'          => esc_html__( 'Parent Category:', 'edukul' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'edukul' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'edukul' ),
        'edit_item'                  => esc_html__( 'Edit Category', 'edukul' ),
        'update_item'                => esc_html__( 'Update Category', 'edukul' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'edukul' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'edukul' ),
        'not_found'                  => esc_html__( 'No Category found.', 'edukul' ),
        'menu_name'                  => esc_html__( 'Categories', 'edukul' ),
    );
    $args = array(
        'labels'        => $labels,
        'rewrite'       => array('slug'=>$cat_slug),
        'hierarchical'  => true,
    );
    register_taxonomy( 'event_category', 'event', $args );
}