<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
	'showcase' => 'carousel',
	'items'		=> '4',
	'gap'		=> '30',
	'auto_scroll' => 'false',
	'loop' => 'false',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c',
	'column'		=> '3c',
	'column2'		=> '2c',
	'column3'		=> '1c'
), $atts ) );

$gap = intval( $gap );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( empty( $items ) ) return;

if ( $showcase == 'carousel' ) {

	if ( $show_arrows ) {
		$cls .= ' has-arrows' .' arrow-'. $arrow_color;
		if ( $arrow_position == 'center' ) {
		    $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
		} else {
		    $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
		}
	}

	if ( $show_bullets )
	    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 
}

$roles = array( 'lecturer' );
$users = get_users( array( 'role__in' => $roles, 'number' => $items ) );

if ( ! empty( $users ) ) { ?>

	<?php wp_enqueue_script( 'edukul-owlcarousel' ); ?>

	<div class="edukul-lecturers <?php echo esc_attr( $cls ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-loop="<?php echo esc_attr( $loop ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>"><div class="owl-carousel owl-theme">
	    <?php 
	    foreach ( $users as $user ) {
	    	$author_id = $user->ID;
	    	?>
		<div class="member-item clearfix">
			<div class="inner">
		        <div class="thumb">
					<?php echo get_avatar( $author_id, 370); ?>
				</div><!-- /.thumb -->
		 		
		 	    <div class="text-wrap">
			        <h4 class="name">
						<?php
						if ( $url = get_the_author_meta( 'user_singlebio', $author_id ) ) {
							echo '<a href="'. esc_url( $url ) .'">'. get_the_author_meta('display_name', $author_id ) .'</a>';
						} else {
							echo get_the_author_meta('display_name', $author_id );
						}
						?>
			        </h4>
			        
			        <div class="position"><?php echo get_the_author_meta( 'user_position', $author_id ); ?></div>

		            <ul class="socials clearfix">
		                <?php if ( $url = get_the_author_meta( 'user_twitter', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Twitter', 'edukul' ); ?>">
		                        <i class="core-icon-twitter"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_facebook', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Facebook', 'edukul' ); ?>">
		                        <i class="core-icon-facebook"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_instagram', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Instagram', 'edukul' ); ?>">
		                        <i class="core-icon-instagram"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_youtube', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Youtube', 'edukul' ); ?>">
		                        <i class="core-icon-youtube"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_tumblr', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Tumblr', 'edukul' ); ?>">
		                        <i class="core-icon-tumblr"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_pinterest', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Pinterest', 'edukul' ); ?>">
		                        <i class="core-icon-pinterest"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_behance', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Behance', 'edukul' ); ?>">
		                        <i class="core-icon-behance"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_linkedin', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Linkedin', 'edukul' ); ?>">
		                        <i class="core-icon-linkedin"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_dribbble', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Dribbble', 'edukul' ); ?>">
		                        <i class="core-icon-dribbble"></i>
		                    </a></li>
		                <?php endif; ?>

		                <?php if ( $url = get_the_author_meta( 'user_vimeo', $author_id ) ) : ?>
		                    <li><a href="<?php echo esc_url( $url ); ?>" title="<?php echo esc_attr__( 'Vimeo', 'edukul' ); ?>">
		                        <i class="core-icon-vimeo"></i>
		                    </a></li>
		                <?php endif; ?>
		            </ul>
			    </div>
		    </div><!-- /.inner -->
		</div>
		<?php } ?>
	</div></div>
<?php }


