<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = $css = '';

extract( shortcode_atts( array(
	'style' => 'dark',
	'align' => 'text-center',
	'background' => '#f7f7f7',
	'bg_image' => '',
	'padding' => '',
	'plan_name' => '',
	'button_style' => 'accent'
), $atts ) );

if ( empty( $plan_name ) ) {
	return;
}

$loop = new WP_Query( array(
	'post_type'      => EDR_PT_MEMBERSHIP,
	'post_status'    => 'publish',
	'order'          => 'ASC',
	'orderby'        => 'menu_order',
	'name' => $plan_name
) );

$cls = $style .' '. $align .' button-'. $button_style;

if ( $background ) $css .= 'background-color:'. $background .';';
if ( $bg_image ) $css .= 'background-image:url('. wp_get_attachment_image_src( $bg_image, 'full' )[0] .');';
if ( $padding ) $css .= 'padding:'. $padding .';';

if ( $loop->have_posts() ) :
	?>
	<div class="edukul-membership <?php esc_attr_e( $cls ); ?>" style="<?php esc_attr_e( $css ); ?>">
		<?php
		while ( $loop->have_posts() ) {
			$loop->the_post();
			?>
				<?php Edr_View::template_part( 'content', 'membership' ); ?>
			<?php
		}
		?>
	</div>
	<?php
	wp_reset_postdata();
endif;