<?php
$keyses = array(
	'a' => array(
		'href' => array(),
		'title' => array(),
		'target' => array(),
		),
	'br' => array(),
	'em' => array(),
	'strong' => array(),
);
vc_map( array(
    'name'			=> esc_html__( 'Webnus GoogleMaps', 'easyweb' ),
	'description'	=> esc_html__( 'Google map', 'easyweb' ),
    'base'			=> 'gmap',
    'icon'			=> 'webnus-google-map',
	'category'		=> esc_html__( 'Webnus Shortcodes', 'easyweb' ),
    'params'		=> array(
    	array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Map center Latitude', 'easyweb') ,
			'description'		=> wp_kses( __('please enter map center Latitude<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'lat_center',
			'std'				=> '39.596165',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Map center Longitude', 'easyweb') ,
			'description'		=> wp_kses( __('please enter map center Longitude<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'lon_center',
			'std'				=> '-102.810059',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Zoom', 'easyweb') ,
			'description'		=> wp_kses( __('Default map zoom level. (1-19)<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'zoom_map',
			'std'				=> '9',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Zoom After click on marker', 'easyweb') ,
			'description'		=> wp_kses( __('Default map zoom level after click on marker. (1-19)<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'zoom_click',
			'std'				=> '17',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Width', 'easyweb') ,
			'description'		=> wp_kses( __('Set to 0 is the full width. (0-960)<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'width',
			'std'				=> '0',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'textfield',
			'heading'			=> esc_html__('Height', 'easyweb') ,
			'description'		=> wp_kses( __('Default is 400.<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'height',
			'std'				=> '400',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'			=> 'checkbox',
			'heading'		=> esc_html__('Display Map Types', 'easyweb') ,
			'description'	=> wp_kses( __('You can see Map Types <a href="https://developers.google.com/maps/documentation/javascript/maptypes" target="_blank">Here</a><br>', 'easyweb'), $keyses ),
			'param_name'	=> 'map_type_display',
			'std'			=> 'true',
			'group'			=> esc_html__( 'General', 'easyweb' ),
		),
		array(
			'type'			=> 'checkbox',
			'heading'		=> esc_html__('Select Map Types', 'easyweb') ,
			'description'	=> wp_kses( __('Select your map type.<br/><br/>', 'easyweb'), $keyses ),
			'param_name'	=> 'map_type',
			'value'			=> array(
				esc_html__( 'Roadmap', 'easyweb' )								=> '\'roadmap\'',
				esc_html__( 'Terrain (load with Roadmap type)', 'easyweb' )	=> '\'terrain\'',
				esc_html__( 'Satellite', 'easyweb' ) 							=> '\'satellite\'',
				esc_html__( 'Hybrid (load with Satellite type)', 'easyweb' )	=> '\'hybrid\'',
			),
			'std'			=> '\'roadmap\'',
			'group'			=> esc_html__( 'General', 'easyweb' ),
			'dependency'	=> array( 'element'=>'map_type_display', 'value' => 'true' ),
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Draggable feature', 'easyweb') ,
			'description'		=> wp_kses( __('Enable Draggable feature. see <a href="https://developers.google.com/maps/documentation/javascript/markers#draggable" target="_blank">Here</a> for more information.<br/><br/>', 'easyweb'), $keyses ),
			'std'				=> 'true',
			'param_name'		=> 'draggable',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Drop Animation', 'easyweb') ,
			'std'				=> 'true',
			'description'		=> wp_kses( __('Drop Animation for markers. see <a href="https://developers.google.com/maps/documentation/javascript/examples/marker-animations" target="_blank">Here</a> for more information.<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'animation',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Zoom Control', 'easyweb') ,
			'std'				=> 'true',
			'description'		=> wp_kses( __('The Zoom control displays "+" and "-" buttons for changing the zoom level of the map.<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'zoom_control_display',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Scrollwheel', 'easyweb') ,
			'std'				=> 'true',
			'description'		=> wp_kses( __('This feature stops zoom in/out your map when your page scrolls up and down from Google map section, so only the page will scroll.<br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'scrollwheel',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Street View Control', 'easyweb') ,
			'std'				=> 'true',
			'description'		=> wp_kses( __('You can see Documentation <a href="https://developers.google.com/maps/documentation/ios-sdk/streetview" target="_blank">Here</a><br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'street_view',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'checkbox',
			'heading'			=> esc_html__('Enable Scale Control', 'easyweb') ,
			'std'				=> 'true',
			'description'		=> wp_kses( __('You can see Documentation <a href="https://developers.google.com/maps/documentation/javascript/controls#DefaultUI" target="_blank">Here</a><br/><br/>', 'easyweb'), $keyses ),
			'param_name'		=> 'scale_control',
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'colorpicker',
			'heading'			=> esc_html__('Background Color', 'easyweb'),
			'param_name'		=> 'bg_color',
			'description'		=> wp_kses( __('Select map background color.', 'easyweb'), $keyses ),
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		array(
			'type'				=> 'colorpicker',
			'heading'			=> esc_html__('Hue', 'easyweb'),
			'param_name'		=> 'hue',
			'description'		=> wp_kses( __('You can see Hue example <a href="https://developers.google.com/maps/documentation/javascript/styling" target="_blank">Here</a><br/><br/>', 'easyweb'), $keyses ),
			'group'				=> esc_html__( 'General', 'easyweb' ),
			'edit_field_class'	=> 'vc_col-sm-6',
		),
		
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Custom Marker', 'easyweb' ),
			'description'	=> esc_html__( 'You can select an image for your marker. if you want seperate marker for eack point, you should set it in Addresses tab.', 'easyweb'),
			'param_name'	=> 'custom_marker',
			'value'			=> '',
			'group'			=> esc_html__( 'General', 'easyweb' ),
		),
		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Info Box Title', 'easyweb' ),
			'description'	=> esc_html__( 'Information Box title', 'easyweb'),
			'param_name'	=> 'info_box_title',
			'value'			=> '',
			'group'			=> esc_html__( 'Information Box', 'easyweb' ),
		),
		
		array(
			'type'			=> 'textarea',
			'heading'		=> esc_html__( 'Info Box Description', 'easyweb' ),
			'description'	=> esc_html__( 'Information Box Description', 'easyweb'),
			'param_name'	=> 'info_box_desc',
			'value'			=> '',
			'group'			=> esc_html__( 'Information Box', 'easyweb' ),
		),

		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Google map', 'easyweb' ),
			'description'	=> esc_html__( ' Please Add Your Item ', 'easyweb' ),
			'param_name'	=> 'map_points',
			'value' 		=> '',
			'params'		=> array(
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__( ' Latitude ', 'easyweb' ),
					'description'		=> esc_html__( ' Please enter your Latitude ', 'easyweb' ),
					'param_name'		=> 'latitude',
					'value'				=> '',
					'edit_field_class'	=> 'vc_col-sm-6',
					'admin_label'		=> true,
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__( ' Longitude ', 'easyweb' ),
					'description'		=> esc_html__( ' Please enter your Longitude ', 'easyweb' ),
					'param_name'		=> 'longitude',
					'value'				=> '',
					'edit_field_class'	=> 'vc_col-sm-6 webnus_col-sm-6',
					'admin_label'		=> true,
				),
				array(
					'type'				=> 'textarea',
					'heading'			=> esc_html__( ' Address/Info ', 'easyweb' ),
					'description'		=> esc_html__( ' Please enter your Address or information about this point. It Appears after click on Icon marker.', 'easyweb' ),
					'param_name'		=> 'address',
					'value'				=> '',
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__( ' Location Title ', 'easyweb' ),
					'description'		=> esc_html__( ' Define the place with a location, and a query string ', 'easyweb' ),
					'param_name'		=> 'location_title',
					'value'				=> '',
					'edit_field_class'	=> 'vc_col-sm-6',
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__( ' Location Website ', 'easyweb' ),
					'description'		=> esc_html__( ' Define the place with a location, and a query string ', 'easyweb' ),
					'param_name'		=> 'location_website',
					'value'				=> '',
					'edit_field_class'	=> 'vc_col-sm-6',
				),
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Custom point Marker', 'easyweb' ),
					'description'	=> esc_html__( 'You can select an image for your marker seperately', 'easyweb'),
					'param_name'	=> 'custom_marker_s',
					'value'			=> '',
				),
			),
			'group'		=> esc_html__( 'Addresses', 'easyweb' ),
		),
	),   
) );