<?php

class Dvents_Social_Icon_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Social_Icon_Widget',
			__( 'Social icon', 'ova-dvents' ),
			array( 'description' => __( 'Social icon', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
	    $html = $args['before_widget'];
		$html.= '<li class="social-net__item">
                     <a class="social-net__link text-primary_h" target="_blank" href="'.$instance['link'].'" ><i class="icon fa '.$instance['icon'].'"></i></a>
                 </li>';
		$html.= $args['after_widget'];
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$icon = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
		$info_value = ! empty( $instance['info_value'] ) ? $instance['info_value'] : '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>">
				<?php echo __( 'Icon:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'icon' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'icon' ) ); ?>"
                    type="text"
                    value="<?php echo __( $icon ); ?>"
            >
            <p> <?php echo __( "For example: fa-facebook. Find here: http://fontawesome.io/icons/", 'ova-dvents' ) ?> </p>

        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>">
				<?php echo  __( 'Link:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'link' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'link' ) ); ?>"
                    type="text"
                    value="<?php echo __( $info_value ); ?>"
            >
        </p>

		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['icon'] = ( ! empty( $new_instance['icon'] ) ) ? strip_tags( $new_instance['icon'] ) : '';
		$instance['link'] = ( ! empty( $new_instance['link'] ) ) ? strip_tags( $new_instance['link'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Social_Icon_Widget() {
	register_widget( 'Dvents_Social_Icon_Widget' );
}
add_action( 'widgets_init', 'Register_Dvents_Social_Icon_Widget' );