<?php

class Dvents_Gallery_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'Dvents_Gallery_Widget',
			__( 'Dvents gallery', 'ova-dvents' ),
			array( 'description' => __( 'Show text', 'ova-dvents' ), )
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$limit = ! empty( $instance['limit'] ) ? $instance['limit'] : '6';
		$order = ! empty( $instance['order'] ) ? $instance['order'] : 'ASC';

		$html = isset($args['before_widget'])?$args['before_widget']:'';
		if (!empty($instance['title'])){
		    $html .= $args['before_title'].$instance['title'].$args['after_title'];
        }

		$args = array(
			'post_type'   => 'gallery',
			'post_status' => array( 'publish' ),
			'meta_key'    => 'dvents_met_gallery_order',
			'orderby'     => 'meta_value_num',
			'order'       => $order,
			'posts_per_page' => $limit
		);
		$query = new WP_Query( $args );


		$html .= '<ul class="footer-gallery list-unstyled js-zoom-gallery clearfix">';
        while ($query->have_posts()) {
	        $query->the_post();
	        $src = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'full');
	        $html .= '<li class="footer-gallery__item">
                    <a href="'.$src[0].'" class="footer-gallery__link js-zoom-gallery__item">
                    <img src="'.$src[0].'" alt="'.get_the_title(get_the_ID()).'" class="img-responsive"/>
                    </a>
                 </li>';
        }
		$html.='</ul>';
		$html .= (isset($args['after_widget']))?$args['after_widget']:'';
		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$title       = ! empty( $instance['title'] ) ? $instance['title'] : '';
		$limit = ! empty( $instance['limit'] ) ? $instance['limit'] : '6';
		$order = ! empty( $instance['order'] ) ? $instance['order'] : 'ASC';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo __( 'Title:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'title' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'title' ) ); ?>"
                    type="text"
                    value="<?php echo __( $title ); ?>"
            >
        </p>


        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'limit' ) ); ?>">
				<?php echo __( 'Limit:', 'ova-dvents' ); ?>
            </label>
            <input
                    class="widefat" id="<?php echo __( $this->get_field_id( 'limit' ) ); ?>"
                    name="<?php echo __( $this->get_field_name( 'limit' ) ); ?>"
                    type="text"
                    value="<?php echo __( $limit ); ?>"
            >
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'order' ) ); ?>">
				<?php echo __( 'Order:', 'ova-dvents' ); ?>
            </label>
            <select class="widefat" id="<?php echo __( $this->get_field_id( 'order' ) ); ?>"   name="<?php echo __( $this->get_field_name( 'order' ) ); ?>" >
                <option value="<?php echo __( 'ASC', 'ova-dvents' ); ?>" <?php echo $order == 'ASC'?'checked':'' ?>  ><?php echo __( 'ASC', 'ova-dvents' ); ?></option>
                <option value="<?php echo __( 'DESC', 'ova-dvents' ); ?>" <?php echo $order == 'DESC'?'checked':'' ?> ><?php echo __( 'DESC', 'ova-dvents' ); ?></option>
            </select>
        </p>


		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance         = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['limit'] = ( ! empty( $new_instance['limit'] ) ) ? strip_tags( $new_instance['limit'] ) : '';
		$instance['order'] = ( ! empty( $new_instance['order'] ) ) ? strip_tags( $new_instance['order'] ) : '';
		return $instance;
	}

}

/**
 * register blog search widget
 */
function Register_Dvents_Gallery_Widget() {
	register_widget( 'Dvents_Gallery_Widget' );
}

add_action( 'widgets_init', 'Register_Dvents_Gallery_Widget' );